/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MutableMOScope;
import org.snmp4j.smi.OID;

public class DefaultMOScope
implements MOScope,
MutableMOScope {
    protected OID lowerBound;
    protected OID upperBound;
    protected boolean lowerIncluded;
    protected boolean upperIncluded;

    public DefaultMOScope(OID lowerBound, boolean lowerIncluded, OID upperBound, boolean upperIncluded) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerIncluded = lowerIncluded;
        this.upperIncluded = upperIncluded;
    }

    public DefaultMOScope(MOScope other) {
        this.lowerBound = other.getLowerBound();
        this.upperBound = other.getUpperBound();
        this.lowerIncluded = other.isLowerIncluded();
        this.upperIncluded = other.isUpperIncluded();
    }

    public OID getLowerBound() {
        return this.lowerBound;
    }

    public OID getUpperBound() {
        return this.upperBound;
    }

    public boolean isLowerIncluded() {
        return this.lowerIncluded;
    }

    public boolean isUpperIncluded() {
        return this.upperIncluded;
    }

    public boolean isCovered(MOScope other) {
        return DefaultMOScope.covers(this, other);
    }

    public boolean isOverlapping(MOScope other) {
        return DefaultMOScope.overlaps(this, other);
    }

    public void setLowerBound(OID lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setLowerIncluded(boolean lowerIncluded) {
        this.lowerIncluded = lowerIncluded;
    }

    public void setUpperBound(OID upperBound) {
        this.upperBound = upperBound;
    }

    public void setUpperIncluded(boolean upperIncluded) {
        this.upperIncluded = upperIncluded;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MOScope) {
            MOScope other = (MOScope)obj;
            return this.lowerBound.equals(other.getLowerBound()) && (this.upperBound == null && other.getUpperBound() == null || this.upperBound.equals(other.getUpperBound())) && this.lowerIncluded == other.isLowerIncluded() && this.upperIncluded == other.isUpperIncluded();
        }
        return false;
    }

    public int hashCode() {
        return this.lowerBound.hashCode();
    }

    public boolean covers(MOScope covered) {
        return DefaultMOScope.covers(this, covered);
    }

    public static boolean covers(MOScope scope, MOScope covered) {
        int lowerResult = scope.getLowerBound().compareTo(covered.getLowerBound());
        if (lowerResult < 0 || lowerResult == 0 && scope.isLowerIncluded()) {
            if (scope.getUpperBound() == null) {
                return true;
            }
            int upperResult = scope.getUpperBound().compareTo(covered.getLowerBound());
            if (upperResult > 0 || upperResult == 0 && scope.isUpperIncluded() && covered.isLowerIncluded()) {
                return true;
            }
        }
        return false;
    }

    public static boolean overlaps(MOScope scope, MOScope intersected) {
        OID iUpper = intersected.getUpperBound();
        if (iUpper == null) {
            if (scope.getUpperBound() == null) {
                return true;
            }
            int upperResult = scope.getUpperBound().compareTo(intersected.getLowerBound());
            return upperResult > 0 || upperResult == 0 && scope.isUpperIncluded() && intersected.isLowerIncluded();
        }
        int lowerResult = scope.getLowerBound().compareTo(iUpper);
        int upperResult = 1;
        if (scope.getUpperBound() != null) {
            upperResult = scope.getUpperBound().compareTo(intersected.getLowerBound());
        }
        if (lowerResult == 0 && scope.isLowerIncluded() && intersected.isUpperIncluded()) {
            return true;
        }
        if (upperResult == 0 && scope.isUpperIncluded() && intersected.isLowerIncluded()) {
            return true;
        }
        return lowerResult < 0 && upperResult > 0;
    }

    public void substractScope(MOScope scope) {
        if (this.lowerBound.compareTo(scope.getUpperBound()) <= 0) {
            this.lowerBound = scope.getUpperBound();
            this.lowerIncluded = !scope.isUpperIncluded();
        }
    }

    public boolean covers(OID oid) {
        if (oid == null) {
            return false;
        }
        return (this.getLowerBound().compareTo(oid) < 0 || this.isLowerIncluded() && this.getLowerBound().equals(oid)) && (this.getUpperBound() == null || this.getUpperBound().compareTo(oid) > 0 || this.isUpperIncluded() && this.getUpperBound().equals(oid));
    }

    public boolean isEmpty() {
        return this.lowerBound != null && this.upperBound != null && (this.lowerBound.compareTo(this.upperBound) > 0 || this.lowerBound.equals(this.upperBound) && (!this.isLowerIncluded() || !this.isUpperIncluded()));
    }

    public String toString() {
        return this.getClass().getName() + "[lowerBound=" + this.lowerBound + ",lowerIncluded=" + this.lowerIncluded + ",upperBound=" + this.upperBound + ",upperIncluded=" + this.upperIncluded + "]";
    }
}

