/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOScope;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class DefaultMOContextScope
extends DefaultMOScope
implements MOContextScope {
    private OctetString context;

    public DefaultMOContextScope(OctetString context, OID lowerBound, boolean lowerIncluded, OID upperBound, boolean upperIncluded) {
        super(lowerBound, lowerIncluded, upperBound, upperIncluded);
        this.context = context;
    }

    public DefaultMOContextScope(MOContextScope scope) {
        super(scope.getLowerBound(), scope.isLowerIncluded(), scope.getUpperBound(), scope.isUpperIncluded());
        this.context = scope.getContext();
    }

    public DefaultMOContextScope(OctetString context, MOScope extendedScope) {
        super(extendedScope);
        this.context = context;
    }

    public OctetString getContext() {
        return this.context;
    }

    public void setContext(OctetString context) {
        this.context = context;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MOContextScope) {
            MOContextScope other = (MOContextScope)obj;
            return this.context.equals(other.getContext()) && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        if (this.context != null) {
            int hash = super.hashCode();
            for (int i = 0; i < this.context.length(); ++i) {
                hash += this.context.get(i);
                hash += hash << 10;
                hash ^= hash >> 6;
            }
            hash += hash << 3;
            hash ^= hash >> 11;
            hash += hash << 15;
            return hash;
        }
        return super.hashCode();
    }

    public static final boolean isContextMatching(MOScope a, MOScope b) {
        if (a instanceof MOContextScope && b instanceof MOContextScope) {
            OctetString ca = ((MOContextScope)a).getContext();
            OctetString cb = ((MOContextScope)b).getContext();
            if (ca != null && !ca.equals(cb)) {
                return false;
            }
        }
        return true;
    }

    public boolean isCovered(MOScope other) {
        if (this.context != null && other instanceof MOContextScope && !this.context.equals(((MOContextScope)other).getContext())) {
            return false;
        }
        return DefaultMOContextScope.covers(this, other);
    }

    public String toString() {
        return this.getClass().getName() + "[context=" + this.context + ",lowerBound=" + this.lowerBound + ",lowerIncluded=" + this.lowerIncluded + ",upperBound=" + this.upperBound + ",upperIncluded=" + this.upperIncluded + "]";
    }

    public boolean isOverlapping(MOScope other) {
        if (!DefaultMOContextScope.isContextMatching(this, other)) {
            return false;
        }
        return super.isOverlapping(other);
    }
}

