/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.agent.cfg.EngineBootsProvider;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.io.MOServerPersistence;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.snmp.NotificationLogMib;
import org.snmp4j.agent.mo.snmp.NotificationOriginatorImpl;
import org.snmp4j.agent.mo.snmp.ProxyForwarderImpl;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpFrameworkMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpProxyMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.mo.snmp.UsmMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.agent.mo.snmp4j.Snmp4jConfigMib;
import org.snmp4j.agent.mo.snmp4j.Snmp4jLogMib;
import org.snmp4j.agent.mo.util.MOTableSizeLimit;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.agent.version.VersionInfo;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.WorkerPool;

public class AgentConfigManager
implements Runnable {
    private static final LogAdapter logger = LogFactory.getLogger(AgentConfigManager.class);
    public static final int STATE_CREATED = 0;
    public static final int STATE_INITIALIZED = 10;
    public static final int STATE_CONFIGURED = 20;
    public static final int STATE_RESTORED = 30;
    public static final int STATE_SUSPENDED = 35;
    public static final int STATE_RUNNING = 40;
    public static final int STATE_UNSAVED_CHANGES = 45;
    public static final int STATE_SAVED = 50;
    public static final int STATE_SHUTDOWN = -1;
    protected CommandProcessor agent;
    protected WorkerPool workerPool;
    protected VACM vacm;
    protected USM usm;
    protected MOServer[] servers;
    protected Session session;
    protected MessageDispatcher dispatcher;
    protected OctetString engineID;
    protected ProxyForwarder proxyForwarder;
    protected NotificationOriginator notificationOriginator;
    protected MOInputFactory configuration;
    protected MOPersistenceProvider persistenceProvider;
    protected int persistenceImportMode = 2;
    protected EngineBootsProvider engineBootsProvider;
    protected SNMPv2MIB snmpv2MIB;
    protected SnmpTargetMIB targetMIB;
    protected SnmpCommunityMIB communityMIB;
    protected SnmpNotificationMIB notificationMIB;
    protected SnmpFrameworkMIB frameworkMIB;
    protected UsmMIB usmMIB;
    protected VacmMIB vacmMIB;
    protected SnmpProxyMIB proxyMIB;
    protected Snmp4jLogMib snmp4jLogMIB;
    protected Snmp4jConfigMib snmp4jConfigMIB;
    protected NotificationLogMib notificationLogMIB;
    protected UnsignedInteger32 notificationLogDefaultLimit = new UnsignedInteger32(100);
    protected UnsignedInteger32 notificaitonLogGlobalLimit = new UnsignedInteger32(1000);
    protected UnsignedInteger32 notificaitonLogGlobalAge = new UnsignedInteger32(0);
    protected MOFactory moFactory = DefaultMOFactory.getInstance();
    protected OctetString sysDescr = new OctetString("SNMP4J-Agent " + VersionInfo.getVersion() + " [" + org.snmp4j.version.VersionInfo.getVersion() + "]" + " - " + System.getProperty("os.name", "") + " - " + System.getProperty("os.arch") + " - " + System.getProperty("os.version"));
    protected OID sysOID = new OID("1.3.6.1.4.1.4976.10");
    protected Integer32 sysServices = new Integer32(72);
    protected OctetString defaultContext;
    protected AgentState runState = new AgentState();
    protected MOTableSizeLimit tableSizeLimit;

    public AgentConfigManager(OctetString agentsOwnEngineID, MessageDispatcher messageDispatcher, VACM vacm, MOServer[] moServers, WorkerPool workerPool, MOInputFactory configurationFactory, MOPersistenceProvider persistenceProvider, EngineBootsProvider engineBootsProvider) {
        this.engineID = agentsOwnEngineID;
        this.dispatcher = messageDispatcher;
        this.vacm = vacm;
        this.servers = moServers;
        this.workerPool = workerPool;
        this.configuration = configurationFactory;
        this.engineBootsProvider = engineBootsProvider;
        this.persistenceProvider = persistenceProvider;
    }

    public AgentConfigManager(OctetString agentsOwnEngineID, MessageDispatcher messageDispatcher, VACM vacm, MOServer[] moServers, WorkerPool workerPool, MOInputFactory configurationFactory, MOPersistenceProvider persistenceProvider, EngineBootsProvider engineBootsProvider, MOFactory moFactory) {
        this(agentsOwnEngineID, messageDispatcher, vacm, moServers, workerPool, configurationFactory, persistenceProvider, engineBootsProvider);
        this.moFactory = moFactory == null ? this.moFactory : moFactory;
    }

    public void run() {
        if (this.runState.getState() < 10) {
            this.initialize();
        }
        if (this.runState.getState() < 20) {
            this.configure();
        }
        if (this.runState.getState() < 30) {
            this.restoreState();
        }
        if (this.runState.getState() < 40) {
            this.launch();
        }
    }

    public int getState() {
        return this.runState.getState();
    }

    public VACM getVACM() {
        return this.vacm;
    }

    public SNMPv2MIB getSNMPv2MIB() {
        return this.snmpv2MIB;
    }

    public SnmpTargetMIB getSnmpTargetMIB() {
        return this.targetMIB;
    }

    public SnmpNotificationMIB getSnmpNotificationMIB() {
        return this.notificationMIB;
    }

    public SnmpCommunityMIB getSnmpCommunityMIB() {
        return this.communityMIB;
    }

    protected void launch() {
        if (this.tableSizeLimit != null) {
            for (int i = 0; i < this.servers.length; ++i) {
                DefaultMOServer.unregisterTableRowListener(this.servers[i], this.tableSizeLimit);
                DefaultMOServer.registerTableRowListener(this.servers[i], this.tableSizeLimit);
            }
        }
        this.dispatcher.removeCommandResponder(this.agent);
        this.dispatcher.addCommandResponder(this.agent);
        this.registerTransportMappings();
        try {
            this.launchTransportMappings();
        }
        catch (IOException ex) {
            String txt = "Could not put all transport mappings in listen mode: " + ex.getMessage();
            logger.error(txt, ex);
            this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 40, ex));
        }
        this.runState.advanceState(40);
        this.fireLaunchNotifications();
    }

    protected void fireLaunchNotifications() {
        if (this.notificationOriginator != null) {
            this.notificationOriginator.notify(new OctetString(), SnmpConstants.coldStart, new VariableBinding[0]);
        }
    }

    public boolean continueProcessing() {
        if (this.runState.getState() == 35) {
            this.dispatcher.removeCommandResponder(this.agent);
            this.dispatcher.addCommandResponder(this.agent);
            this.runState.setState(40);
            return true;
        }
        return false;
    }

    public void suspendProcessing() {
        this.dispatcher.removeCommandResponder(this.agent);
        this.runState.setState(35);
    }

    public void shutdown() {
        this.suspendProcessing();
        try {
            this.session.close();
            this.session = null;
        }
        catch (IOException ex) {
            logger.warn("Failed to close SNMP session: " + ex.getMessage());
        }
        this.saveState();
        if (this.tableSizeLimit != null) {
            for (int i = 0; i < this.servers.length; ++i) {
                DefaultMOServer.unregisterTableRowListener(this.servers[i], this.tableSizeLimit);
            }
        }
        this.unregisterMIBs(null);
        this.runState.setState(-1);
    }

    public void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                AgentConfigManager.this.shutdown();
            }
        });
    }

    public void initSnmp4jLogMIB() {
        this.snmp4jLogMIB = new Snmp4jLogMib();
    }

    public void initSnmp4jConfigMIB(MOPersistenceProvider[] persistenceProvider) {
        this.snmp4jConfigMIB = new Snmp4jConfigMib(this.snmpv2MIB.getSysUpTime());
        this.snmp4jConfigMIB.setSnmpCommunityMIB(this.communityMIB);
        if (this.persistenceProvider != null) {
            this.snmp4jConfigMIB.setPrimaryProvider(this.persistenceProvider);
        }
        if (persistenceProvider != null) {
            for (int i = 0; i < persistenceProvider.length; ++i) {
                if (persistenceProvider[i] == this.persistenceProvider) continue;
                this.snmp4jConfigMIB.addPersistenceProvider(persistenceProvider[i]);
            }
        }
    }

    protected void initNotificationLogMIB(VACM vacm, SnmpNotificationMIB notifyMIB) {
        this.notificationLogMIB = new NotificationLogMib(this.moFactory, vacm, notifyMIB);
        NotificationLogMib.NlmConfigLogEntryRow row = (NotificationLogMib.NlmConfigLogEntryRow)this.notificationLogMIB.getNlmConfigLogEntry().createRow(new OID(new int[]{0}), new Variable[]{new OctetString(), this.notificationLogDefaultLimit, new Integer32(1), new Integer32(), new Integer32(4), new Integer32(1)});
        this.notificationLogMIB.getNlmConfigLogEntry().addRow(row);
        this.notificationLogMIB.getNlmConfigGlobalAgeOut().setValue(this.notificaitonLogGlobalAge);
        this.notificationLogMIB.getNlmConfigGlobalEntryLimit().setValue(this.notificaitonLogGlobalLimit);
        if (this.notificationOriginator instanceof NotificationOriginatorImpl) {
            ((NotificationOriginatorImpl)this.notificationOriginator).removeNotificationLogListener(this.notificationLogMIB);
            ((NotificationOriginatorImpl)this.notificationOriginator).addNotificationLogListener(this.notificationLogMIB);
        }
    }

    protected void initSecurityModels(EngineBootsProvider engineBootsProvider) {
        this.usm = this.createUSM();
        SecurityModels.getInstance().addSecurityModel(this.usm);
        this.frameworkMIB = new SnmpFrameworkMIB(this.usm, this.dispatcher.getTransportMappings());
    }

    protected void initMessageDispatcherWithMPs(MessageDispatcher mp) {
        mp.addMessageProcessingModel(new MPv1());
        mp.addMessageProcessingModel(new MPv2c());
        MPv3 mpv3 = new MPv3(this.agent.getContextEngineID().getValue());
        mp.addMessageProcessingModel(mpv3);
    }

    protected void registerTransportMappings() {
        ArrayList l = new ArrayList(this.dispatcher.getTransportMappings());
        Iterator it = l.iterator();
        while (it.hasNext()) {
            TransportMapping tm = (TransportMapping)it.next();
            tm.removeTransportListener(this.dispatcher);
            tm.addTransportListener(this.dispatcher);
        }
    }

    protected void launchTransportMappings() throws IOException {
        AgentConfigManager.launchTransportMappings(this.dispatcher.getTransportMappings());
    }

    protected static void launchTransportMappings(Collection transportMappings) throws IOException {
        ArrayList l = new ArrayList(transportMappings);
        Iterator it = l.iterator();
        while (it.hasNext()) {
            TransportMapping tm = (TransportMapping)it.next();
            if (tm.isListening()) continue;
            tm.listen();
        }
    }

    protected static void stopTransportMappings(Collection transportMappings) throws IOException {
        ArrayList l = new ArrayList(transportMappings);
        Iterator it = l.iterator();
        while (it.hasNext()) {
            TransportMapping tm = (TransportMapping)it.next();
            if (!tm.isListening()) continue;
            tm.close();
        }
    }

    public void saveState() {
        if (this.persistenceProvider != null) {
            try {
                this.persistenceProvider.store(this.persistenceProvider.getDefaultURI());
                this.runState.advanceState(50);
            }
            catch (IOException ex) {
                String txt = "Failed to save agent state: " + ex.getMessage();
                logger.error(txt, ex);
                this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 50, ex));
            }
        }
    }

    public boolean restoreState() {
        if (this.persistenceProvider != null) {
            try {
                this.persistenceProvider.restore(this.persistenceProvider.getDefaultURI(), this.persistenceImportMode);
                this.runState.advanceState(30);
                return true;
            }
            catch (FileNotFoundException fnf) {
                String txt = "Saved agent state not found: " + fnf.getMessage();
                logger.warn(txt);
            }
            catch (IOException ex) {
                String txt = "Failed to load agent state: " + ex.getMessage();
                logger.error(txt, ex);
                this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 30, ex));
            }
        }
        return false;
    }

    public void configure() {
        if (this.configuration != null) {
            MOInput config = this.configuration.createMOInput();
            if (config == null) {
                logger.debug("No configuration returned by configuration factory " + this.configuration);
                return;
            }
            MOServerPersistence serverPersistence = new MOServerPersistence(this.servers);
            try {
                serverPersistence.loadData(config);
            }
            catch (IOException ex) {
                String txt = "Failed to load agent configuration: " + ex.getMessage();
                logger.error(txt, ex);
                this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 20, ex));
                throw new RuntimeException(txt, ex);
            }
            finally {
                try {
                    config.close();
                }
                catch (IOException ex1) {
                    logger.warn("Failed to close config input stream: " + ex1.getMessage());
                }
            }
        }
        this.runState.advanceState(20);
    }

    protected void initMandatoryMIBs() {
        this.targetMIB = new SnmpTargetMIB(this.dispatcher);
        this.targetMIB.addDefaultTDomains();
        this.snmpv2MIB = new SNMPv2MIB(this.getSysDescr(), this.getSysOID(), this.getSysServices());
        this.notificationMIB = new SnmpNotificationMIB();
        this.vacmMIB = new VacmMIB(this.servers);
        this.usmMIB = new UsmMIB(this.usm, this.getSupportedSecurityProtocols());
        this.usm.addUsmUserListener(this.usmMIB);
        this.communityMIB = new SnmpCommunityMIB(this.targetMIB);
    }

    protected void linkCounterListener() {
        this.agent.removeCounterListener(this.snmpv2MIB);
        this.agent.addCounterListener(this.snmpv2MIB);
        this.usm.getCounterSupport().removeCounterListener(this.snmpv2MIB);
        this.usm.getCounterSupport().addCounterListener(this.snmpv2MIB);
    }

    protected SecurityProtocols getSupportedSecurityProtocols() {
        SecurityProtocols.getInstance().addDefaultProtocols();
        return SecurityProtocols.getInstance();
    }

    protected USM createUSM() {
        return new USM(this.getSupportedSecurityProtocols(), this.engineID, this.engineBootsProvider.updateEngineBoots());
    }

    public Integer32 getSysServices() {
        return this.sysServices;
    }

    public OID getSysOID() {
        return this.sysOID;
    }

    public OctetString getSysDescr() {
        return this.sysDescr;
    }

    public SysUpTime getSysUpTime() {
        return this.snmpv2MIB.getSysUpTime();
    }

    public NotificationOriginator getNotificationOriginator() {
        return this.notificationOriginator;
    }

    public NotificationOriginator getAgentNotificationOriginator() {
        return this.agent.getNotificationOriginator();
    }

    public void setNotificationOriginator(NotificationOriginator notificationOriginator) {
        this.notificationOriginator = notificationOriginator;
        if (this.agent != null) {
            this.agent.setNotificationOriginator(notificationOriginator);
        }
    }

    private VACM vacm() {
        if (this.vacm != null) {
            return this.vacm;
        }
        return this.vacmMIB;
    }

    public void initialize() {
        this.session = this.createSnmpSession(this.dispatcher);
        if (this.engineID == null) {
            this.engineID = new OctetString(MPv3.createLocalEngineID());
        }
        this.agent = this.createCommandProcessor(this.engineID);
        this.agent.setWorkerPool(this.workerPool);
        this.initSecurityModels(this.engineBootsProvider);
        this.initMessageDispatcherWithMPs(this.dispatcher);
        this.initMandatoryMIBs();
        this.linkCounterListener();
        this.agent.setVacm(this.vacm());
        for (int i = 0; i < this.servers.length; ++i) {
            this.agent.addMOServer(this.servers[i]);
        }
        this.agent.setCoexistenceProvider(this.communityMIB);
        if (this.notificationOriginator == null) {
            this.notificationOriginator = this.createNotificationOriginator();
        }
        this.agent.setNotificationOriginator(this.notificationOriginator);
        this.snmpv2MIB.setNotificationOriginator(this.agent);
        this.initOptionalMIBs();
        try {
            this.registerMIBs(this.getDefaultContext());
        }
        catch (DuplicateRegistrationException drex) {
            logger.error("Duplicate MO registration: " + drex.getMessage(), drex);
        }
        this.runState.advanceState(10);
    }

    public void setTableSizeLimits(Properties sizeLimits) {
        int i;
        if (this.tableSizeLimit != null && this.servers != null) {
            for (i = 0; i < this.servers.length; ++i) {
                DefaultMOServer.unregisterTableRowListener(this.servers[i], this.tableSizeLimit);
            }
        }
        this.tableSizeLimit = new MOTableSizeLimit(sizeLimits);
        if (this.getState() == 40) {
            for (i = 0; i < this.servers.length; ++i) {
                DefaultMOServer.registerTableRowListener(this.servers[i], this.tableSizeLimit);
            }
        }
    }

    public void setTableSizeLimit(int sizeLimit) {
        int i;
        if (this.tableSizeLimit != null && this.servers != null) {
            for (i = 0; i < this.servers.length; ++i) {
                DefaultMOServer.unregisterTableRowListener(this.servers[i], this.tableSizeLimit);
            }
        }
        this.tableSizeLimit = new MOTableSizeLimit(sizeLimit);
        if (this.getState() == 40) {
            for (i = 0; i < this.servers.length; ++i) {
                DefaultMOServer.registerTableRowListener(this.servers[i], this.tableSizeLimit);
            }
        }
    }

    protected void initOptionalMIBs() {
        this.initSnmp4jLogMIB();
        this.initSnmp4jConfigMIB(null);
        if (this.vacm() != null && this.notificationMIB != null) {
            this.initNotificationLogMIB(this.vacm(), this.notificationMIB);
        }
    }

    public OctetString getDefaultContext() {
        return this.defaultContext;
    }

    protected OctetString getContext(MOGroup mibGroup, OctetString defaultContext) {
        return defaultContext;
    }

    protected void registerMIBs(OctetString context) throws DuplicateRegistrationException {
        MOServer server = this.agent.getServer(context);
        this.targetMIB.registerMOs(server, this.getContext(this.targetMIB, context));
        this.notificationMIB.registerMOs(server, this.getContext(this.notificationMIB, context));
        this.vacmMIB.registerMOs(server, this.getContext(this.vacmMIB, context));
        this.usmMIB.registerMOs(server, this.getContext(this.usmMIB, context));
        this.snmpv2MIB.registerMOs(server, this.getContext(this.snmpv2MIB, context));
        this.frameworkMIB.registerMOs(server, this.getContext(this.frameworkMIB, context));
        this.communityMIB.registerMOs(server, this.getContext(this.communityMIB, context));
        if (this.snmp4jLogMIB != null) {
            this.snmp4jLogMIB.registerMOs(server, this.getContext(this.snmp4jLogMIB, context));
        }
        if (this.snmp4jConfigMIB != null) {
            this.snmp4jConfigMIB.registerMOs(server, this.getContext(this.snmp4jConfigMIB, context));
        }
        if (this.proxyMIB != null) {
            this.proxyMIB.registerMOs(server, this.getContext(this.proxyMIB, context));
        }
        if (this.notificationLogMIB != null) {
            this.notificationLogMIB.registerMOs(server, this.getContext(this.notificationLogMIB, context));
        }
    }

    protected void unregisterMIBs(OctetString context) {
        MOServer server = this.agent.getServer(context);
        this.targetMIB.unregisterMOs(server, this.getContext(this.targetMIB, context));
        this.notificationMIB.unregisterMOs(server, this.getContext(this.notificationMIB, context));
        this.vacmMIB.unregisterMOs(server, this.getContext(this.vacmMIB, context));
        this.usmMIB.unregisterMOs(server, this.getContext(this.usmMIB, context));
        this.snmpv2MIB.unregisterMOs(server, this.getContext(this.snmpv2MIB, context));
        this.frameworkMIB.unregisterMOs(server, this.getContext(this.frameworkMIB, context));
        this.communityMIB.unregisterMOs(server, this.getContext(this.communityMIB, context));
        if (this.snmp4jLogMIB != null) {
            this.snmp4jLogMIB.unregisterMOs(server, this.getContext(this.snmp4jLogMIB, context));
        }
        if (this.snmp4jConfigMIB != null) {
            this.snmp4jConfigMIB.unregisterMOs(server, this.getContext(this.targetMIB, context));
        }
        if (this.proxyMIB != null) {
            this.proxyMIB.unregisterMOs(server, this.getContext(this.proxyMIB, context));
        }
        if (this.notificationLogMIB != null) {
            this.notificationLogMIB.unregisterMOs(server, this.getContext(this.notificationLogMIB, context));
        }
    }

    public void setupProxyForwarder() {
        this.proxyForwarder = this.createProxyForwarder(this.agent);
    }

    protected NotificationOriginator createNotificationOriginator() {
        return new NotificationOriginatorImpl(this.session, this.vacm(), this.snmpv2MIB.getSysUpTime(), this.targetMIB, this.notificationMIB);
    }

    protected ProxyForwarder createProxyForwarder(CommandProcessor agent) {
        this.proxyMIB = new SnmpProxyMIB();
        ProxyForwarderImpl pf = new ProxyForwarderImpl(this.session, this.proxyMIB, this.targetMIB);
        agent.addProxyForwarder(pf, null, 0);
        pf.addCounterListener(this.snmpv2MIB);
        return this.proxyForwarder;
    }

    protected CommandProcessor createCommandProcessor(OctetString engineID) {
        return new CommandProcessor(engineID);
    }

    protected Session createSnmpSession(MessageDispatcher dispatcher) {
        return new Snmp(dispatcher);
    }

    public void setPersistenceImportMode(int importMode) {
        this.persistenceImportMode = importMode;
    }

    public int getPersistenceImportMode() {
        return this.persistenceImportMode;
    }

    static class ErrorDescriptor {
        private Exception exception;
        private int sourceState;
        private int targetState;
        private String description;

        ErrorDescriptor(String descr, int sourceState, int targetState, Exception ex) {
            this.description = descr;
            this.sourceState = sourceState;
            this.targetState = targetState;
            this.exception = ex;
        }

        public String getDescription() {
            return this.description;
        }

        public int getSourceState() {
            return this.sourceState;
        }

        public int getTargetState() {
            return this.targetState;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public class AgentState {
        private int state = 0;
        private List errorsOccured = new LinkedList();

        public int getState() {
            return this.state;
        }

        void setState(int newState) {
            this.state = newState;
            logger.info("Agent state set to " + newState);
        }

        void advanceState(int newState) {
            if (this.state < newState) {
                this.state = newState;
                logger.info("Agent state advanced to " + newState);
            }
        }

        void addError(ErrorDescriptor error) {
            this.errorsOccured.add(error);
        }

        public List getErrors() {
            return new ArrayList(this.errorsOccured);
        }
    }
}

