/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class SnmpTimer {
    private LinkedList<TimeoutElement> m_list;
    private Thread m_thread;
    private boolean m_exit = false;
    private Object m_sync = new Object();

    SnmpTimer() {
        this.m_list = new LinkedList();
        this.m_thread = new Thread((Runnable)new Scheduler(), "SnmpTimer");
        this.m_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable runner, long milliseconds) {
        if (runner != null) {
            Object object = this.m_sync;
            synchronized (object) {
                this.m_list.add(new TimeoutElement(milliseconds, runner));
                this.m_sync.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Object object = this.m_sync;
        synchronized (object) {
            this.m_exit = true;
            this.m_sync.notify();
        }
        try {
            if (!this.m_thread.equals(Thread.currentThread())) {
                this.m_thread.join();
            }
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
        }
    }

    private class Scheduler
    implements Runnable {
        private Scheduler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList<Runnable> toRun = new LinkedList<Runnable>();
            while (true) {
                Object object = SnmpTimer.this.m_sync;
                synchronized (object) {
                    if (SnmpTimer.this.m_exit) {
                        return;
                    }
                    if (SnmpTimer.this.m_list.size() == 0) {
                        try {
                            SnmpTimer.this.m_sync.wait();
                        }
                        catch (InterruptedException err) {
                            return;
                        }
                    }
                    long now = System.currentTimeMillis();
                    boolean done = false;
                    long minTime = Long.MAX_VALUE;
                    ListIterator iter = SnmpTimer.this.m_list.listIterator(0);
                    while (!done && iter.hasNext()) {
                        try {
                            TimeoutElement elem = (TimeoutElement)iter.next();
                            if (now > elem.m_when) {
                                toRun.add(elem.m_toRun);
                                iter.remove();
                                continue;
                            }
                            if (elem.m_when >= minTime) continue;
                            minTime = elem.m_when;
                        }
                        catch (NoSuchElementException err) {
                            done = true;
                        }
                        catch (ConcurrentModificationException err) {
                            done = true;
                        }
                    }
                    if (toRun.size() == 0) {
                        minTime -= now;
                        try {
                            if (minTime > 0L) {
                                SnmpTimer.this.m_sync.wait(minTime);
                            }
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
                if (toRun.size() == 0) continue;
                ListIterator iter = toRun.listIterator(0);
                try {
                    while (true) {
                        Runnable runner = (Runnable)iter.next();
                        iter.remove();
                        runner.run();
                    }
                }
                catch (NoSuchElementException err) {}
                finally {
                    continue;
                }
                break;
            }
        }
    }

    private class TimeoutElement {
        public Runnable m_toRun;
        public long m_when;

        TimeoutElement(long offset, Runnable what) {
            this.m_when = System.currentTimeMillis() + offset;
            this.m_toRun = what;
        }
    }
}

