/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpInt32
implements SnmpSyntax,
Cloneable,
Serializable {
    private int m_value;
    static final long serialVersionUID = -3472172482048507843L;
    public static final byte ASNTYPE = 2;

    public SnmpInt32() {
        this.m_value = 0;
    }

    public SnmpInt32(int value) {
        this.m_value = value;
    }

    public SnmpInt32(Integer value) {
        this.m_value = value;
    }

    public SnmpInt32(SnmpInt32 second) {
        this.m_value = second.m_value;
    }

    public SnmpInt32(String value) {
        if (value == null) {
            throw new NullPointerException("The constructor argument may not be null");
        }
        this.m_value = Integer.parseInt(value);
    }

    public int getValue() {
        return this.m_value;
    }

    public void setValue(int value) {
        this.m_value = value;
    }

    public void setValue(Integer value) {
        this.m_value = value;
    }

    @Override
    public byte typeId() {
        return 2;
    }

    @Override
    public int encodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnEncodingException {
        return encoder.buildInteger32(buf, offset, this.typeId(), this.m_value);
    }

    @Override
    public int decodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnDecodingException {
        Object[] rVals = encoder.parseInteger32(buf, offset);
        if (((Byte)rVals[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        this.m_value = (Integer)rVals[2];
        return (Integer)rVals[0];
    }

    @Override
    public SnmpSyntax duplicate() {
        return new SnmpInt32(this);
    }

    public Object clone() {
        return new SnmpInt32(this);
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnmpInt32) {
            SnmpInt32 int32 = (SnmpInt32)obj;
            return this.typeId() == int32.typeId() && this.getValue() == int32.getValue();
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public static Integer toInteger(SnmpInt32 val) {
        return val == null ? null : new Integer(val.getValue());
    }
}

