/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JAgentConfig;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValue;
import org.snmp4j.PDU;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class Snmp4JV2TrapBuilder
implements SnmpTrapBuilder {
    private Snmp4JStrategy m_strategy;
    private PDU m_pdu;

    protected Snmp4JV2TrapBuilder(Snmp4JStrategy strategy, PDU pdu, int type) {
        this.m_strategy = strategy;
        this.m_pdu = pdu;
        this.m_pdu.setType(type);
    }

    protected Snmp4JV2TrapBuilder(Snmp4JStrategy strategy) {
        this(strategy, new PDU(), -89);
    }

    protected PDU getPDU() {
        return this.m_pdu;
    }

    @Override
    public void send(String destAddr, int destPort, String community) throws Exception {
        SnmpAgentConfig snmpAgentConfig = this.m_strategy.buildAgentConfig(destAddr, destPort, community, this.m_pdu);
        Snmp4JAgentConfig agentConfig = new Snmp4JAgentConfig(snmpAgentConfig);
        this.m_strategy.send(agentConfig, this.m_pdu, false);
    }

    public SnmpValue[] sendInform(String destAddr, int destPort, int timeout, int retries, String community) throws Exception {
        SnmpAgentConfig snmpAgentConfig = this.m_strategy.buildAgentConfig(destAddr, destPort, timeout, retries, community, this.m_pdu);
        Snmp4JAgentConfig agentConfig = new Snmp4JAgentConfig(snmpAgentConfig);
        return this.m_strategy.send(agentConfig, this.m_pdu, true);
    }

    public void send(String destAddr, int destPort, int securityLevel, String securityName, String authPassPhrase, String authProtocol, String privPassPhrase, String privProtocol) throws Exception {
        SnmpAgentConfig snmpAgentConfig = this.m_strategy.buildAgentConfig(destAddr, destPort, securityLevel, securityName, authPassPhrase, authProtocol, privPassPhrase, privProtocol, this.m_pdu);
        Snmp4JAgentConfig agentConfig = new Snmp4JAgentConfig(snmpAgentConfig);
        this.m_strategy.send(agentConfig, this.m_pdu, false);
    }

    public SnmpValue[] sendInform(String destAddr, int destPort, int timeout, int retries, int securityLevel, String securityName, String authPassPhrase, String authProtocol, String privPassPhrase, String privProtocol) throws Exception {
        SnmpAgentConfig snmpAgentConfig = this.m_strategy.buildAgentConfig(destAddr, destPort, timeout, retries, securityLevel, securityName, authPassPhrase, authProtocol, privPassPhrase, privProtocol, this.m_pdu);
        Snmp4JAgentConfig agentConfig = new Snmp4JAgentConfig(snmpAgentConfig);
        return this.m_strategy.send(agentConfig, this.m_pdu, true);
    }

    @Override
    public void addVarBind(SnmpObjId name, SnmpValue value) {
        OID oid = new OID(name.getIds());
        Variable val = ((Snmp4JValue)value).getVariable();
        this.m_pdu.add(new VariableBinding(oid, val));
    }

    @Override
    public void sendTest(String destAddr, int destPort, String community) throws Exception {
        this.m_strategy.sendTest(destAddr, destPort, community, this.m_pdu);
    }
}

