/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ColumnTracker;
import org.opennms.netmgt.snmp.PduBuilder;
import org.opennms.netmgt.snmp.ResponseProcessor;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.RowResultFactory;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpTableResult;
import org.opennms.netmgt.snmp.SnmpValue;

public class TableTracker
extends CollectionTracker
implements RowCallback,
RowResultFactory {
    private final SnmpTableResult m_tableResult;
    private final List<ColumnTracker> m_columnTrackers;

    public TableTracker(SnmpObjId ... ids) {
        this((RowCallback)null, ids);
    }

    public TableTracker(RowCallback rc, SnmpObjId ... ids) {
        this(rc, 2, ids);
    }

    public TableTracker(RowCallback rc, int maxRepetitions, SnmpObjId ... columns) {
        this.m_tableResult = new SnmpTableResult(rc == null ? this : rc, this, columns);
        this.m_columnTrackers = new ArrayList<ColumnTracker>(columns.length);
        for (SnmpObjId id : columns) {
            this.m_columnTrackers.add(new ColumnTracker(this, id, maxRepetitions));
        }
    }

    @Override
    public void setMaxRepetitions(int maxRepetitions) {
        for (ColumnTracker child : this.m_columnTrackers) {
            child.setMaxRepetitions(maxRepetitions);
        }
    }

    @Override
    public boolean isFinished() {
        if (super.isFinished()) {
            return true;
        }
        for (ColumnTracker ct : this.m_columnTrackers) {
            if (ct.isFinished()) continue;
            return false;
        }
        this.m_tableResult.tableFinished();
        this.setFinished(true);
        return true;
    }

    @Override
    public ResponseProcessor buildNextPdu(PduBuilder pduBuilder) {
        if (pduBuilder.getMaxVarsPerPdu() < 1) {
            throw new IllegalArgumentException("maxVarsPerPdu < 1");
        }
        ArrayList<ResponseProcessor> processors = new ArrayList<ResponseProcessor>(pduBuilder.getMaxVarsPerPdu());
        for (ColumnTracker ct : this.getNextColumnTrackers(pduBuilder.getMaxVarsPerPdu())) {
            processors.add(ct.buildNextPdu(pduBuilder));
        }
        return new CombinedColumnResponseProcessor(processors);
    }

    @Override
    public void storeResult(SnmpResult res) {
        ThreadCategory.getInstance(SnmpResult.class).debug(String.format("storeResult: %s", res));
        this.m_tableResult.storeResult(res);
    }

    @Override
    public void rowCompleted(SnmpRowResult row) {
        for (SnmpResult result : row.getResults()) {
            super.storeResult(result);
        }
    }

    @Override
    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return this.m_tableResult.createRowResult(columnCount, instance);
    }

    private List<ColumnTracker> getNextColumnTrackers(int maxVarsPerPdu) {
        ArrayList<ColumnTracker> trackers = new ArrayList<ColumnTracker>(maxVarsPerPdu);
        ArrayList<ColumnTracker> sortedTrackerList = new ArrayList<ColumnTracker>(this.m_columnTrackers);
        Collections.sort(sortedTrackerList, new Comparator<ColumnTracker>(){

            @Override
            public int compare(ColumnTracker o1, ColumnTracker o2) {
                return new CompareToBuilder().append(o1.getLastInstance(), o2.getLastInstance()).toComparison();
            }
        });
        Iterator it = sortedTrackerList.iterator();
        while (it.hasNext() && trackers.size() < maxVarsPerPdu) {
            ColumnTracker tracker = (ColumnTracker)it.next();
            if (tracker.isFinished()) continue;
            trackers.add(tracker);
        }
        return trackers;
    }

    private static class CombinedColumnResponseProcessor
    implements ResponseProcessor {
        private final List<ResponseProcessor> m_processors;
        private int m_currentIndex = 0;

        public CombinedColumnResponseProcessor(List<ResponseProcessor> processors) {
            this.m_processors = processors;
        }

        @Override
        public void processResponse(SnmpObjId responseObjId, SnmpValue val) {
            try {
                ResponseProcessor rp = this.m_processors.get(this.m_currentIndex);
                if (++this.m_currentIndex == this.m_processors.size()) {
                    this.m_currentIndex = 0;
                }
                rp.processResponse(responseObjId, val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean processErrors(int errorStatus, int errorIndex) {
            int columnIndex = (errorIndex - 1) % this.m_processors.size();
            ResponseProcessor rp = this.m_processors.get(columnIndex);
            return rp.processErrors(errorStatus, 1);
        }
    }
}

