/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="snmpConfiguration")
public class SnmpConfiguration {
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_PORT = 161;
    public static final int VERSION1 = 1;
    public static final int VERSION2C = 2;
    public static final int VERSION3 = 3;
    public static final int DEFAULT_VERSION = 1;
    public static final int DEFAULT_RETRIES = 1;
    public static final int DEFAULT_MAX_REQUEST_SIZE = 65535;
    public static final int NOAUTH_NOPRIV = 1;
    public static final int AUTH_NOPRIV = 2;
    public static final int AUTH_PRIV = 3;
    public static final String DEFAULT_READ_COMMUNITY = "public";
    public static final int DEFAULT_MAX_VARS_PER_PDU = 10;
    public static final int DEFAULT_MAX_REPETITIONS = 2;
    public static final String DEFAULT_WRITE_COMMUNITY = "private";
    public static final int DEFAULT_SECURITY_LEVEL = 1;
    public static final String DEFAULT_SECURITY_NAME = "opennmsUser";
    public static final String DEFAULT_AUTH_PASS_PHRASE = "0p3nNMSv3";
    public static final String DEFAULT_AUTH_PROTOCOL = "MD5";
    public static final String DEFAULT_PRIV_PROTOCOL = "DES";
    public static final String DEFAULT_PRIV_PASS_PHRASE = "0p3nNMSv3";
    public static final SnmpConfiguration DEFAULTS = new SnmpConfiguration(null);
    private int m_timeout;
    private int m_retries;
    private int m_port;
    private int m_version;
    private int m_maxRequestSize;
    private int m_securityLevel;
    private String m_securityName;
    private String m_readCommunity;
    private int m_maxVarsPerPdu;
    private int m_maxRepetitions;
    private String m_writeCommunity;
    private String m_authPassPhrase;
    private String m_authProtocol;
    private String m_privProtocol;
    private String m_privPassPhrase;

    public SnmpConfiguration() {
        this(DEFAULTS);
    }

    public SnmpConfiguration(SnmpConfiguration config) {
        if (config != null) {
            this.setAuthPassPhrase(config.getAuthPassPhrase());
            this.setAuthProtocol(config.getAuthProtocol());
            this.setMaxRepetitions(config.getMaxRepetitions());
            this.setMaxRequestSize(config.getMaxRequestSize());
            this.setMaxVarsPerPdu(config.getMaxVarsPerPdu());
            this.setPort(config.getPort());
            this.setPrivPassPhrase(config.getPrivPassPhrase());
            this.setPrivProtocol(config.getPrivProtocol());
            this.setReadCommunity(config.getReadCommunity());
            this.setSecurityLevel(config.getSecurityLevel());
            this.setSecurityName(config.getSecurityName());
            this.setTimeout(config.getTimeout());
            this.setVersion(config.getVersion());
            this.setWriteCommunity(config.getWriteCommunity());
        }
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    public String getVersionAsString() {
        return SnmpConfiguration.versionToString(this.getVersion());
    }

    public void setVersionAsString(String version) {
        this.setVersion(SnmpConfiguration.stringToVersion(version));
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public int getSecurityLevel() {
        return this.m_securityLevel;
    }

    public void setSecurityLevel(int securityLevel) {
        this.m_securityLevel = securityLevel;
    }

    public String getSecurityName() {
        return this.m_securityName;
    }

    public void setSecurityName(String securityName) {
        this.m_securityName = securityName;
    }

    public void setReadCommunity(String community) {
        this.m_readCommunity = community;
    }

    public int getMaxRequestSize() {
        return this.m_maxRequestSize;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.m_maxRequestSize = maxRequestSize;
    }

    public String getReadCommunity() {
        return this.m_readCommunity;
    }

    public int getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu;
    }

    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this.m_maxVarsPerPdu = maxVarsPerPdu;
    }

    public int getMaxRepetitions() {
        return this.m_maxRepetitions;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.m_maxRepetitions = maxRepetitions;
    }

    public String getWriteCommunity() {
        return this.m_writeCommunity;
    }

    public void setWriteCommunity(String community) {
        this.m_writeCommunity = community;
    }

    public static String versionToString(int version) {
        switch (version) {
            case 1: {
                return "v1";
            }
            case 2: {
                return "v2c";
            }
            case 3: {
                return "v3";
            }
        }
        return "unknown";
    }

    public static int stringToVersion(String version) {
        if ("v1".equalsIgnoreCase(version)) {
            return 1;
        }
        if ("v2c".equalsIgnoreCase(version)) {
            return 2;
        }
        if ("v3".equalsIgnoreCase(version)) {
            return 3;
        }
        return 1;
    }

    public String getAuthPassPhrase() {
        return this.m_authPassPhrase;
    }

    public void setAuthPassPhrase(String authPassPhrase) {
        this.m_authPassPhrase = authPassPhrase;
    }

    public String getPrivProtocol() {
        return this.m_privProtocol;
    }

    public void setPrivProtocol(String authPrivProtocol) {
        this.m_privProtocol = authPrivProtocol;
    }

    public String getAuthProtocol() {
        return this.m_authProtocol;
    }

    public void setAuthProtocol(String authProtocol) {
        this.m_authProtocol = authProtocol;
    }

    public String getPrivPassPhrase() {
        return this.m_privPassPhrase;
    }

    public void setPrivPassPhrase(String privPassPhrase) {
        this.m_privPassPhrase = privPassPhrase;
    }

    static {
        DEFAULTS.setTimeout(3000);
        DEFAULTS.setRetries(1);
        DEFAULTS.setPort(161);
        DEFAULTS.setVersion(1);
        DEFAULTS.setMaxRequestSize(65535);
        DEFAULTS.setSecurityLevel(1);
        DEFAULTS.setSecurityName(DEFAULT_SECURITY_NAME);
        DEFAULTS.setReadCommunity(DEFAULT_READ_COMMUNITY);
        DEFAULTS.setMaxVarsPerPdu(10);
        DEFAULTS.setMaxRepetitions(2);
        DEFAULTS.setWriteCommunity(DEFAULT_WRITE_COMMUNITY);
        DEFAULTS.setAuthPassPhrase("0p3nNMSv3");
        DEFAULTS.setAuthProtocol(DEFAULT_AUTH_PROTOCOL);
        DEFAULTS.setPrivProtocol(DEFAULT_PRIV_PROTOCOL);
        DEFAULTS.setPrivPassPhrase("0p3nNMSv3");
    }
}

