/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.math.BigInteger;
import java.net.InetAddress;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public abstract class AbstractSnmpValue
implements SnmpValue {
    private int m_type;

    public AbstractSnmpValue(int type) {
        this.m_type = type;
    }

    @Override
    public boolean isEndOfMib() {
        return false;
    }

    @Override
    public String toDisplayString() {
        return this.toString();
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public int toInt() {
        return (int)this.toLong();
    }

    @Override
    public InetAddress toInetAddress() {
        throw new IllegalArgumentException("Unable to convert " + this + " to an InetAddress");
    }

    @Override
    public long toLong() {
        throw new IllegalArgumentException("Unable to convert " + this + " to a number");
    }

    @Override
    public String toHexString() {
        throw new IllegalArgumentException("Unable to convert " + this + " to a hex string");
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public BigInteger toBigInteger() {
        throw new IllegalArgumentException("Unable to convert " + this + " to a big integer");
    }

    @Override
    public SnmpObjId toSnmpObjId() {
        throw new IllegalArgumentException("Unable to convert " + this + " to an SnmpObjId");
    }
}

