/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadCategory {
    private static final String DEFAULT_CATEGORY = "UNCATEGORIZED";
    private String messagePrefix = null;
    private final org.apache.log4j.Logger m_delegate;
    private static InheritableThreadLocal<String> s_threadCategory = new InheritableThreadLocal();

    protected ThreadCategory(String name) {
        this.m_delegate = org.apache.log4j.Logger.getLogger(name);
    }

    public static ThreadCategory getInstance(Class<?> c) {
        return ThreadCategory.getLog4jInstance(c);
    }

    public static ThreadCategory getLog4jInstance(Class<?> c) {
        return ThreadCategory.getLog4jInstance(c.getName());
    }

    public static Logger getSlf4jInstance(Class<?> c) {
        return ThreadCategory.getSlf4jInstance(c.getName());
    }

    public static ThreadCategory getInstance(String cname) {
        return ThreadCategory.getLog4jInstance(cname);
    }

    public static ThreadCategory getLog4jInstance(String cname) {
        String prefix = ThreadCategory.getPrefix();
        if (prefix != null && !prefix.equals("")) {
            return new ThreadCategory(prefix + "." + cname);
        }
        return new ThreadCategory(cname);
    }

    public static Logger getSlf4jInstance(String cname) {
        String prefix = ThreadCategory.getPrefix();
        if (prefix != null && !prefix.equals("")) {
            return LoggerFactory.getLogger(prefix + "." + cname);
        }
        return LoggerFactory.getLogger(cname);
    }

    public static ThreadCategory getInstance() {
        return ThreadCategory.getLog4jInstance();
    }

    public static ThreadCategory getLog4jInstance() {
        String prefix = ThreadCategory.getPrefix();
        if (prefix != null) {
            return new ThreadCategory(prefix);
        }
        return new ThreadCategory(DEFAULT_CATEGORY);
    }

    public static Logger getSlf4jInstance() {
        String prefix = ThreadCategory.getPrefix();
        if (prefix != null) {
            return LoggerFactory.getLogger(prefix);
        }
        return LoggerFactory.getLogger(DEFAULT_CATEGORY);
    }

    public static void setPrefix(String prefix) {
        s_threadCategory.set(prefix);
    }

    public static String getPrefix() {
        return (String)s_threadCategory.get();
    }

    public void debug(String message, Throwable t) {
        this.m_delegate.debug(this.messagePrefix == null ? message : this.messagePrefix + message, t);
    }

    public void debug(String message) {
        this.m_delegate.debug(this.messagePrefix == null ? message : this.messagePrefix + message);
    }

    public void error(String message, Throwable t) {
        this.m_delegate.error(this.messagePrefix == null ? message : this.messagePrefix + message, t);
    }

    public void error(String message) {
        this.m_delegate.error(this.messagePrefix == null ? message : this.messagePrefix + message);
    }

    public void fatal(String message, Throwable t) {
        this.m_delegate.fatal(this.messagePrefix == null ? message : this.messagePrefix + message, t);
    }

    public void fatal(String message) {
        this.m_delegate.fatal(this.messagePrefix == null ? message : this.messagePrefix + message);
    }

    public void info(String message, Throwable t) {
        this.m_delegate.info(this.messagePrefix == null ? message : this.messagePrefix + message, t);
    }

    public void info(String message) {
        this.m_delegate.info(message);
    }

    public void trace(String message, Throwable t) {
        this.m_delegate.trace(this.messagePrefix == null ? message : this.messagePrefix + message, t);
    }

    public void trace(String message) {
        this.m_delegate.trace(this.messagePrefix == null ? message : this.messagePrefix + message);
    }

    public void warn(String message, Throwable t) {
        this.m_delegate.warn(message, t);
    }

    public void warn(String message) {
        this.m_delegate.warn(message);
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public void clearMessagePrefix() {
        this.messagePrefix = null;
    }

    public void setMessagePrefix(String messagePrefix) {
        this.messagePrefix = messagePrefix;
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isEnabledFor(Level level) {
        switch (level) {
            case FATAL: {
                return this.m_delegate.isEnabledFor(org.apache.log4j.Level.FATAL);
            }
            case ERROR: {
                return this.m_delegate.isEnabledFor(org.apache.log4j.Level.ERROR);
            }
            case WARN: {
                return this.m_delegate.isEnabledFor(org.apache.log4j.Level.WARN);
            }
            case INFO: {
                return this.m_delegate.isEnabledFor(org.apache.log4j.Level.INFO);
            }
            case DEBUG: {
                return this.m_delegate.isEnabledFor(org.apache.log4j.Level.DEBUG);
            }
            case TRACE: {
                return this.m_delegate.isEnabledFor(org.apache.log4j.Level.TRACE);
            }
            case ALL: {
                return this.m_delegate.isEnabledFor(org.apache.log4j.Level.ALL);
            }
            case OFF: {
                return this.m_delegate.isEnabledFor(org.apache.log4j.Level.OFF);
            }
        }
        throw new IllegalArgumentException("Invalid logging level: " + (Object)((Object)level));
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public final String getName() {
        return this.m_delegate.getName();
    }

    public final Level getLevel() {
        switch (this.m_delegate.getLevel().toInt()) {
            case 50000: {
                return Level.FATAL;
            }
            case 40000: {
                return Level.ERROR;
            }
            case 30000: {
                return Level.WARN;
            }
            case 20000: {
                return Level.INFO;
            }
            case 10000: {
                return Level.DEBUG;
            }
            case 5000: {
                return Level.TRACE;
            }
            case -2147483648: {
                return Level.ALL;
            }
            case 0x7FFFFFFF: {
                return Level.OFF;
            }
        }
        throw new IllegalStateException("Invalid logging level set: " + this.m_delegate.getLevel());
    }

    public void setLevel(Level level) {
        switch (level) {
            case FATAL: {
                this.m_delegate.setLevel(org.apache.log4j.Level.FATAL);
                break;
            }
            case ERROR: {
                this.m_delegate.setLevel(org.apache.log4j.Level.ERROR);
                break;
            }
            case WARN: {
                this.m_delegate.setLevel(org.apache.log4j.Level.WARN);
                break;
            }
            case INFO: {
                this.m_delegate.setLevel(org.apache.log4j.Level.INFO);
                break;
            }
            case DEBUG: {
                this.m_delegate.setLevel(org.apache.log4j.Level.DEBUG);
                break;
            }
            case TRACE: {
                this.m_delegate.setLevel(org.apache.log4j.Level.TRACE);
                break;
            }
            case ALL: {
                this.m_delegate.setLevel(org.apache.log4j.Level.ALL);
                break;
            }
            case OFF: {
                this.m_delegate.setLevel(org.apache.log4j.Level.OFF);
            }
        }
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        ALL,
        OFF;

    }
}

