/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.access.DefaultLocatorFactory;

public abstract class BeanUtils {
    public static BeanFactoryReference getBeanFactory(String contextId) {
        BeanFactoryLocator beanFactoryLoader = DefaultLocatorFactory.getInstance();
        return beanFactoryLoader.useBeanFactory(contextId);
    }

    public static <T> T getBean(BeanFactoryReference beanFactory, String beanId, Class<T> clazz) {
        return clazz.cast(beanFactory.getFactory().getBean(beanId));
    }

    public static <T> T getBean(String contextId, String beanId, Class<T> clazz) {
        return BeanUtils.getBean(BeanUtils.getBeanFactory(contextId), beanId, clazz);
    }

    public static <T> T getFactory(String contextId, Class<T> clazz) {
        return (T)BeanUtils.getBeanFactory(contextId).getFactory();
    }
}

