/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.dom4j.Dom4jProxyFactory;
import org.hibernate.tuple.Dom4jInstantiator;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.AbstractComponentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dom4jEntityTuplizer
extends AbstractEntityTuplizer {
    static final Logger log = LoggerFactory.getLogger(Dom4jEntityTuplizer.class);
    private Set subclassNodeNames = new HashSet();

    Dom4jEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
        Iterator itr = mappedEntity.getSubclassClosureIterator();
        while (itr.hasNext()) {
            PersistentClass mapping = (PersistentClass)itr.next();
            this.subclassNodeNames.add(mapping.getNodeName());
        }
    }

    public EntityMode getEntityMode() {
        return EntityMode.DOM4J;
    }

    private PropertyAccessor buildPropertyAccessor(Property mappedProperty) {
        if (mappedProperty.isBackRef()) {
            return mappedProperty.getPropertyAccessor(null);
        }
        return PropertyAccessorFactory.getDom4jPropertyAccessor(mappedProperty.getNodeName(), mappedProperty.getType(), this.getEntityMetamodel().getSessionFactory());
    }

    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        return this.buildPropertyAccessor(mappedProperty).getGetter(null, mappedProperty.getName());
    }

    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        return this.buildPropertyAccessor(mappedProperty).getSetter(null, mappedProperty.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        return new Dom4jInstantiator(persistentClass);
    }

    public Serializable getIdentifier(Object entityOrId) throws HibernateException {
        if (entityOrId instanceof Element) {
            return super.getIdentifier(entityOrId);
        }
        return (Serializable)entityOrId;
    }

    protected ProxyFactory buildProxyFactory(PersistentClass mappingInfo, Getter idGetter, Setter idSetter) {
        HashSet<Class> proxyInterfaces = new HashSet<Class>();
        proxyInterfaces.add(HibernateProxy.class);
        proxyInterfaces.add(Element.class);
        Dom4jProxyFactory pf = new Dom4jProxyFactory();
        try {
            pf.postInstantiate(this.getEntityName(), Element.class, proxyInterfaces, null, null, mappingInfo.hasEmbeddedIdentifier() ? (AbstractComponentType)mappingInfo.getIdentifier().getType() : null);
        }
        catch (HibernateException he) {
            log.warn("could not create proxy factory for:" + this.getEntityName(), he);
            pf = null;
        }
        return pf;
    }

    public Class getMappedClass() {
        return Element.class;
    }

    public Class getConcreteProxyClass() {
        return Element.class;
    }

    public boolean isInstrumented() {
        return false;
    }
}

