/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.cache.FilterKey;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.QueryKey;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.EntityUniqueKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.engine.TwoPhaseLoad;
import org.hibernate.engine.TypedValue;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.impl.FetchingScrollableResultsImpl;
import org.hibernate.impl.ScrollableResultsImpl;
import org.hibernate.jdbc.ColumnNameCache;
import org.hibernate.jdbc.ResultSetWrapper;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Loader {
    private static final Logger log = LoggerFactory.getLogger(Loader.class);
    private final SessionFactoryImplementor factory;
    private ColumnNameCache columnNameCache;

    public Loader(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    protected abstract String getSQLString();

    protected abstract Loadable[] getEntityPersisters();

    protected boolean[] getEntityEagerPropertyFetches() {
        return null;
    }

    protected int[] getOwners() {
        return null;
    }

    protected EntityType[] getOwnerAssociationTypes() {
        return null;
    }

    protected CollectionPersister[] getCollectionPersisters() {
        return null;
    }

    protected int[] getCollectionOwners() {
        return null;
    }

    protected abstract LockMode[] getLockModes(Map var1);

    protected String applyLocks(String sql, Map lockModes, Dialect dialect) throws HibernateException {
        return sql;
    }

    protected boolean upgradeLocks() {
        return false;
    }

    protected boolean isSingleRowLoader() {
        return false;
    }

    protected String[] getAliases() {
        return null;
    }

    protected String preprocessSQL(String sql, QueryParameters parameters, Dialect dialect) throws HibernateException {
        sql = this.applyLocks(sql, parameters.getLockModes(), dialect);
        return this.getFactory().getSettings().isCommentsEnabled() ? this.prependComment(sql, parameters) : sql;
    }

    private String prependComment(String sql, QueryParameters parameters) {
        String comment = parameters.getComment();
        if (comment == null) {
            return sql;
        }
        return new StringBuffer(comment.length() + sql.length() + 5).append("/* ").append(comment).append(" */ ").append(sql).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doQueryAndInitializeNonLazyCollections(SessionImplementor session, QueryParameters queryParameters, boolean returnProxies) throws HibernateException, SQLException {
        List result;
        PersistenceContext persistenceContext = session.getPersistenceContext();
        persistenceContext.beforeLoad();
        try {
            result = this.doQuery(session, queryParameters, returnProxies);
        }
        finally {
            persistenceContext.afterLoad();
        }
        persistenceContext.initializeNonLazyCollections();
        return result;
    }

    public Object loadSingleRow(ResultSet resultSet, SessionImplementor session, QueryParameters queryParameters, boolean returnProxies) throws HibernateException {
        Object result;
        int entitySpan = this.getEntityPersisters().length;
        ArrayList hydratedObjects = entitySpan == 0 ? null : new ArrayList(entitySpan);
        try {
            result = this.getRowFromResultSet(resultSet, session, queryParameters, this.getLockModes(queryParameters.getLockModes()), null, hydratedObjects, new EntityKey[entitySpan], returnProxies);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not read next row of results", this.getSQLString());
        }
        this.initializeEntitiesAndCollections(hydratedObjects, resultSet, session, queryParameters.isReadOnly());
        session.getPersistenceContext().initializeNonLazyCollections();
        return result;
    }

    private Object sequentialLoad(ResultSet resultSet, SessionImplementor session, QueryParameters queryParameters, boolean returnProxies, EntityKey keyToRead) throws HibernateException {
        int entitySpan = this.getEntityPersisters().length;
        ArrayList hydratedObjects = entitySpan == 0 ? null : new ArrayList(entitySpan);
        Object result = null;
        EntityKey[] loadedKeys = new EntityKey[entitySpan];
        try {
            do {
                Object loaded = this.getRowFromResultSet(resultSet, session, queryParameters, this.getLockModes(queryParameters.getLockModes()), null, hydratedObjects, loadedKeys, returnProxies);
                if (result != null) continue;
                result = loaded;
            } while (keyToRead.equals(loadedKeys[0]) && resultSet.next());
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not perform sequential read of results (forward)", this.getSQLString());
        }
        this.initializeEntitiesAndCollections(hydratedObjects, resultSet, session, queryParameters.isReadOnly());
        session.getPersistenceContext().initializeNonLazyCollections();
        return result;
    }

    public Object loadSequentialRowsForward(ResultSet resultSet, SessionImplementor session, QueryParameters queryParameters, boolean returnProxies) throws HibernateException {
        try {
            if (resultSet.isAfterLast()) {
                return null;
            }
            if (resultSet.isBeforeFirst()) {
                resultSet.next();
            }
            EntityKey currentKey = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, session);
            return this.sequentialLoad(resultSet, session, queryParameters, returnProxies, currentKey);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not perform sequential read of results (forward)", this.getSQLString());
        }
    }

    public Object loadSequentialRowsReverse(ResultSet resultSet, SessionImplementor session, QueryParameters queryParameters, boolean returnProxies, boolean isLogicallyAfterLast) throws HibernateException {
        try {
            EntityKey checkKey;
            if (resultSet.isFirst()) {
                return null;
            }
            EntityKey keyToRead = null;
            if (resultSet.isAfterLast() && isLogicallyAfterLast) {
                resultSet.last();
                keyToRead = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, session);
            } else {
                resultSet.previous();
                boolean firstPass = true;
                EntityKey lastKey = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, session);
                while (resultSet.previous()) {
                    EntityKey checkKey2 = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, session);
                    if (firstPass) {
                        firstPass = false;
                        keyToRead = checkKey2;
                    }
                    if (lastKey.equals(checkKey2)) continue;
                }
            }
            while (resultSet.previous() && keyToRead.equals(checkKey = this.getKeyFromResultSet(0, this.getEntityPersisters()[0], null, resultSet, session))) {
            }
            resultSet.next();
            return this.sequentialLoad(resultSet, session, queryParameters, returnProxies, keyToRead);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not perform sequential read of results (forward)", this.getSQLString());
        }
    }

    private static EntityKey getOptionalObjectKey(QueryParameters queryParameters, SessionImplementor session) {
        Object optionalObject = queryParameters.getOptionalObject();
        Serializable optionalId = queryParameters.getOptionalId();
        String optionalEntityName = queryParameters.getOptionalEntityName();
        if (optionalObject != null && optionalEntityName != null) {
            return new EntityKey(optionalId, session.getEntityPersister(optionalEntityName, optionalObject), session.getEntityMode());
        }
        return null;
    }

    private Object getRowFromResultSet(ResultSet resultSet, SessionImplementor session, QueryParameters queryParameters, LockMode[] lockModeArray, EntityKey optionalObjectKey, List hydratedObjects, EntityKey[] keys, boolean returnProxies) throws SQLException, HibernateException {
        Loadable[] persisters = this.getEntityPersisters();
        int entitySpan = persisters.length;
        for (int i = 0; i < entitySpan; ++i) {
            keys[i] = this.getKeyFromResultSet(i, persisters[i], i == entitySpan - 1 ? queryParameters.getOptionalId() : null, resultSet, session);
        }
        this.registerNonExists(keys, persisters, session);
        Object[] row = this.getRow(resultSet, persisters, keys, queryParameters.getOptionalObject(), optionalObjectKey, lockModeArray, hydratedObjects, session);
        this.readCollectionElements(row, resultSet, session);
        if (returnProxies) {
            for (int i = 0; i < entitySpan; ++i) {
                Object entity = row[i];
                Object proxy = session.getPersistenceContext().proxyFor(persisters[i], keys[i], entity);
                if (entity == proxy) continue;
                ((HibernateProxy)proxy).getHibernateLazyInitializer().setImplementation(entity);
                row[i] = proxy;
            }
        }
        return this.getResultColumnOrRow(row, queryParameters.getResultTransformer(), resultSet, session);
    }

    private void readCollectionElements(Object[] row, ResultSet resultSet, SessionImplementor session) throws SQLException, HibernateException {
        CollectionPersister[] collectionPersisters = this.getCollectionPersisters();
        if (collectionPersisters != null) {
            CollectionAliases[] descriptors = this.getCollectionAliases();
            int[] collectionOwners = this.getCollectionOwners();
            for (int i = 0; i < collectionPersisters.length; ++i) {
                boolean hasCollectionOwners = collectionOwners != null && collectionOwners[i] > -1;
                Object owner = hasCollectionOwners ? row[collectionOwners[i]] : null;
                CollectionPersister collectionPersister = collectionPersisters[i];
                Serializable key = owner == null ? null : collectionPersister.getCollectionType().getKeyOfOwner(owner, session);
                this.readCollectionElement(owner, key, collectionPersister, descriptors[i], resultSet, session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doQuery(SessionImplementor session, QueryParameters queryParameters, boolean returnProxies) throws SQLException, HibernateException {
        RowSelection selection = queryParameters.getRowSelection();
        int maxRows = Loader.hasMaxRows(selection) ? selection.getMaxRows() : Integer.MAX_VALUE;
        int entitySpan = this.getEntityPersisters().length;
        ArrayList hydratedObjects = entitySpan == 0 ? null : new ArrayList(entitySpan * 10);
        PreparedStatement st = this.prepareQueryStatement(queryParameters, false, session);
        ResultSet rs = this.getResultSet(st, queryParameters.hasAutoDiscoverScalarTypes(), queryParameters.isCallable(), selection, session);
        LockMode[] lockModeArray = this.getLockModes(queryParameters.getLockModes());
        EntityKey optionalObjectKey = Loader.getOptionalObjectKey(queryParameters, session);
        boolean createSubselects = this.isSubselectLoadingEnabled();
        ArrayList<EntityKey[]> subselectResultKeys = createSubselects ? new ArrayList<EntityKey[]>() : null;
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            int count;
            this.handleEmptyCollections(queryParameters.getCollectionKeys(), rs, session);
            EntityKey[] keys = new EntityKey[entitySpan];
            if (log.isTraceEnabled()) {
                log.trace("processing result set");
            }
            for (count = 0; count < maxRows && rs.next(); ++count) {
                if (log.isTraceEnabled()) {
                    log.debug("result set row: " + count);
                }
                Object result = this.getRowFromResultSet(rs, session, queryParameters, lockModeArray, optionalObjectKey, hydratedObjects, keys, returnProxies);
                results.add(result);
                if (!createSubselects) continue;
                subselectResultKeys.add(keys);
                keys = new EntityKey[entitySpan];
            }
            if (log.isTraceEnabled()) {
                log.trace("done processing result set (" + count + " rows)");
            }
        }
        finally {
            session.getBatcher().closeQueryStatement(st, rs);
        }
        this.initializeEntitiesAndCollections(hydratedObjects, rs, session, queryParameters.isReadOnly());
        if (createSubselects) {
            this.createSubselects(subselectResultKeys, queryParameters, session);
        }
        return results;
    }

    protected boolean isSubselectLoadingEnabled() {
        return false;
    }

    protected boolean hasSubselectLoadableCollections() {
        Loadable[] loadables = this.getEntityPersisters();
        for (int i = 0; i < loadables.length; ++i) {
            if (!loadables[i].hasSubselectLoadableCollections()) continue;
            return true;
        }
        return false;
    }

    private static Set[] transpose(List keys) {
        Set[] result = new Set[((EntityKey[])keys.get(0)).length];
        for (int j = 0; j < result.length; ++j) {
            result[j] = new HashSet(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                result[j].add(((EntityKey[])keys.get(i))[j]);
            }
        }
        return result;
    }

    private void createSubselects(List keys, QueryParameters queryParameters, SessionImplementor session) {
        if (keys.size() > 1) {
            Set[] keySets = Loader.transpose(keys);
            Map namedParameterLocMap = this.buildNamedParameterLocMap(queryParameters);
            Loadable[] loadables = this.getEntityPersisters();
            String[] aliases = this.getAliases();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                EntityKey[] rowKeys = (EntityKey[])iter.next();
                for (int i = 0; i < rowKeys.length; ++i) {
                    if (rowKeys[i] == null || !loadables[i].hasSubselectLoadableCollections()) continue;
                    SubselectFetch subselectFetch = new SubselectFetch(aliases[i], loadables[i], queryParameters, keySets[i], namedParameterLocMap);
                    session.getPersistenceContext().getBatchFetchQueue().addSubselect(rowKeys[i], subselectFetch);
                }
            }
        }
    }

    private Map buildNamedParameterLocMap(QueryParameters queryParameters) {
        if (queryParameters.getNamedParameters() != null) {
            HashMap<String, int[]> namedParameterLocMap = new HashMap<String, int[]>();
            Iterator piter = queryParameters.getNamedParameters().keySet().iterator();
            while (piter.hasNext()) {
                String name = (String)piter.next();
                namedParameterLocMap.put(name, this.getNamedParameterLocs(name));
            }
            return namedParameterLocMap;
        }
        return null;
    }

    private void initializeEntitiesAndCollections(List hydratedObjects, Object resultSetId, SessionImplementor session, boolean readOnly) throws HibernateException {
        PostLoadEvent post;
        PreLoadEvent pre;
        CollectionPersister[] collectionPersisters = this.getCollectionPersisters();
        if (collectionPersisters != null) {
            for (int i = 0; i < collectionPersisters.length; ++i) {
                if (!collectionPersisters[i].isArray()) continue;
                this.endCollectionLoad(resultSetId, session, collectionPersisters[i]);
            }
        }
        if (session.isEventSource()) {
            pre = new PreLoadEvent((EventSource)session);
            post = new PostLoadEvent((EventSource)session);
        } else {
            pre = null;
            post = null;
        }
        if (hydratedObjects != null) {
            int hydratedObjectsSize = hydratedObjects.size();
            if (log.isTraceEnabled()) {
                log.trace("total objects hydrated: " + hydratedObjectsSize);
            }
            for (int i = 0; i < hydratedObjectsSize; ++i) {
                TwoPhaseLoad.initializeEntity(hydratedObjects.get(i), readOnly, session, pre, post);
            }
        }
        if (collectionPersisters != null) {
            for (int i = 0; i < collectionPersisters.length; ++i) {
                if (collectionPersisters[i].isArray()) continue;
                this.endCollectionLoad(resultSetId, session, collectionPersisters[i]);
            }
        }
    }

    private void endCollectionLoad(Object resultSetId, SessionImplementor session, CollectionPersister collectionPersister) {
        session.getPersistenceContext().getLoadContexts().getCollectionLoadContext((ResultSet)resultSetId).endLoadingCollections(collectionPersister);
    }

    protected List getResultList(List results, ResultTransformer resultTransformer) throws QueryException {
        return results;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultTransformer transformer, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return row;
    }

    private void registerNonExists(EntityKey[] keys, Loadable[] persisters, SessionImplementor session) {
        int[] owners = this.getOwners();
        if (owners != null) {
            EntityType[] ownerAssociationTypes = this.getOwnerAssociationTypes();
            for (int i = 0; i < keys.length; ++i) {
                boolean isOneToOneAssociation;
                int owner = owners[i];
                if (owner <= -1) continue;
                EntityKey ownerKey = keys[owner];
                if (keys[i] != null || ownerKey == null) continue;
                PersistenceContext persistenceContext = session.getPersistenceContext();
                boolean bl = isOneToOneAssociation = ownerAssociationTypes != null && ownerAssociationTypes[i] != null && ownerAssociationTypes[i].isOneToOne();
                if (!isOneToOneAssociation) continue;
                persistenceContext.addNullProperty(ownerKey, ownerAssociationTypes[i].getPropertyName());
            }
        }
    }

    private void readCollectionElement(Object optionalOwner, Serializable optionalKey, CollectionPersister persister, CollectionAliases descriptor, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        Serializable collectionRowKey = (Serializable)persister.readKey(rs, descriptor.getSuffixedKeyAliases(), session);
        if (collectionRowKey != null) {
            PersistentCollection rowCollection;
            Object owner;
            if (log.isDebugEnabled()) {
                log.debug("found row of collection: " + MessageHelper.collectionInfoString(persister, collectionRowKey, this.getFactory()));
            }
            if ((owner = optionalOwner) != null || (owner = persistenceContext.getCollectionOwner(collectionRowKey, persister)) == null) {
                // empty if block
            }
            if ((rowCollection = persistenceContext.getLoadContexts().getCollectionLoadContext(rs).getLoadingCollection(persister, collectionRowKey)) != null) {
                rowCollection.readFrom(rs, persister, descriptor, owner);
            }
        } else if (optionalKey != null) {
            if (log.isDebugEnabled()) {
                log.debug("result set contains (possibly empty) collection: " + MessageHelper.collectionInfoString(persister, optionalKey, this.getFactory()));
            }
            persistenceContext.getLoadContexts().getCollectionLoadContext(rs).getLoadingCollection(persister, optionalKey);
        }
    }

    private void handleEmptyCollections(Serializable[] keys, Object resultSetId, SessionImplementor session) {
        if (keys != null) {
            CollectionPersister[] collectionPersisters = this.getCollectionPersisters();
            for (int j = 0; j < collectionPersisters.length; ++j) {
                for (int i = 0; i < keys.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug("result set contains (possibly empty) collection: " + MessageHelper.collectionInfoString(collectionPersisters[j], keys[i], this.getFactory()));
                    }
                    session.getPersistenceContext().getLoadContexts().getCollectionLoadContext((ResultSet)resultSetId).getLoadingCollection(collectionPersisters[j], keys[i]);
                }
            }
        }
    }

    private EntityKey getKeyFromResultSet(int i, Loadable persister, Serializable id, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Serializable resultId;
        if (this.isSingleRowLoader() && id != null) {
            resultId = id;
        } else {
            boolean idIsResultId;
            Type idType = persister.getIdentifierType();
            resultId = (Serializable)idType.nullSafeGet(rs, this.getEntityAliases()[i].getSuffixedKeyAliases(), session, null);
            boolean bl = idIsResultId = id != null && resultId != null && idType.isEqual(id, resultId, session.getEntityMode(), this.factory);
            if (idIsResultId) {
                resultId = id;
            }
        }
        return resultId == null ? null : new EntityKey(resultId, persister, session.getEntityMode());
    }

    private void checkVersion(int i, Loadable persister, Serializable id, Object entity, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object currentVersion;
        VersionType versionType;
        Object version = session.getPersistenceContext().getEntry(entity).getVersion();
        if (version != null && !(versionType = persister.getVersionType()).isEqual(version, currentVersion = versionType.nullSafeGet(rs, this.getEntityAliases()[i].getSuffixedVersionAliases(), session, null))) {
            if (session.getFactory().getStatistics().isStatisticsEnabled()) {
                session.getFactory().getStatisticsImplementor().optimisticFailure(persister.getEntityName());
            }
            throw new StaleObjectStateException(persister.getEntityName(), id);
        }
    }

    private Object[] getRow(ResultSet rs, Loadable[] persisters, EntityKey[] keys, Object optionalObject, EntityKey optionalObjectKey, LockMode[] lockModes, List hydratedObjects, SessionImplementor session) throws HibernateException, SQLException {
        int cols = persisters.length;
        EntityAliases[] descriptors = this.getEntityAliases();
        if (log.isDebugEnabled()) {
            log.debug("result row: " + StringHelper.toString(keys));
        }
        Object[] rowResults = new Object[cols];
        for (int i = 0; i < cols; ++i) {
            Object object = null;
            EntityKey key = keys[i];
            if (keys[i] != null) {
                object = session.getEntityUsingInterceptor(key);
                if (object != null) {
                    this.instanceAlreadyLoaded(rs, i, persisters[i], key, object, lockModes[i], session);
                } else {
                    object = this.instanceNotYetLoaded(rs, i, persisters[i], descriptors[i].getRowIdAlias(), key, lockModes[i], optionalObjectKey, optionalObject, hydratedObjects, session);
                }
            }
            rowResults[i] = object;
        }
        return rowResults;
    }

    private void instanceAlreadyLoaded(ResultSet rs, int i, Loadable persister, EntityKey key, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException, SQLException {
        if (!persister.isInstance(object, session.getEntityMode())) {
            throw new WrongClassException("loaded object was of wrong class " + object.getClass(), key.getIdentifier(), persister.getEntityName());
        }
        if (LockMode.NONE != lockMode && this.upgradeLocks()) {
            boolean isVersionCheckNeeded;
            boolean bl = isVersionCheckNeeded = persister.isVersioned() && session.getPersistenceContext().getEntry(object).getLockMode().lessThan(lockMode);
            if (isVersionCheckNeeded) {
                this.checkVersion(i, persister, key.getIdentifier(), object, rs, session);
                session.getPersistenceContext().getEntry(object).setLockMode(lockMode);
            }
        }
    }

    private Object instanceNotYetLoaded(ResultSet rs, int i, Loadable persister, String rowIdAlias, EntityKey key, LockMode lockMode, EntityKey optionalObjectKey, Object optionalObject, List hydratedObjects, SessionImplementor session) throws HibernateException, SQLException {
        String instanceClass = this.getInstanceClass(rs, i, persister, key.getIdentifier(), session);
        Object object = optionalObjectKey != null && key.equals(optionalObjectKey) ? optionalObject : session.instantiate(instanceClass, key.getIdentifier());
        LockMode acquiredLockMode = lockMode == LockMode.NONE ? LockMode.READ : lockMode;
        this.loadFromResultSet(rs, i, object, instanceClass, key, rowIdAlias, acquiredLockMode, persister, session);
        hydratedObjects.add(object);
        return object;
    }

    private boolean isEagerPropertyFetchEnabled(int i) {
        boolean[] array = this.getEntityEagerPropertyFetches();
        return array != null && array[i];
    }

    private void loadFromResultSet(ResultSet rs, int i, Object object, String instanceEntityName, EntityKey key, String rowIdAlias, LockMode lockMode, Loadable rootPersister, SessionImplementor session) throws SQLException, HibernateException {
        String ukName;
        boolean eagerPropertyFetch;
        Serializable id = key.getIdentifier();
        Loadable persister = (Loadable)this.getFactory().getEntityPersister(instanceEntityName);
        if (log.isTraceEnabled()) {
            log.trace("Initializing object from ResultSet: " + MessageHelper.infoString((EntityPersister)persister, id, this.getFactory()));
        }
        TwoPhaseLoad.addUninitializedEntity(key, object, persister, lockMode, !(eagerPropertyFetch = this.isEagerPropertyFetchEnabled(i)), session);
        String[][] cols = persister == rootPersister ? this.getEntityAliases()[i].getSuffixedPropertyAliases() : this.getEntityAliases()[i].getSuffixedPropertyAliases(persister);
        Object[] values = persister.hydrate(rs, id, object, rootPersister, cols, eagerPropertyFetch, session);
        Object rowId = persister.hasRowId() ? rs.getObject(rowIdAlias) : null;
        EntityType[] ownerAssociationTypes = this.getOwnerAssociationTypes();
        if (ownerAssociationTypes != null && ownerAssociationTypes[i] != null && (ukName = ownerAssociationTypes[i].getRHSUniqueKeyPropertyName()) != null) {
            int index = ((UniqueKeyLoadable)persister).getPropertyIndex(ukName);
            Type type = persister.getPropertyTypes()[index];
            EntityUniqueKey euk = new EntityUniqueKey(rootPersister.getEntityName(), ukName, type.semiResolve(values[index], session, object), type, session.getEntityMode(), session.getFactory());
            session.getPersistenceContext().addEntity(euk, object);
        }
        TwoPhaseLoad.postHydrate(persister, id, values, rowId, object, lockMode, !eagerPropertyFetch, session);
    }

    private String getInstanceClass(ResultSet rs, int i, Loadable persister, Serializable id, SessionImplementor session) throws HibernateException, SQLException {
        if (persister.hasSubclasses()) {
            Object discriminatorValue = persister.getDiscriminatorType().nullSafeGet(rs, this.getEntityAliases()[i].getSuffixedDiscriminatorAlias(), session, null);
            String result = persister.getSubclassForDiscriminatorValue(discriminatorValue);
            if (result == null) {
                throw new WrongClassException("Discriminator: " + discriminatorValue, id, persister.getEntityName());
            }
            return result;
        }
        return persister.getEntityName();
    }

    private void advance(ResultSet rs, RowSelection selection) throws SQLException {
        int firstRow = Loader.getFirstRow(selection);
        if (firstRow != 0) {
            if (this.getFactory().getSettings().isScrollableResultSetsEnabled()) {
                rs.absolute(firstRow);
            } else {
                for (int m = 0; m < firstRow; ++m) {
                    rs.next();
                }
            }
        }
    }

    private static boolean hasMaxRows(RowSelection selection) {
        return selection != null && selection.getMaxRows() != null;
    }

    private static int getFirstRow(RowSelection selection) {
        if (selection == null || selection.getFirstRow() == null) {
            return 0;
        }
        return selection.getFirstRow();
    }

    private static boolean useLimit(RowSelection selection, Dialect dialect) {
        return dialect.supportsLimit() && Loader.hasMaxRows(selection);
    }

    protected final PreparedStatement prepareQueryStatement(QueryParameters queryParameters, boolean scroll, SessionImplementor session) throws SQLException, HibernateException {
        ScrollMode scrollMode;
        queryParameters.processFilters(this.getSQLString(), session);
        String sql = queryParameters.getFilteredSQL();
        Dialect dialect = this.getFactory().getDialect();
        RowSelection selection = queryParameters.getRowSelection();
        boolean useLimit = Loader.useLimit(selection, dialect);
        boolean hasFirstRow = Loader.getFirstRow(selection) > 0;
        boolean useOffset = hasFirstRow && useLimit && dialect.supportsLimitOffset();
        boolean callable = queryParameters.isCallable();
        boolean useScrollableResultSetToSkip = hasFirstRow && !useOffset && this.getFactory().getSettings().isScrollableResultSetsEnabled();
        ScrollMode scrollMode2 = scrollMode = scroll ? queryParameters.getScrollMode() : ScrollMode.SCROLL_INSENSITIVE;
        if (useLimit) {
            sql = dialect.getLimitString(sql.trim(), useOffset ? Loader.getFirstRow(selection) : 0, Loader.getMaxOrLimit(selection, dialect));
        }
        sql = this.preprocessSQL(sql, queryParameters, dialect);
        PreparedStatement st = null;
        st = callable ? session.getBatcher().prepareCallableQueryStatement(sql, scroll || useScrollableResultSetToSkip, scrollMode) : session.getBatcher().prepareQueryStatement(sql, scroll || useScrollableResultSetToSkip, scrollMode);
        try {
            int col = 1;
            if (useLimit && dialect.bindLimitParametersFirst()) {
                col += this.bindLimitParameters(st, col, selection);
            }
            if (callable) {
                col = dialect.registerResultSetOutParameter((CallableStatement)st, col);
            }
            col += this.bindParameterValues(st, queryParameters, col, session);
            if (useLimit && !dialect.bindLimitParametersFirst()) {
                col += this.bindLimitParameters(st, col, selection);
            }
            if (!useLimit) {
                this.setMaxRows(st, selection);
            }
            if (selection != null) {
                if (selection.getTimeout() != null) {
                    st.setQueryTimeout(selection.getTimeout());
                }
                if (selection.getFetchSize() != null) {
                    st.setFetchSize(selection.getFetchSize());
                }
            }
        }
        catch (SQLException sqle) {
            session.getBatcher().closeQueryStatement(st, null);
            throw sqle;
        }
        catch (HibernateException he) {
            session.getBatcher().closeQueryStatement(st, null);
            throw he;
        }
        return st;
    }

    private static int getMaxOrLimit(RowSelection selection, Dialect dialect) {
        int firstRow = Loader.getFirstRow(selection);
        int lastRow = selection.getMaxRows();
        if (dialect.useMaxForLimit()) {
            return lastRow + firstRow;
        }
        return lastRow;
    }

    private int bindLimitParameters(PreparedStatement statement, int index, RowSelection selection) throws SQLException {
        Dialect dialect = this.getFactory().getDialect();
        if (!dialect.supportsVariableLimit()) {
            return 0;
        }
        if (!Loader.hasMaxRows(selection)) {
            throw new AssertionFailure("no max results set");
        }
        int firstRow = Loader.getFirstRow(selection);
        int lastRow = Loader.getMaxOrLimit(selection, dialect);
        boolean hasFirstRow = firstRow > 0 && dialect.supportsLimitOffset();
        boolean reverse = dialect.bindLimitParametersInReverseOrder();
        if (hasFirstRow) {
            statement.setInt(index + (reverse ? 1 : 0), firstRow);
        }
        statement.setInt(index + (reverse || !hasFirstRow ? 0 : 1), lastRow);
        return hasFirstRow ? 2 : 1;
    }

    private void setMaxRows(PreparedStatement st, RowSelection selection) throws SQLException {
        if (Loader.hasMaxRows(selection)) {
            st.setMaxRows(selection.getMaxRows() + Loader.getFirstRow(selection));
        }
    }

    protected int bindParameterValues(PreparedStatement statement, QueryParameters queryParameters, int startIndex, SessionImplementor session) throws SQLException {
        int span = 0;
        span += this.bindPositionalParameters(statement, queryParameters, startIndex, session);
        span += this.bindNamedParameters(statement, queryParameters.getNamedParameters(), startIndex + span, session);
        return span;
    }

    protected int bindPositionalParameters(PreparedStatement statement, QueryParameters queryParameters, int startIndex, SessionImplementor session) throws SQLException, HibernateException {
        Object[] values = queryParameters.getFilteredPositionalParameterValues();
        Type[] types = queryParameters.getFilteredPositionalParameterTypes();
        int span = 0;
        for (int i = 0; i < values.length; ++i) {
            types[i].nullSafeSet(statement, values[i], startIndex + span, session);
            span += types[i].getColumnSpan(this.getFactory());
        }
        return span;
    }

    protected int bindNamedParameters(PreparedStatement statement, Map namedParams, int startIndex, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                int[] locs = this.getNamedParameterLocs(name);
                for (int i = 0; i < locs.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug("bindNamedParameters() " + typedval.getValue() + " -> " + name + " [" + (locs[i] + startIndex) + "]");
                    }
                    typedval.getType().nullSafeSet(statement, typedval.getValue(), locs[i] + startIndex, session);
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }

    public int[] getNamedParameterLocs(String name) {
        throw new AssertionFailure("no named parameters");
    }

    protected final ResultSet getResultSet(PreparedStatement st, boolean autodiscovertypes, boolean callable, RowSelection selection, SessionImplementor session) throws SQLException, HibernateException {
        ResultSet rs = null;
        try {
            Dialect dialect = this.getFactory().getDialect();
            rs = callable ? session.getBatcher().getResultSet((CallableStatement)st, dialect) : session.getBatcher().getResultSet(st);
            rs = this.wrapResultSetIfEnabled(rs, session);
            if (!dialect.supportsLimitOffset() || !Loader.useLimit(selection, dialect)) {
                this.advance(rs, selection);
            }
            if (autodiscovertypes) {
                this.autoDiscoverTypes(rs);
            }
            return rs;
        }
        catch (SQLException sqle) {
            session.getBatcher().closeQueryStatement(st, rs);
            throw sqle;
        }
    }

    protected void autoDiscoverTypes(ResultSet rs) {
        throw new AssertionFailure("Auto discover types not supported in this loader");
    }

    private synchronized ResultSet wrapResultSetIfEnabled(ResultSet rs, SessionImplementor session) {
        if (session.getFactory().getSettings().isWrapResultSetsEnabled()) {
            try {
                log.debug("Wrapping result set [" + rs + "]");
                return new ResultSetWrapper(rs, this.retreiveColumnNameToIndexCache(rs));
            }
            catch (SQLException e) {
                log.info("Error wrapping result set", e);
                return rs;
            }
        }
        return rs;
    }

    private ColumnNameCache retreiveColumnNameToIndexCache(ResultSet rs) throws SQLException {
        if (this.columnNameCache == null) {
            log.trace("Building columnName->columnIndex cache");
            this.columnNameCache = new ColumnNameCache(rs.getMetaData().getColumnCount());
        }
        return this.columnNameCache;
    }

    protected final List loadEntity(SessionImplementor session, Object id, Type identifierType, Object optionalObject, String optionalEntityName, Serializable optionalIdentifier, EntityPersister persister) throws HibernateException {
        List result;
        if (log.isDebugEnabled()) {
            log.debug("loading entity: " + MessageHelper.infoString(persister, id, identifierType, this.getFactory()));
        }
        try {
            result = this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters(new Type[]{identifierType}, new Object[]{id}, optionalObject, optionalEntityName, optionalIdentifier), false);
        }
        catch (SQLException sqle) {
            Loadable[] persisters = this.getEntityPersisters();
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not load an entity: " + MessageHelper.infoString(persisters[persisters.length - 1], id, identifierType, this.getFactory()), this.getSQLString());
        }
        log.debug("done entity load");
        return result;
    }

    protected final List loadEntity(SessionImplementor session, Object key, Object index, Type keyType, Type indexType, EntityPersister persister) throws HibernateException {
        List result;
        if (log.isDebugEnabled()) {
            log.debug("loading collection element by index");
        }
        try {
            result = this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters(new Type[]{keyType, indexType}, new Object[]{key, index}), false);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not collection element by index", this.getSQLString());
        }
        log.debug("done entity load");
        return result;
    }

    public final List loadEntityBatch(SessionImplementor session, Serializable[] ids, Type idType, Object optionalObject, String optionalEntityName, Serializable optionalId, EntityPersister persister) throws HibernateException {
        List result;
        if (log.isDebugEnabled()) {
            log.debug("batch loading entity: " + MessageHelper.infoString(persister, ids, this.getFactory()));
        }
        Object[] types = new Type[ids.length];
        Arrays.fill(types, idType);
        try {
            result = this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters((Type[])types, ids, optionalObject, optionalEntityName, optionalId), false);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not load an entity batch: " + MessageHelper.infoString((EntityPersister)this.getEntityPersisters()[0], ids, this.getFactory()), this.getSQLString());
        }
        log.debug("done entity batch load");
        return result;
    }

    public final void loadCollection(SessionImplementor session, Serializable id, Type type) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug("loading collection: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], id, this.getFactory()));
        }
        Object[] ids = new Serializable[]{id};
        try {
            this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters(new Type[]{type}, ids, (Serializable[])ids), true);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not initialize a collection: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], id, this.getFactory()), this.getSQLString());
        }
        log.debug("done loading collection");
    }

    public final void loadCollectionBatch(SessionImplementor session, Serializable[] ids, Type type) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug("batch loading collection: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], ids, this.getFactory()));
        }
        Object[] idTypes = new Type[ids.length];
        Arrays.fill(idTypes, type);
        try {
            this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters((Type[])idTypes, ids, ids), true);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not initialize a collection batch: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], ids, this.getFactory()), this.getSQLString());
        }
        log.debug("done batch load");
    }

    protected final void loadCollectionSubselect(SessionImplementor session, Serializable[] ids, Object[] parameterValues, Type[] parameterTypes, Map namedParameters, Type type) throws HibernateException {
        Object[] idTypes = new Type[ids.length];
        Arrays.fill(idTypes, type);
        try {
            this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters(parameterTypes, parameterValues, namedParameters, ids), true);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not load collection by subselect: " + MessageHelper.collectionInfoString(this.getCollectionPersisters()[0], ids, this.getFactory()), this.getSQLString());
        }
    }

    protected List list(SessionImplementor session, QueryParameters queryParameters, Set querySpaces, Type[] resultTypes) throws HibernateException {
        boolean cacheable;
        boolean bl = cacheable = this.factory.getSettings().isQueryCacheEnabled() && queryParameters.isCacheable();
        if (cacheable) {
            return this.listUsingQueryCache(session, queryParameters, querySpaces, resultTypes);
        }
        return this.listIgnoreQueryCache(session, queryParameters);
    }

    private List listIgnoreQueryCache(SessionImplementor session, QueryParameters queryParameters) {
        return this.getResultList(this.doList(session, queryParameters), queryParameters.getResultTransformer());
    }

    private List listUsingQueryCache(SessionImplementor session, QueryParameters queryParameters, Set querySpaces, Type[] resultTypes) {
        QueryCache queryCache = this.factory.getQueryCache(queryParameters.getCacheRegion());
        Set filterKeys = FilterKey.createFilterKeys(session.getEnabledFilters(), session.getEntityMode());
        QueryKey key = new QueryKey(this.getSQLString(), queryParameters, filterKeys, session.getEntityMode());
        List result = this.getResultFromQueryCache(session, queryParameters, querySpaces, resultTypes, queryCache, key);
        if (result == null) {
            result = this.doList(session, queryParameters);
            this.putResultInQueryCache(session, queryParameters, resultTypes, queryCache, key, result);
        }
        return this.getResultList(result, queryParameters.getResultTransformer());
    }

    private List getResultFromQueryCache(SessionImplementor session, QueryParameters queryParameters, Set querySpaces, Type[] resultTypes, QueryCache queryCache, QueryKey key) {
        List result = null;
        if (session.getCacheMode().isGetEnabled()) {
            boolean isImmutableNaturalKeyLookup = queryParameters.isNaturalKeyLookup() && this.getEntityPersisters()[0].getEntityMetamodel().hasImmutableNaturalId();
            result = queryCache.get(key, resultTypes, isImmutableNaturalKeyLookup, querySpaces, session);
            if (this.factory.getStatistics().isStatisticsEnabled()) {
                if (result == null) {
                    this.factory.getStatisticsImplementor().queryCacheMiss(this.getQueryIdentifier(), queryCache.getRegion().getName());
                } else {
                    this.factory.getStatisticsImplementor().queryCacheHit(this.getQueryIdentifier(), queryCache.getRegion().getName());
                }
            }
        }
        return result;
    }

    private void putResultInQueryCache(SessionImplementor session, QueryParameters queryParameters, Type[] resultTypes, QueryCache queryCache, QueryKey key, List result) {
        boolean put;
        if (session.getCacheMode().isPutEnabled() && (put = queryCache.put(key, resultTypes, result, queryParameters.isNaturalKeyLookup(), session)) && this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().queryCachePut(this.getQueryIdentifier(), queryCache.getRegion().getName());
        }
    }

    protected List doList(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        List result;
        boolean stats = this.getFactory().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        try {
            result = this.doQueryAndInitializeNonLazyCollections(session, queryParameters, true);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not execute query", this.getSQLString());
        }
        if (stats) {
            this.getFactory().getStatisticsImplementor().queryExecuted(this.getQueryIdentifier(), result.size(), System.currentTimeMillis() - startTime);
        }
        return result;
    }

    protected void checkScrollability() throws HibernateException {
    }

    protected boolean needsFetchingScroll() {
        return false;
    }

    protected ScrollableResults scroll(QueryParameters queryParameters, Type[] returnTypes, HolderInstantiator holderInstantiator, SessionImplementor session) throws HibernateException {
        this.checkScrollability();
        boolean stats = this.getQueryIdentifier() != null && this.getFactory().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        try {
            PreparedStatement st = this.prepareQueryStatement(queryParameters, true, session);
            ResultSet rs = this.getResultSet(st, queryParameters.hasAutoDiscoverScalarTypes(), queryParameters.isCallable(), queryParameters.getRowSelection(), session);
            if (stats) {
                this.getFactory().getStatisticsImplementor().queryExecuted(this.getQueryIdentifier(), 0, System.currentTimeMillis() - startTime);
            }
            if (this.needsFetchingScroll()) {
                return new FetchingScrollableResultsImpl(rs, st, session, this, queryParameters, returnTypes, holderInstantiator);
            }
            return new ScrollableResultsImpl(rs, st, session, this, queryParameters, returnTypes, holderInstantiator);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not execute query using scroll", this.getSQLString());
        }
    }

    protected void postInstantiate() {
    }

    protected abstract EntityAliases[] getEntityAliases();

    protected abstract CollectionAliases[] getCollectionAliases();

    protected String getQueryIdentifier() {
        return null;
    }

    public final SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getSQLString() + ')';
    }
}

