/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ASTFactory;
import antlr.Token;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.tree.AggregateNode;
import org.hibernate.hql.ast.tree.BetweenOperatorNode;
import org.hibernate.hql.ast.tree.BinaryArithmeticOperatorNode;
import org.hibernate.hql.ast.tree.BinaryLogicOperatorNode;
import org.hibernate.hql.ast.tree.BooleanLiteralNode;
import org.hibernate.hql.ast.tree.Case2Node;
import org.hibernate.hql.ast.tree.CaseNode;
import org.hibernate.hql.ast.tree.CollectionFunction;
import org.hibernate.hql.ast.tree.ConstructorNode;
import org.hibernate.hql.ast.tree.CountNode;
import org.hibernate.hql.ast.tree.DeleteStatement;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.IdentNode;
import org.hibernate.hql.ast.tree.ImpliedFromElement;
import org.hibernate.hql.ast.tree.InLogicOperatorNode;
import org.hibernate.hql.ast.tree.IndexNode;
import org.hibernate.hql.ast.tree.InitializeableNode;
import org.hibernate.hql.ast.tree.InsertStatement;
import org.hibernate.hql.ast.tree.IntoClause;
import org.hibernate.hql.ast.tree.IsNotNullLogicOperatorNode;
import org.hibernate.hql.ast.tree.IsNullLogicOperatorNode;
import org.hibernate.hql.ast.tree.JavaConstantNode;
import org.hibernate.hql.ast.tree.LiteralNode;
import org.hibernate.hql.ast.tree.MethodNode;
import org.hibernate.hql.ast.tree.OrderByClause;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.SelectClause;
import org.hibernate.hql.ast.tree.SelectExpressionImpl;
import org.hibernate.hql.ast.tree.SessionFactoryAwareNode;
import org.hibernate.hql.ast.tree.SqlFragment;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.tree.UnaryArithmeticNode;
import org.hibernate.hql.ast.tree.UnaryLogicOperatorNode;
import org.hibernate.hql.ast.tree.UpdateStatement;

public class SqlASTFactory
extends ASTFactory
implements HqlSqlTokenTypes {
    private HqlSqlWalker walker;

    public SqlASTFactory(HqlSqlWalker walker) {
        this.walker = walker;
    }

    public Class getASTNodeType(int tokenType) {
        switch (tokenType) {
            case 45: 
            case 83: {
                return QueryNode.class;
            }
            case 51: {
                return UpdateStatement.class;
            }
            case 13: {
                return DeleteStatement.class;
            }
            case 29: {
                return InsertStatement.class;
            }
            case 30: {
                return IntoClause.class;
            }
            case 22: {
                return FromClause.class;
            }
            case 128: {
                return FromElement.class;
            }
            case 129: {
                return ImpliedFromElement.class;
            }
            case 15: {
                return DotNode.class;
            }
            case 75: {
                return IndexNode.class;
            }
            case 120: 
            case 134: {
                return IdentNode.class;
            }
            case 136: {
                return SqlFragment.class;
            }
            case 78: {
                return MethodNode.class;
            }
            case 17: 
            case 27: {
                return CollectionFunction.class;
            }
            case 131: {
                return SelectClause.class;
            }
            case 138: {
                return SelectExpressionImpl.class;
            }
            case 68: {
                return AggregateNode.class;
            }
            case 12: {
                return CountNode.class;
            }
            case 70: {
                return ConstructorNode.class;
            }
            case 92: 
            case 93: 
            case 94: 
            case 118: 
            case 119: {
                return LiteralNode.class;
            }
            case 20: 
            case 49: {
                return BooleanLiteralNode.class;
            }
            case 95: {
                return JavaConstantNode.class;
            }
            case 41: {
                return OrderByClause.class;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return BinaryArithmeticOperatorNode.class;
            }
            case 87: 
            case 88: {
                return UnaryArithmeticNode.class;
            }
            case 71: {
                return Case2Node.class;
            }
            case 54: {
                return CaseNode.class;
            }
            case 117: 
            case 142: {
                return ParameterNode.class;
            }
            case 34: 
            case 81: 
            case 97: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                return BinaryLogicOperatorNode.class;
            }
            case 26: 
            case 80: {
                return InLogicOperatorNode.class;
            }
            case 10: 
            case 79: {
                return BetweenOperatorNode.class;
            }
            case 77: {
                return IsNullLogicOperatorNode.class;
            }
            case 76: {
                return IsNotNullLogicOperatorNode.class;
            }
            case 19: {
                return UnaryLogicOperatorNode.class;
            }
        }
        return SqlNode.class;
    }

    protected AST createUsingCtor(Token token, String className) {
        AST t;
        try {
            Class<?> c = Class.forName(className);
            Class[] tokenArgType = new Class[]{Token.class};
            Constructor<?> ctor = c.getConstructor(tokenArgType);
            if (ctor != null) {
                t = (AST)ctor.newInstance(token);
                this.initializeSqlNode(t);
            } else {
                t = this.create(c);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid class or can't make instance, " + className);
        }
        return t;
    }

    private void initializeSqlNode(AST t) {
        if (t instanceof InitializeableNode) {
            InitializeableNode initializeableNode = (InitializeableNode)((Object)t);
            initializeableNode.initialize(this.walker);
        }
        if (t instanceof SessionFactoryAwareNode) {
            ((SessionFactoryAwareNode)((Object)t)).setSessionFactory(this.walker.getSessionFactoryHelper().getFactory());
        }
    }

    protected AST create(Class c) {
        AST t;
        try {
            t = (AST)c.newInstance();
            this.initializeSqlNode(t);
        }
        catch (Exception e) {
            this.error("Can't create AST Node " + c.getName());
            return null;
        }
        return t;
    }
}

