/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.rt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opennms.protocols.rt.Request;
import org.opennms.protocols.rt.RequestLocator;
import org.opennms.protocols.rt.ResponseWithId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDBasedRequestLocator<ReqIdT, ReqT extends Request<ReqIdT, ReqT, ReplyT>, ReplyT extends ResponseWithId<ReqIdT>>
implements RequestLocator<ReqT, ReplyT> {
    private static final Logger s_log = LoggerFactory.getLogger(IDBasedRequestLocator.class);
    private Map<ReqIdT, ReqT> m_pendingRequests = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReqT requestTimedOut(ReqT timedOutRequest) {
        Map<ReqIdT, ReqT> map = this.m_pendingRequests;
        synchronized (map) {
            Request pendingRequest = (Request)this.m_pendingRequests.get(timedOutRequest.getId());
            if (pendingRequest == timedOutRequest) {
                this.m_pendingRequests.remove(timedOutRequest.getId());
            }
            return (ReqT)pendingRequest;
        }
    }

    @Override
    public void requestComplete(ReqT request) {
        this.m_pendingRequests.remove(request.getId());
    }

    @Override
    public ReqT locateMatchingRequest(ReplyT reply) {
        Object id = reply.getRequestId();
        s_log.debug("Looking for request with Id: {} in map {}", id, this.m_pendingRequests);
        Request request = (Request)this.m_pendingRequests.get(id);
        return (ReqT)request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trackRequest(ReqT request) {
        Map<ReqIdT, ReqT> map = this.m_pendingRequests;
        synchronized (map) {
            Request oldRequest = (Request)this.m_pendingRequests.get(request.getId());
            if (oldRequest != null) {
                request.processError(new IllegalStateException("Duplicate request; keeping old request: " + oldRequest + "; removing new request: " + request));
                return false;
            }
            this.m_pendingRequests.put(request.getId(), request);
        }
        return true;
    }
}

