/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jmxconfiggenerator.jmxconfig;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.bind.JAXB;
import org.apache.commons.lang3.StringUtils;
import org.opennms.features.namecutter.NameCutter;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Attrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompAttrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompMember;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxCollection;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxDatacollectionConfig;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;
import org.opennms.xmlns.xsd.config.jmx_datacollection.ObjectFactory;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Rrd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxDatacollectionConfiggenerator {
    private static Logger logger = LoggerFactory.getLogger(JmxDatacollectionConfiggenerator.class);
    private static ObjectFactory xmlObjectFactory = new ObjectFactory();
    private static ArrayList<String> standardVmBeans = new ArrayList();
    private static ArrayList<String> ignores = new ArrayList();
    private static ArrayList<String> numbers = new ArrayList();
    private static ArrayList<String> rras = new ArrayList();
    private static HashMap<String, Integer> aliasMap = new HashMap();
    private static ArrayList<String> aliasList = new ArrayList();
    private static Rrd rrd = new Rrd();
    private static NameCutter nameCutter = new NameCutter();

    public JmxDatacollectionConfig generateJmxConfigModel(MBeanServerConnection mBeanServerConnection, String serviceName, Boolean runStandardVmBeans, Boolean runWritableMBeans, Map<String, String> dictionary) {
        logger.debug("Startup values: \n serviceName: " + serviceName + "\n runStandardVmBeans: " + runStandardVmBeans + "\n runWritableMBeans: " + runWritableMBeans + "\n dictionary" + dictionary);
        nameCutter.setDictionary(dictionary);
        JmxDatacollectionConfig xmlJmxDatacollectionConfig = xmlObjectFactory.createJmxDatacollectionConfig();
        JmxCollection xmlJmxCollection = xmlObjectFactory.createJmxCollection();
        xmlJmxCollection.setName("JSR160-" + serviceName);
        xmlJmxCollection.setRrd(rrd);
        xmlJmxDatacollectionConfig.getJmxCollection().add(xmlJmxCollection);
        xmlJmxCollection.setMbeans(xmlObjectFactory.createMbeans());
        if (runStandardVmBeans.booleanValue()) {
            ignores.clear();
        } else {
            ignores.addAll(standardVmBeans);
        }
        try {
            for (String domainName : mBeanServerConnection.getDomains()) {
                if (!ignores.contains(domainName)) {
                    logger.debug("domain: " + domainName);
                    for (ObjectInstance jmxObjectInstance : mBeanServerConnection.queryMBeans(new ObjectName(domainName + ":*"), null)) {
                        MBeanInfo jmxMbeanInfo;
                        Mbean xmlMbean = xmlObjectFactory.createMbean();
                        xmlMbean.setObjectname(jmxObjectInstance.getObjectName().toString());
                        String typeAndOthers = StringUtils.substringAfterLast((String)jmxObjectInstance.getObjectName().getCanonicalName(), (String)"=");
                        xmlMbean.setName(domainName + "." + typeAndOthers);
                        logger.debug("\t" + jmxObjectInstance.getObjectName());
                        try {
                            jmxMbeanInfo = mBeanServerConnection.getMBeanInfo(jmxObjectInstance.getObjectName());
                        }
                        catch (InstanceNotFoundException e) {
                            logger.error("InstanceNotFoundException skipping MBean '{}' message: '{}'", (Object)jmxObjectInstance.getObjectName(), (Object)e.getMessage());
                            continue;
                        }
                        catch (IntrospectionException e) {
                            logger.error("IntrospectionException skipping MBean '{}' message: '{}'", (Object)jmxObjectInstance.getObjectName(), (Object)e.getMessage());
                            continue;
                        }
                        catch (ReflectionException e) {
                            logger.error("ReflectionException skipping MBean '{}' message: '{}'", (Object)jmxObjectInstance.getObjectName(), (Object)e.getMessage());
                            continue;
                        }
                        catch (Throwable e) {
                            logger.error("problem during remote call to get MBeanInfo for '{}' skipping this MBean. Message '{}'", (Object)jmxObjectInstance.getObjectName(), (Object)e.getMessage());
                            continue;
                        }
                        logger.debug("--- Attributes for " + jmxObjectInstance.getObjectName());
                        for (MBeanAttributeInfo jmxBeanAttributeInfo : jmxMbeanInfo.getAttributes()) {
                            if (!jmxBeanAttributeInfo.isReadable() || jmxBeanAttributeInfo.isWritable() && !runWritableMBeans.booleanValue()) continue;
                            logger.debug("Check mBean: '{}', attribute: '{}'", (Object)jmxObjectInstance.getObjectName().toString(), (Object)jmxBeanAttributeInfo.getName());
                            logger.debug("isWritable: '{}', type: '{}'", (Object)jmxBeanAttributeInfo.isWritable(), (Object)jmxBeanAttributeInfo.getType());
                            if ("javax.management.openmbean.CompositeData".equals(jmxBeanAttributeInfo.getType())) {
                                logger.error("actual mBean: '{}'", (Object)jmxObjectInstance.getObjectName());
                                CompAttrib compAttrib = this.createCompAttrib(mBeanServerConnection, jmxObjectInstance, jmxBeanAttributeInfo);
                                if (compAttrib != null) {
                                    logger.debug("xmlMbean got CompAttrib");
                                    xmlMbean.getCompAttrib().add(compAttrib);
                                }
                            }
                            if (!numbers.contains(jmxBeanAttributeInfo.getType())) continue;
                            Attrib xmlJmxAttribute = this.createAttr(jmxBeanAttributeInfo);
                            logger.debug("Added MBean: '{}' Added attribute: '{}'", (Object)xmlMbean.getObjectname(), (Object)(xmlJmxAttribute.getName() + " as " + xmlJmxAttribute.getAlias()));
                            xmlMbean.getAttrib().add(xmlJmxAttribute);
                        }
                        if (xmlMbean.getAttrib().size() > 0 || xmlMbean.getCompAttrib().size() > 0) {
                            xmlJmxCollection.getMbeans().getMbean().add(xmlMbean);
                            continue;
                        }
                        logger.debug("mbean: " + xmlMbean.getName() + " has no relavant attributes.");
                    }
                    continue;
                }
                logger.debug("ignored: " + domainName);
            }
        }
        catch (MalformedObjectNameException e) {
            logger.error("MalformedObjectNameException '{}'", (Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error("IOException '{}'", (Object)e.getMessage());
        }
        return xmlJmxDatacollectionConfig;
    }

    public MBeanServerConnection createMBeanServerConnection(String hostName, String port, String username, String password, Boolean ssl, Boolean jmxmp) throws MalformedURLException, IOException {
        JMXConnector jmxConnector = this.getJmxConnector(hostName, port, username, password, ssl, jmxmp);
        MBeanServerConnection jmxServerConnection = jmxConnector.getMBeanServerConnection();
        logger.debug("jmxServerConnection: '{}'", (Object)jmxServerConnection);
        logger.debug("count: " + jmxServerConnection.getMBeanCount());
        return jmxServerConnection;
    }

    public JMXConnector getJmxConnector(String hostName, String port, String username, String password, Boolean ssl, Boolean jmxmp) throws MalformedURLException, IOException {
        JMXServiceURL jmxServiceURL = this.getJmxServiceURL(jmxmp, hostName, port);
        JMXConnector jmxConnector = this.getJmxConnector(username, password, jmxServiceURL);
        return jmxConnector;
    }

    private JMXConnector getJmxConnector(String username, String password, JMXServiceURL jmxServiceURL) throws IOException {
        JMXConnector jmxConnector;
        if (username != null && password != null) {
            jmxConnector = JMXConnectorFactory.newJMXConnector(jmxServiceURL, null);
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            String[] credentials = new String[]{username, password};
            env.put("jmx.remote.credentials", credentials);
            jmxConnector.connect(env);
        } else {
            jmxConnector = JMXConnectorFactory.connect(jmxServiceURL);
            jmxConnector.connect();
        }
        return jmxConnector;
    }

    public JMXServiceURL getJmxServiceURL(Boolean jmxmp, String hostName, String port) throws MalformedURLException {
        if (jmxmp.booleanValue()) {
            return new JMXServiceURL("service:jmx:jmxmp://" + hostName + ":" + port);
        }
        return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + hostName + ":" + port + "/jmxrmi");
    }

    public void writeJmxConfigFile(JmxDatacollectionConfig jmxDatacollectionConfigModel, String outFile) {
        JAXB.marshal((Object)jmxDatacollectionConfigModel, (File)new File(outFile));
    }

    private CompAttrib createCompAttrib(MBeanServerConnection jmxServerConnection, ObjectInstance jmxObjectInstance, MBeanAttributeInfo jmxMBeanAttributeInfo) {
        Boolean contentAdded = false;
        CompAttrib xmlCompAttrib = xmlObjectFactory.createCompAttrib();
        xmlCompAttrib.setName(jmxMBeanAttributeInfo.getName());
        xmlCompAttrib.setType("Composite");
        xmlCompAttrib.setAlias(jmxMBeanAttributeInfo.getName());
        try {
            logger.debug("Try to get composite data");
            CompositeData compositeData = (CompositeData)jmxServerConnection.getAttribute(jmxObjectInstance.getObjectName(), jmxMBeanAttributeInfo.getName());
            if (compositeData == null) {
                logger.warn("compositeData is null. jmxObjectInstance.getObjectName: '{}', jmxMBeanAttributeInfo.getName: '{}'");
            }
            if (compositeData != null) {
                logger.debug("compositeData.getCompositeType: '{}'", (Object)compositeData.getCompositeType());
                Set<String> keys = compositeData.getCompositeType().keySet();
                for (String key : keys) {
                    Object compositeEntry = compositeData.get(key);
                    if (numbers.contains(compositeEntry.getClass().getName())) {
                        contentAdded = true;
                        CompMember xmlCompMember = xmlObjectFactory.createCompMember();
                        xmlCompMember.setName(key);
                        logger.debug("composite member pure alias: '{}'", (Object)(jmxMBeanAttributeInfo.getName() + StringUtils.capitalize((String)key)));
                        String alias = nameCutter.trimByDictionary(jmxMBeanAttributeInfo.getName() + StringUtils.capitalize((String)key));
                        alias = this.createAndRegisterUniqueAlias(alias);
                        xmlCompMember.setAlias(alias);
                        logger.debug("composite member trimmed alias: '{}'", (Object)alias);
                        xmlCompMember.setType("gauge");
                        xmlCompAttrib.getCompMember().add(xmlCompMember);
                        continue;
                    }
                    logger.debug("composite member key '{}' object's class '{}' was not a number.", (Object)key, (Object)compositeEntry.getClass().getName());
                }
            }
        }
        catch (Exception e) {
            logger.error("killed in action: '{}'", (Object)e.getMessage());
        }
        if (contentAdded.booleanValue()) {
            logger.debug("xmlCompAttrib returned by createCompAttrib it's '{}'", (Object)xmlCompAttrib);
            return xmlCompAttrib;
        }
        return null;
    }

    private Attrib createAttr(MBeanAttributeInfo jmxMBeanAttributeInfo) {
        Attrib xmlJmxAttribute = xmlObjectFactory.createAttrib();
        xmlJmxAttribute.setType("gauge");
        xmlJmxAttribute.setName(jmxMBeanAttributeInfo.getName());
        String alias = nameCutter.trimByDictionary(jmxMBeanAttributeInfo.getName());
        alias = this.createAndRegisterUniqueAlias(alias);
        xmlJmxAttribute.setAlias(alias);
        return xmlJmxAttribute;
    }

    private String createAndRegisterUniqueAlias(String originalAlias) {
        String uniqueAlias = originalAlias;
        if (!aliasMap.containsKey(originalAlias)) {
            aliasMap.put(originalAlias, 0);
            uniqueAlias = 0 + uniqueAlias;
        } else {
            aliasMap.put(originalAlias, aliasMap.get(originalAlias) + 1);
            uniqueAlias = aliasMap.get(originalAlias).toString() + originalAlias;
        }
        if (aliasList.contains(nameCutter.trimByCamelCase(uniqueAlias, Integer.valueOf(19)))) {
            logger.error("ALIAS CRASH AT :" + uniqueAlias + "\t as: " + nameCutter.trimByCamelCase(uniqueAlias, Integer.valueOf(19)));
            uniqueAlias = uniqueAlias + "_NAME_CRASH_AS_19_CHAR_VALUE";
        } else {
            uniqueAlias = nameCutter.trimByCamelCase(uniqueAlias, Integer.valueOf(19));
            aliasList.add(uniqueAlias);
        }
        return uniqueAlias;
    }

    static {
        standardVmBeans.add("JMImplementation");
        standardVmBeans.add("com.sun.management");
        standardVmBeans.add("java.lang");
        standardVmBeans.add("java.nio");
        standardVmBeans.add("java.util.logging");
        numbers.add("int");
        numbers.add("long");
        numbers.add("double");
        numbers.add("float");
        numbers.add("java.lang.Long");
        numbers.add("java.lang.Integer");
        rrd.setStep(300);
        rras.add("RRA:AVERAGE:0.5:1:2016");
        rras.add("RRA:AVERAGE:0.5:12:1488");
        rras.add("RRA:AVERAGE:0.5:288:366");
        rras.add("RRA:MAX:0.5:288:366");
        rras.add("RRA:MIN:0.5:288:366");
        rrd.getRra().addAll(rras);
    }
}

