/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jmxconfiggenerator.graphs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.JAXB;
import org.apache.commons.lang.StringUtils;
import org.opennms.jmxconfiggenerator.graphs.Graph;
import org.opennms.jmxconfiggenerator.graphs.Report;
import org.opennms.jmxconfiggenerator.helper.Colors;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Attrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompAttrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompMember;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxCollection;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxDatacollectionConfig;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxConfigReader {
    private Logger logger = LoggerFactory.getLogger(JmxConfigReader.class);
    private final String ATTRIBUTEREPORT = "AttributeReport";
    private final String MBEANREPORT = "MBeanReport";
    private final String COMPOSITEREPORT = "CompositeReport";
    private final String COMPOSITATTRIBEREPORT = "CompositeAttributeReport";

    public Collection<Report> generateReportsByJmxDatacollectionConfig(String jmxDatacollectionConfig) {
        ArrayList<Report> reports = new ArrayList<Report>();
        JmxDatacollectionConfig inputConfig = (JmxDatacollectionConfig)JAXB.unmarshal((File)new File(jmxDatacollectionConfig), JmxDatacollectionConfig.class);
        for (JmxCollection jmxCollection : inputConfig.getJmxCollection()) {
            this.logger.debug("jmxCollection: '{}'", (Object)jmxCollection.getName());
            Mbeans mbeans = jmxCollection.getMbeans();
            for (Mbean mbean : mbeans.getMbean()) {
                reports.addAll(this.generateMbeanReportsByMBean(mbean));
                reports.addAll(this.generateAttributeReporsByMBean(mbean));
                reports.addAll(this.generateCompositeReportsByMBean(mbean));
                reports.addAll(this.generateCompositeMemberReportsByMBean(mbean));
            }
        }
        return reports;
    }

    private Collection<Report> generateAttributeReporsByMBean(Mbean mbean) {
        ArrayList<Report> reports = new ArrayList<Report>();
        for (Attrib attrib : mbean.getAttrib()) {
            String reportId = StringUtils.deleteWhitespace((String)mbean.getName()) + "." + attrib.getAlias() + "." + "AttributeReport";
            Report report = new Report(reportId, attrib.getName(), attrib.getName(), "verticalLabel");
            report.addGraph(new Graph(attrib.getAlias(), attrib.getName(), attrib.getAlias(), Colors.getNextColor(), Colors.getNextColor(), Colors.getNextColor()));
            reports.add(report);
            Colors.restetColor();
        }
        return reports;
    }

    private Collection<Report> generateMbeanReportsByMBean(Mbean mbean) {
        ArrayList<Report> reports = new ArrayList<Report>();
        if (!mbean.getAttrib().isEmpty()) {
            String reportId = StringUtils.deleteWhitespace((String)mbean.getName()) + "." + "MBeanReport";
            Report report = new Report(reportId, mbean.getName(), mbean.getName(), "verticalLabel");
            for (Attrib attrib : mbean.getAttrib()) {
                report.addGraph(new Graph(attrib.getAlias(), attrib.getName(), attrib.getAlias(), Colors.getNextColor(), Colors.getNextColor(), Colors.getNextColor()));
            }
            reports.add(report);
            Colors.restetColor();
        }
        return reports;
    }

    private Collection<Report> generateCompositeReportsByMBean(Mbean mbean) {
        ArrayList<Report> reports = new ArrayList<Report>();
        for (CompAttrib compAttrib : mbean.getCompAttrib()) {
            String reportId = StringUtils.deleteWhitespace((String)mbean.getName()) + "." + compAttrib.getName() + "." + "CompositeReport";
            Report report = new Report(reportId, reportId, reportId, "verticalLabel");
            for (CompMember compMember : compAttrib.getCompMember()) {
                report.addGraph(new Graph(compMember.getAlias(), compMember.getName(), compMember.getAlias(), Colors.getNextColor(), Colors.getNextColor(), Colors.getNextColor()));
            }
            reports.add(report);
            Colors.restetColor();
        }
        return reports;
    }

    private Collection<Report> generateCompositeMemberReportsByMBean(Mbean mbean) {
        ArrayList<Report> reports = new ArrayList<Report>();
        for (CompAttrib compAttrib : mbean.getCompAttrib()) {
            for (CompMember compMember : compAttrib.getCompMember()) {
                String reportId = StringUtils.deleteWhitespace((String)mbean.getName()) + "." + compAttrib.getName() + "." + compMember.getName() + "." + "CompositeAttributeReport";
                Report report = new Report(reportId, reportId, reportId, "verticalLabel");
                report.addGraph(new Graph(compMember.getAlias(), compMember.getName(), compMember.getAlias(), Colors.getNextColor(), Colors.getNextColor(), Colors.getNextColor()));
                reports.add(report);
                Colors.restetColor();
            }
        }
        return reports;
    }
}

