/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.measurement;

import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.opennms.netmgt.jasper.helper.MeasurementsHelper;
import org.opennms.netmgt.jasper.measurement.MeasurementDataSourceWrapper;
import org.opennms.netmgt.jasper.measurement.local.LocalMeasurementDataSourceWrapper;
import org.opennms.netmgt.jasper.measurement.remote.RemoteMeasurementDataSourceWrapper;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MeasurementQueryExecutor
extends JRAbstractQueryExecuter {
    private static final Logger LOG = LoggerFactory.getLogger(MeasurementQueryExecutor.class);
    private static final String SSL_PROPERTY_KEY = "org.opennms.netmgt.jasper.measurement.ssl.enable";
    private MeasurementDataSourceWrapper datasourceWrapper;

    protected MeasurementQueryExecutor(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        if (dataset != null) {
            this.parseQuery();
        }
    }

    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    public boolean cancelQuery() throws JRException {
        return false;
    }

    public JRRewindableDataSource createDatasource() throws JRException {
        LOG.debug("Create datasource for query '{}'", (Object)this.getQueryString());
        if (this.datasourceWrapper == null) {
            this.datasourceWrapper = this.createDatasourceWrapper();
        }
        return this.datasourceWrapper.createDataSource(this.getQueryString());
    }

    public void close() {
        try {
            if (this.datasourceWrapper != null) {
                this.datasourceWrapper.close();
            }
        }
        finally {
            this.datasourceWrapper = null;
        }
    }

    private MeasurementDataSourceWrapper createDatasourceWrapper() {
        if (MeasurementsHelper.isRunInOpennmsJvm()) {
            return new LocalMeasurementDataSourceWrapper(MeasurementsHelper.getSpringHelper().getMeasurementFetchStrategy(), MeasurementsHelper.getSpringHelper().getExpressionEngine(), MeasurementsHelper.getSpringHelper().getFilterEngine());
        }
        LOG.warn("No {} implementation found. Falling back to HTTP mode.", MeasurementFetchStrategy.class);
        boolean useSsl = Boolean.valueOf(System.getProperty(SSL_PROPERTY_KEY, "false"));
        return new RemoteMeasurementDataSourceWrapper(useSsl, (String)this.getParameterValue("MEASUREMENT_URL"), (String)this.getParameterValue("MEASUREMENT_USERNAME", true), (String)this.getParameterValue("MEASUREMENT_PASSWORD", true));
    }
}

