/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.measurement.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import org.opennms.netmgt.jasper.measurement.remote.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MeasurementApiClient {
    protected static final int CONNECT_TIMEOUT = 2500;
    protected static final int READ_TIMEOUT = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(MeasurementApiClient.class);
    private final int connectTimeout;
    private final int readTimeout;
    private HttpURLConnection connection;

    public MeasurementApiClient() {
        this(2500, 10000);
    }

    public MeasurementApiClient(int connectTimeout, int readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public Result execute(boolean useSsl, String url, String username, String password, String query) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0, (Object)"The provided URL must not be empty or null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)query) ? 1 : 0) != 0, (Object)"The provided query must not be empty or null");
        MeasurementApiClient.log(url, username, password, query);
        this.connect(useSsl, url, username, password);
        MeasurementApiClient.write(query.getBytes(), this.connection.getOutputStream());
        Result result = MeasurementApiClient.createResult(this.connection);
        LOG.debug("Request to URL '{}' returned with status: {} ({})", new Object[]{url, result.getResponseCode(), result.getResponseMessage()});
        return result;
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    private String createBasicAuthHeader(String username, String password) {
        String pass = String.format("%s:%s", username, password);
        String basicAuthHeader = "Basic " + new String(BaseEncoding.base64().encode(pass.getBytes()));
        return basicAuthHeader;
    }

    private void connect(boolean useSsl, String url, String username, String password) throws IOException {
        this.connection = (HttpURLConnection)new URL(url).openConnection();
        if (useSsl && !(this.connection instanceof HttpsURLConnection)) {
            throw new SSLException("A secure connection is expected but was not established. Use SSL = " + useSsl + ", URL = " + url);
        }
        if (!useSsl && this.connection instanceof HttpsURLConnection) {
            LOG.warn("A secure connection was established even if it was not intended. Use SSL = {}, URL = {}", (Object)useSsl, (Object)url);
        }
        if (MeasurementApiClient.isAuthenticationRequired(username, password)) {
            this.connection.setRequestProperty("Authorization", this.createBasicAuthHeader(username, password));
        }
        this.connection.setAllowUserInteraction(false);
        this.connection.setConnectTimeout(this.connectTimeout);
        this.connection.setReadTimeout(this.readTimeout);
        this.connection.setUseCaches(false);
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Accept", "application/xml");
        this.connection.setRequestProperty("Accept-Charset", "UTF-8");
        this.connection.setRequestProperty("Content-Type", "application/xml");
        this.connection.setInstanceFollowRedirects(false);
        this.connection.connect();
    }

    private static void write(byte[] input, OutputStream outputStream) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    protected static boolean isAuthenticationRequired(String username, String password) {
        return !Strings.isNullOrEmpty((String)username) && !Strings.isNullOrEmpty((String)password);
    }

    private static void log(String url, String username, String password, String query) {
        LOG.info("Connecting to {}", (Object)url);
        if (MeasurementApiClient.isAuthenticationRequired(username, password)) {
            LOG.info("Using authentication: YES");
            LOG.info("Using username {}", (Object)username);
            LOG.info("Using password {}", (Object)"*******");
        } else {
            LOG.info("Using authentication: NO");
        }
        LOG.info("Query Request: {}", (Object)query);
    }

    private static Result createResult(HttpURLConnection connection) throws IOException {
        Result result = new Result();
        result.setResponseCode(connection.getResponseCode());
        result.setResponseMessage(connection.getResponseMessage());
        result.setSecureConnection(connection instanceof HttpsURLConnection);
        if (result.wasSuccessful()) {
            result.setInputStream(connection.getInputStream());
        } else {
            result.setErrorStream(connection.getErrorStream());
        }
        return result;
    }
}

