/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.helper;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXB;
import net.sf.jasperreports.engine.JRException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.jasper.helper.RrdLabelUtils;
import org.opennms.netmgt.jasper.helper.SpringHelper;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MeasurementsHelper {
    private static Logger LOG = LoggerFactory.getLogger(MeasurementsHelper.class);

    private MeasurementsHelper() {
    }

    public static String getInterfaceDescriptor(String snmpifname, String snmpifdescr, String snmpphysaddr) {
        return RrdLabelUtils.computeLabelForRRD(snmpifname, snmpifdescr, snmpphysaddr);
    }

    public static String getNodeOrNodeSourceDescriptor(String nodeId, String foreignSource, String foreignId) {
        if (!Strings.isNullOrEmpty((String)foreignSource) && !Strings.isNullOrEmpty((String)foreignId)) {
            return String.format("nodeSource[%s:%s]", foreignSource, foreignId);
        }
        return String.format("node[%s]", nodeId);
    }

    public static boolean isRunInOpennmsJvm() {
        return MeasurementsHelper.getSpringHelper().getSpringContext() != null;
    }

    public static SpringHelper getSpringHelper() {
        try {
            return (SpringHelper)BeanUtils.getBean((String)"measurementDataSourceContext", (String)"springHelper", SpringHelper.class);
        }
        catch (Exception ex) {
            LOG.warn("Error creating bean 'springHelper'. Creating empty SpringHelper");
            return new SpringHelper();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QueryRequest unmarshal(String query) throws JRException {
        try (ByteArrayInputStream input = new ByteArrayInputStream(query.getBytes());){
            QueryRequest request;
            QueryRequest queryRequest = request = (QueryRequest)JAXB.unmarshal((InputStream)input, QueryRequest.class);
            return queryRequest;
        }
        catch (IOException e) {
            LOG.error("An error occurred while unmarshalling the query string", (Throwable)e);
            throw new JRException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String marshal(QueryRequest queryRequest) throws JRException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            JAXB.marshal((Object)queryRequest, (OutputStream)outputStream);
            String string = outputStream.toString();
            return string;
        }
        catch (IOException e) {
            LOG.error("An error occurred while marshalling the query request", (Throwable)e);
            throw new JRException((Throwable)e);
        }
    }
}

