/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.measurement;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXB;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.opennms.netmgt.measurements.model.QueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementDataSource
implements JRRewindableDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(MeasurementDataSource.class);
    private int numberRows;
    protected QueryResponse response;
    private int currentRow = -1;

    public MeasurementDataSource(InputStream inputStream) {
        this(inputStream != null ? (QueryResponse)JAXB.unmarshal((InputStream)inputStream, QueryResponse.class) : null);
    }

    public MeasurementDataSource(QueryResponse queryResponse) {
        this.response = queryResponse;
        this.numberRows = 0;
        if (queryResponse != null && queryResponse.getTimestamps() != null) {
            this.numberRows = queryResponse.getTimestamps().length;
        }
        LOG.debug("New {} created with {} rows: {}", new Object[]{this.getClass().getName(), this.numberRows, this.response});
    }

    protected Object getFieldValue(String name, int rowIndex) {
        if (this.response == null) {
            return null;
        }
        LOG.debug("Getting field value for field {}:{}", (Object)rowIndex, (Object)name);
        if ("step".equals(name)) {
            return this.response.getStep();
        }
        if ("start".equals(name)) {
            return this.response.getStart();
        }
        if ("end".equals(name)) {
            return this.response.getEnd();
        }
        if ("timestamp".equals(name) && this.response.getTimestamps() != null && this.response.getTimestamps().length > rowIndex) {
            return new Date(this.response.getTimestamps()[rowIndex]);
        }
        double[] values = (double[])this.response.columnsWithLabels().get(name);
        if (values != null && values.length > rowIndex) {
            return values[rowIndex];
        }
        return null;
    }

    protected int getRowCount() {
        return this.numberRows;
    }

    protected List<JRField> getFields() {
        ArrayList<JRField> fields = new ArrayList<JRField>();
        fields.add(MeasurementDataSource.createField("step", Long.class));
        fields.add(MeasurementDataSource.createField("end", Long.class));
        fields.add(MeasurementDataSource.createField("start", Long.class));
        fields.add(MeasurementDataSource.createField("timestamp", Date.class));
        if (this.response != null) {
            for (String eachLabel : this.response.getLabels()) {
                fields.add(MeasurementDataSource.createField(eachLabel, Double.class));
            }
        }
        return fields;
    }

    protected static JRField createField(String name, Class clazz) {
        JRDesignField field = new JRDesignField();
        field.setValueClass(clazz);
        field.setName(name);
        return field;
    }

    public boolean next() {
        ++this.currentRow;
        return this.currentRow < this.getRowCount();
    }

    public Object getFieldValue(JRField jrField) {
        return this.getFieldValue(jrField.getName(), this.currentRow);
    }

    public void moveFirst() {
        this.currentRow = -1;
    }

    protected int getCurrentRow() {
        return this.currentRow;
    }
}

