/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.helper;

import com.google.common.base.Strings;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.jasper.helper.RrdLabelUtils;
import org.opennms.netmgt.jasper.helper.SpringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MeasurementsHelper {
    private static Logger LOG = LoggerFactory.getLogger(MeasurementsHelper.class);

    private MeasurementsHelper() {
    }

    public static String getInterfaceDescriptor(String snmpifname, String snmpifdescr, String snmpphysaddr) {
        return RrdLabelUtils.computeLabelForRRD(snmpifname, snmpifdescr, snmpphysaddr);
    }

    public static String getNodeOrNodeSourceDescriptor(String nodeId, String foreignSource, String foreignId) {
        if (!Strings.isNullOrEmpty((String)foreignSource) && !Strings.isNullOrEmpty((String)foreignId)) {
            return String.format("nodeSource[%s:%s]", foreignSource, foreignId);
        }
        return String.format("node[%s]", nodeId);
    }

    public static boolean isRunInOpennmsJvm() {
        return MeasurementsHelper.getSpringHelper().getSpringContext() != null;
    }

    public static SpringHelper getSpringHelper() {
        try {
            return (SpringHelper)BeanUtils.getBean((String)"measurementDataSourceContext", (String)"springHelper", SpringHelper.class);
        }
        catch (Exception ex) {
            LOG.warn("Error creating bean 'springHelper'. Creating empty SpringHelper");
            return new SpringHelper();
        }
    }
}

