/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.measurement.local;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.xml.bind.JAXB;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.opennms.netmgt.jasper.measurement.EmptyJRDataSource;
import org.opennms.netmgt.jasper.measurement.MeasurementDataSource;
import org.opennms.netmgt.jasper.measurement.MeasurementDataSourceWrapper;
import org.opennms.netmgt.measurements.api.ExpressionEngine;
import org.opennms.netmgt.measurements.api.FilterEngine;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.api.MeasurementsService;
import org.opennms.netmgt.measurements.api.exceptions.ResourceNotFoundException;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.opennms.netmgt.measurements.model.QueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMeasurementDataSourceWrapper
implements MeasurementDataSourceWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(LocalMeasurementDataSourceWrapper.class);
    private final MeasurementsService fetchService;

    public LocalMeasurementDataSourceWrapper(MeasurementFetchStrategy fetchStrategy, ExpressionEngine expressionEngine, FilterEngine filterEngine) {
        Objects.requireNonNull(fetchStrategy);
        Objects.requireNonNull(expressionEngine);
        Objects.requireNonNull(filterEngine);
        this.fetchService = new MeasurementsService(fetchStrategy, expressionEngine, filterEngine);
    }

    @Override
    public JRRewindableDataSource createDataSource(String query) throws JRException {
        Objects.requireNonNull(query);
        QueryRequest queryRequest = this.unmarshal(query);
        Objects.requireNonNull(queryRequest);
        try {
            QueryResponse response = this.fetchService.query(queryRequest);
            return new MeasurementDataSource(response);
        }
        catch (ResourceNotFoundException rnfe) {
            LOG.warn("A attribute or resource was not found", (Throwable)rnfe);
            return new EmptyJRDataSource();
        }
        catch (Exception e) {
            LOG.error("An error occurred while fetching the measurement results", (Throwable)e);
            throw new JRException((Throwable)e);
        }
    }

    @Override
    public void close() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QueryRequest unmarshal(String query) throws JRException {
        try (ByteArrayInputStream input = new ByteArrayInputStream(query.getBytes());){
            QueryRequest request;
            QueryRequest queryRequest = request = (QueryRequest)JAXB.unmarshal((InputStream)input, QueryRequest.class);
            return queryRequest;
        }
        catch (IOException e) {
            LOG.error("An error occurred while unmarshalling the query string", (Throwable)e);
            throw new JRException((Throwable)e);
        }
    }
}

