/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.measurement;

import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.opennms.netmgt.jasper.measurement.RemoteMeasurementDataSourceWrapper;

class MeasurementQueryExecutor
extends JRAbstractQueryExecuter {
    private static final String SSL_PROPERTY_KEY = "org.opennms.netmgt.jasper.measurement.ssl.enable";
    private RemoteMeasurementDataSourceWrapper dataSourceCreator;

    protected MeasurementQueryExecutor(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        if (dataset != null) {
            this.parseQuery();
        }
    }

    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    public boolean cancelQuery() throws JRException {
        return false;
    }

    public JRRewindableDataSource createDatasource() throws JRException {
        return this.getDataSource((String)this.getParameterValue("MEASUREMENT_URL"), (String)this.getParameterValue("MEASUREMENT_USERNAME", true), (String)this.getParameterValue("MEASUREMENT_PASSWORD", true), this.getQueryString());
    }

    public JRRewindableDataSource getDataSource(String url, String username, String password, String query) throws JRException {
        if (this.dataSourceCreator == null) {
            this.dataSourceCreator = new RemoteMeasurementDataSourceWrapper(MeasurementQueryExecutor.useSSL(), url, username, password);
        }
        return this.dataSourceCreator.createDataSource(query);
    }

    public void close() {
        try {
            if (this.dataSourceCreator != null) {
                this.dataSourceCreator.disconnect();
            }
        }
        finally {
            this.dataSourceCreator = null;
        }
    }

    private static boolean useSSL() {
        return Boolean.valueOf(System.getProperty(SSL_PROPERTY_KEY, "false"));
    }
}

