/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.chart;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

public class FormatNumberAxisWithBytesCustomizer
implements JRChartCustomizer {
    public void customize(JFreeChart chart, JRChart jasperChart) {
        XYPlot xyPlot;
        ValueAxis axis;
        Plot plot = chart.getPlot();
        if (plot instanceof XYPlot && (axis = (xyPlot = (XYPlot)plot).getRangeAxis()) instanceof NumberAxis) {
            NumberAxis numberAxis = (NumberAxis)axis;
            numberAxis.setNumberFormatOverride((NumberFormat)new ByteFormat());
        }
    }

    public static class ByteFormat
    extends NumberFormat {
        private static final long serialVersionUID = 2292353515765577691L;
        private static DecimalFormat df = new DecimalFormat("#.####");

        public static String getBytes(double bytes) {
            Format largestFormat = Format.B;
            long denum = 0L;
            Format[] formatArray = Format.values();
            int n = formatArray.length;
            for (int i = 0; i < n; ++i) {
                Format fmt;
                largestFormat = fmt = formatArray[i];
                denum = denum == 0L ? 1L : (denum *= 1024L);
                if ((long)(bytes / (double)(denum * 1024L)) == 0L) break;
            }
            return df.format(bytes / (double)denum) + (Object)((Object)largestFormat);
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(ByteFormat.getBytes(number));
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(ByteFormat.getBytes(number));
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return null;
        }

        private static enum Format {
            B,
            KB,
            MB,
            GB,
            TB,
            PB;

        }
    }
}

