/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.analytics;

import org.opennms.netmgt.jasper.analytics.AnalyticsCommand;

public class TrendLineConfig {
    private final String m_outputColumn;
    private final String m_inputColumn;
    private final long m_secondsAhead;
    private final int m_polynomialOrder;

    public TrendLineConfig(String outputColumn, String inputColumn, long secondsAhead, int polynomialOrder) {
        this.m_outputColumn = outputColumn;
        this.m_inputColumn = inputColumn;
        this.m_secondsAhead = secondsAhead;
        this.m_polynomialOrder = polynomialOrder;
    }

    public static TrendLineConfig parse(AnalyticsCommand cmd) {
        String inputColumn = cmd.getStringArgument(0, "(TrendLine) input column");
        long secondsAhead = cmd.getLongArgument(1, -1L, "(TrendLine) seconds ahead");
        int polynomialOrder = cmd.getIntArgument(2, 1, "(TrendLine) polynomial order");
        return new TrendLineConfig(cmd.getColumnNameOrPrefix(), inputColumn, secondsAhead, polynomialOrder);
    }

    public String getOutputColumn() {
        return this.m_outputColumn;
    }

    public String getInputColumn() {
        return this.m_inputColumn;
    }

    public long getSecondsAhead() {
        return this.m_secondsAhead;
    }

    public int getPolynomialOrder() {
        return this.m_polynomialOrder;
    }
}

