/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.analytics;

import com.google.common.collect.Lists;
import com.google.common.collect.RowSortedTable;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.opennms.netmgt.jasper.analytics.AnalyticsCommand;
import org.opennms.netmgt.jasper.analytics.DataSourceUtils;
import org.opennms.netmgt.jasper.analytics.Filter;
import org.opennms.netmgt.jasper.analytics.FilterFactory;

public class RrdDataSourceFilter {
    private final String m_originalQueryString;
    private final String m_rrdQueryString;
    private final String[] m_fieldNames;
    private final Pattern m_xportCommandPattern = Pattern.compile("XPORT:[\\w]+:([\\w]+)");
    private final Pattern m_queryStringPattern = Pattern.compile("ANALYTICS:([\\w]+)=([\\w]+)(:[^\\s]+)?");
    private final List<AnalyticsCommand> m_analyticsCommands = Lists.newArrayList();
    private static final ServiceLoader<FilterFactory> m_analyticsModules = ServiceLoader.load(FilterFactory.class);

    public RrdDataSourceFilter(String queryString) {
        this.m_originalQueryString = queryString;
        this.m_rrdQueryString = this.parseCmdsFromQs();
        this.m_fieldNames = this.parseFieldNamesFromQs();
    }

    private String[] parseFieldNamesFromQs() {
        ArrayList fieldNames = Lists.newArrayList();
        Matcher m = this.m_xportCommandPattern.matcher(this.m_rrdQueryString);
        while (m.find()) {
            fieldNames.add(m.group(1));
        }
        if (fieldNames.size() > 0) {
            fieldNames.add("Timestamp");
        }
        return fieldNames.toArray(new String[0]);
    }

    private String parseCmdsFromQs() {
        Matcher m = this.m_queryStringPattern.matcher(this.m_originalQueryString);
        while (m.find()) {
            String[] arguments = new String[]{};
            if (m.group(3) != null) {
                arguments = m.group(3).substring(1).split(":");
            }
            AnalyticsCommand cmd = new AnalyticsCommand(m.group(1), m.group(2), arguments);
            this.m_analyticsCommands.add(cmd);
        }
        return m.replaceAll("").trim();
    }

    public String getRrdQueryString() {
        return this.m_rrdQueryString;
    }

    public JRRewindableDataSource filter(JRRewindableDataSource ds) throws JRException {
        if (this.m_analyticsCommands.isEmpty()) {
            return ds;
        }
        RowSortedTable<Integer, String, Double> dsAsTable = DataSourceUtils.fromDs(ds, this.m_fieldNames);
        try {
            this.filter(dsAsTable);
        }
        catch (Exception e) {
            throw new JRException("Failed to enrich the data source.", (Throwable)e);
        }
        return DataSourceUtils.toDs(dsAsTable);
    }

    public void filter(RowSortedTable<Integer, String, Double> dsAsTable) throws Exception {
        for (AnalyticsCommand command : this.m_analyticsCommands) {
            Filter filter = this.getFilter(command);
            if (filter == null) {
                throw new JRException("No analytics module found for " + command);
            }
            filter.filter(dsAsTable);
        }
    }

    private Filter getFilter(AnalyticsCommand command) throws Exception {
        Filter filter = null;
        for (FilterFactory module : m_analyticsModules) {
            filter = module.getFilter(command);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    protected List<AnalyticsCommand> getAnalyticsCommands() {
        return this.m_analyticsCommands;
    }

    protected String[] getFieldNames() {
        return this.m_fieldNames;
    }
}

