/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.analytics;

import org.opennms.netmgt.jasper.analytics.AnalyticsCommand;

public class HWForecastConfig {
    private final String m_outputPrefix;
    private final String m_inputColumn;
    private final int m_numPeriodsToForecast;
    private final long m_period;
    private final double m_confidenceLevel;

    protected HWForecastConfig(String outputPrefix, String inputColumn, int numPeriodsToForecast, long periodInSeconds, double confidenceLevel) {
        this.m_outputPrefix = outputPrefix;
        this.m_inputColumn = inputColumn;
        this.m_numPeriodsToForecast = numPeriodsToForecast;
        this.m_period = periodInSeconds;
        this.m_confidenceLevel = confidenceLevel;
    }

    public static HWForecastConfig parse(AnalyticsCommand cmd) {
        String inputColumn = cmd.getStringArgument(0, "(HWForecast) input column");
        int numPeriodsToForecast = cmd.getIntArgument(1, 3, "(HWForecast) number of periods to forecast");
        long periodInSeconds = cmd.getLongArgument(2, 0L, "(HWForecast) period in seconds");
        double confidenceLevel = cmd.getDoubleArgument(3, 0.95, "(HWForecast) confidence level");
        return new HWForecastConfig(cmd.getColumnNameOrPrefix(), inputColumn, numPeriodsToForecast, periodInSeconds, confidenceLevel);
    }

    public String getOutputPrefix() {
        return this.m_outputPrefix;
    }

    public String getInputColumn() {
        return this.m_inputColumn;
    }

    public int getNumPeriodsToForecast() {
        return this.m_numPeriodsToForecast;
    }

    public long getPeriod() {
        return this.m_period;
    }

    public double getConfidenceLevel() {
        return this.m_confidenceLevel;
    }
}

