/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.analytics;

import org.opennms.netmgt.jasper.analytics.AnalyticsCommand;

public class ChompConfig {
    private final double m_cutoffDate;
    private final boolean m_stripNaNs;

    protected ChompConfig(double cutoffDate, boolean stringNaNs) {
        this.m_cutoffDate = cutoffDate;
        this.m_stripNaNs = stringNaNs;
    }

    public static ChompConfig parse(AnalyticsCommand cmd) {
        double cutoffDate = Double.parseDouble(cmd.getColumnNameOrPrefix()) * 1000.0;
        boolean stripNaNs = cmd.getBooleanArgument(0, false, "(Chomp) stripNaNs)");
        return new ChompConfig(cutoffDate, stripNaNs);
    }

    public double getCutoffDate() {
        return this.m_cutoffDate;
    }

    public boolean getStripNaNs() {
        return this.m_stripNaNs;
    }
}

