/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.analytics;

import com.google.common.collect.RowSortedTable;
import com.google.common.collect.Sets;
import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import org.opennms.netmgt.jasper.analytics.ChompConfig;
import org.opennms.netmgt.jasper.analytics.DataSourceUtils;
import org.opennms.netmgt.jasper.analytics.Filter;

public class Chomp
implements Filter {
    private final ChompConfig m_config;

    public Chomp(ChompConfig config) {
        this.m_config = config;
    }

    @Override
    public void filter(RowSortedTable<Integer, String, Double> dsAsTable) throws Exception {
        int i;
        int numRowsInTable;
        int lastRowToKeep;
        int firstRowToKeep = lastRowToKeep = (numRowsInTable = dsAsTable.rowKeySet().size());
        Iterator iterator = dsAsTable.rowKeySet().iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            if (!((Double)dsAsTable.get((Object)k, (Object)"Timestamp") >= this.m_config.getCutoffDate())) continue;
            firstRowToKeep = k;
            break;
        }
        if (this.m_config.getStripNaNs()) {
            HashSet columnNamesNoTs = Sets.newHashSet((Iterable)dsAsTable.columnKeySet());
            columnNamesNoTs.remove("Timestamp");
            Point rowsWithValues = DataSourceUtils.getRowsWithValues(dsAsTable, columnNamesNoTs.toArray(new String[0]));
            firstRowToKeep = Math.max(firstRowToKeep, rowsWithValues.x);
            lastRowToKeep = Math.min(lastRowToKeep, rowsWithValues.y);
        }
        HashSet columnNames = Sets.newHashSet((Iterable)dsAsTable.columnKeySet());
        for (i = lastRowToKeep + 1; i < numRowsInTable; ++i) {
            for (String columnName : columnNames) {
                dsAsTable.remove((Object)i, (Object)columnName);
            }
        }
        for (i = 0; i < firstRowToKeep; ++i) {
            for (String columnName : columnNames) {
                dsAsTable.remove((Object)i, (Object)columnName);
            }
        }
        if (firstRowToKeep > 0) {
            int j = 0;
            for (int i2 = firstRowToKeep; i2 <= lastRowToKeep; ++i2) {
                for (String columnName : columnNames) {
                    Double value = (Double)dsAsTable.get((Object)i2, (Object)columnName);
                    if (value != null) {
                        dsAsTable.put((Object)j, (Object)columnName, (Object)value);
                    }
                    dsAsTable.remove((Object)i2, (Object)columnName);
                }
                ++j;
            }
        }
    }
}

