/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.query.QueryExecuterFactoryBundle;
import org.opennms.netmgt.jasper.jrobin.JRobinQueryExecutorFactory;
import org.opennms.netmgt.jasper.resource.ResourceQueryExecuterFactory;
import org.opennms.netmgt.jasper.rrdtool.RrdtoolQueryExecutorFactory;

public class OnmsQueryExecutorFactoryBundle
implements QueryExecuterFactoryBundle {
    public String[] getLanguages() {
        return new String[]{"jrobin", "rrdtool", "resourceQuery"};
    }

    public JRQueryExecuterFactory getQueryExecuterFactory(String language) throws JRException {
        String reportLanguage = this.checkReportLanguage(language);
        if ("jrobin".equals(reportLanguage)) {
            return new JRobinQueryExecutorFactory();
        }
        if ("rrdtool".equals(reportLanguage)) {
            return new RrdtoolQueryExecutorFactory();
        }
        if ("resourceQuery".equals(reportLanguage)) {
            return new ResourceQueryExecuterFactory();
        }
        return null;
    }

    private String checkReportLanguage(String language) {
        boolean found = false;
        for (String lng : this.getLanguages()) {
            if (!lng.equals(language)) continue;
            found = true;
        }
        if (!found) {
            return language;
        }
        if (language.equals("resourceQuery")) {
            return language;
        }
        String strategy = System.getProperty("org.opennms.rrd.strategyClass");
        if (strategy == null) {
            return language;
        }
        String[] strategySplit = strategy.split("\\.");
        String rrdStrategy = strategySplit[strategySplit.length - 1];
        if (rrdStrategy.equals("JniRrdStrategy")) {
            return "rrdtool";
        }
        if (rrdStrategy.equals("JRobinRrdStrategy")) {
            return "jrobin";
        }
        return "";
    }
}

