/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.rrdtool;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.util.JRProperties;
import org.exolab.castor.xml.Unmarshaller;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.jasper.rrdtool.RrdtoolDataSource;
import org.opennms.netmgt.jasper.rrdtool.Xport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class RrdtoolXportCmd {
    private static final Logger LOG = LoggerFactory.getLogger(RrdtoolXportCmd.class);

    public JRRewindableDataSource executeCommand(String queryString) throws JRException {
        Xport data = this.getXportData(queryString);
        return new RrdtoolDataSource(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xport getXportData(String queryString) throws JRException {
        String rrdBinary = this.getRrdBinary();
        if (rrdBinary == null) {
            throw new JRException("rrd.binary property must be set either in opennms.properties or in iReport");
        }
        String command = rrdBinary + " xport " + queryString.replaceAll("[\r\n]+", " ").replaceAll("\\s+", " ");
        LOG.debug("getXportData: executing command: {}", (Object)command);
        String[] commandArray = StringUtils.createCommandArray((String)command, (char)'@');
        Xport data = null;
        try {
            Process process = Runtime.getRuntime().exec(commandArray);
            byte[] byteArray = FileCopyUtils.copyToByteArray((InputStream)process.getInputStream());
            String errors = FileCopyUtils.copyToString((Reader)new InputStreamReader(process.getErrorStream()));
            if (errors.length() > 0) {
                LOG.error("getXportData: RRDtool command fail: {}", (Object)errors);
                return null;
            }
            try (BufferedReader reader = null;){
                ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
                reader = new BufferedReader(new InputStreamReader(is));
                data = (Xport)Unmarshaller.unmarshal(Xport.class, (Reader)reader);
            }
        }
        catch (Exception e) {
            LOG.error("getXportData: can't execute command '{}'", (Object)command, (Object)e);
            throw new JRException("getXportData: can't execute command '" + command + ": ", (Throwable)e);
        }
        return data;
    }

    private String getRrdBinary() {
        if (System.getProperty("rrd.binary") != null) {
            return System.getProperty("rrd.binary");
        }
        if (JRProperties.getProperty((String)"rrd.binary") != null) {
            return JRProperties.getProperty((String)"rrd.binary");
        }
        return null;
    }
}

