/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.jrobin;

import java.io.IOException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.opennms.netmgt.jasper.jrobin.RrdCmdScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RrdToolCmd {
    private static final Logger LOG = LoggerFactory.getLogger(RrdToolCmd.class);
    private RrdCmdScanner cmdScanner;
    static boolean rrdDbPoolUsed = true;
    static boolean standardOutUsed = true;

    RrdToolCmd() {
    }

    abstract String getCmdType();

    abstract JRRewindableDataSource execute() throws RrdException, IOException;

    JRRewindableDataSource executeCommand(String command) throws RrdException {
        this.cmdScanner = new RrdCmdScanner(command);
        try {
            return this.execute();
        }
        catch (IOException e) {
            LOG.debug("Error creating JRobinDatasource: The Following Exception Occured: {}", (Object)e.getMessage());
            return new EmptyJRDataSource();
        }
    }

    String getOptionValue(String shortForm, String longForm) throws RrdException {
        return this.cmdScanner.getOptionValue(shortForm, longForm);
    }

    String getOptionValue(String shortForm, String longForm, String defaultValue) throws RrdException {
        return this.cmdScanner.getOptionValue(shortForm, longForm, defaultValue);
    }

    String[] getMultipleOptionValues(String shortForm, String longForm) throws RrdException {
        return this.cmdScanner.getMultipleOptions(shortForm, longForm);
    }

    boolean getBooleanOption(String shortForm, String longForm) {
        return this.cmdScanner.getBooleanOption(shortForm, longForm);
    }

    String[] getRemainingWords() {
        return this.cmdScanner.getRemainingWords();
    }

    static boolean isRrdDbPoolUsed() {
        return rrdDbPoolUsed;
    }

    static void setRrdDbPoolUsed(boolean rrdDbPoolUsed) {
        RrdToolCmd.rrdDbPoolUsed = rrdDbPoolUsed;
    }

    static boolean isStandardOutUsed() {
        return standardOutUsed;
    }

    static void setStandardOutUsed(boolean standardOutUsed) {
        RrdToolCmd.standardOutUsed = standardOutUsed;
    }

    static long parseLong(String value) throws RrdException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw new RrdException((Throwable)nfe);
        }
    }

    static int parseInt(String value) throws RrdException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new RrdException((Throwable)nfe);
        }
    }

    static double parseDouble(String value) throws RrdException {
        if (value.equals("U")) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw new RrdException((Throwable)nfe);
        }
    }

    static void print(String s) {
        if (standardOutUsed) {
            System.out.print(s);
        }
    }

    static void println(String s) {
        if (standardOutUsed) {
            System.out.println(s);
        }
    }

    static RrdDb getRrdDbReference(String path) throws IOException, RrdException {
        if (rrdDbPoolUsed) {
            return RrdDbPool.getInstance().requestRrdDb(path);
        }
        return new RrdDb(path);
    }

    static RrdDb getRrdDbReference(String path, String xmlPath) throws IOException, RrdException {
        if (rrdDbPoolUsed) {
            return RrdDbPool.getInstance().requestRrdDb(path, xmlPath);
        }
        return new RrdDb(path, xmlPath);
    }

    static RrdDb getRrdDbReference(RrdDef rrdDef) throws IOException, RrdException {
        if (rrdDbPoolUsed) {
            return RrdDbPool.getInstance().requestRrdDb(rrdDef);
        }
        return new RrdDb(rrdDef);
    }

    static void releaseRrdDbReference(RrdDb rrdDb) throws IOException, RrdException {
        if (rrdDbPoolUsed) {
            RrdDbPool.getInstance().release(rrdDb);
        } else {
            rrdDb.close();
        }
    }

    public static class EmptyJRDataSource
    implements JRRewindableDataSource {
        public Object getFieldValue(JRField jrField) throws JRException {
            return null;
        }

        public boolean next() throws JRException {
            return false;
        }

        public void moveFirst() throws JRException {
        }
    }
}

