/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.analytics;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RowSortedTable;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.integrations.R.RScriptException;
import org.opennms.netmgt.integrations.R.RScriptExecutor;
import org.opennms.netmgt.integrations.R.RScriptInput;
import org.opennms.netmgt.integrations.R.RScriptOutput;
import org.opennms.netmgt.jasper.analytics.Filter;
import org.opennms.netmgt.jasper.analytics.OutlierFilterConfig;

public class OutlierFilter
implements Filter {
    private static final String PATH_TO_R_SCRIPT = "/org/opennms/netmgt/jasper/analytics/outlierFilter.R";
    private final OutlierFilterConfig m_config;

    public OutlierFilter(OutlierFilterConfig config) {
        this.m_config = config;
    }

    @Override
    public void filter(RowSortedTable<Integer, String, Double> dsAsTable) throws RScriptException {
        String columnToFilter = this.m_config.getInputColumn();
        HashMap arguments = Maps.newHashMap();
        arguments.put("columnToFilter", columnToFilter);
        arguments.put("probability", this.m_config.getProbability());
        RScriptExecutor executor = new RScriptExecutor();
        RScriptOutput output = executor.exec(PATH_TO_R_SCRIPT, new RScriptInput(dsAsTable, (Map)arguments));
        ImmutableTable outputTable = output.getTable();
        int numRowsInTable = dsAsTable.rowKeySet().size();
        for (int i = 0; i < numRowsInTable; ++i) {
            dsAsTable.put((Object)i, (Object)columnToFilter, outputTable.get((Object)i, (Object)columnToFilter));
        }
    }
}

