/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.analytics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RowSortedTable;
import java.awt.Point;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.integrations.R.RScriptException;
import org.opennms.netmgt.integrations.R.RScriptExecutor;
import org.opennms.netmgt.integrations.R.RScriptInput;
import org.opennms.netmgt.integrations.R.RScriptOutput;
import org.opennms.netmgt.jasper.analytics.DataSourceUtils;
import org.opennms.netmgt.jasper.analytics.Filter;
import org.opennms.netmgt.jasper.analytics.HWForecastConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HWForecast
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(HWForecast.class);
    private static final String PATH_TO_R_SCRIPT = "/org/opennms/netmgt/jasper/analytics/holtWinters.R";
    private final HWForecastConfig m_config;

    public HWForecast(HWForecastConfig config) {
        this.m_config = config;
    }

    @Override
    public void filter(RowSortedTable<Integer, String, Double> table) throws RScriptException {
        int i;
        Preconditions.checkArgument((boolean)table.containsColumn((Object)"Timestamp"), (Object)"Data source must have a 'Timestamp' column.");
        Point rowsWithValues = DataSourceUtils.getRowsWithValues(table, new String[]{this.m_config.getInputColumn()});
        int firstRowWithValues = rowsWithValues.x;
        int lastRowWithValues = rowsWithValues.y;
        int numSampleRows = lastRowWithValues - firstRowWithValues;
        if (numSampleRows < 1) {
            LOG.error("Insufficent values in column for forecasting. Excluding forecast columns from data source.");
            return;
        }
        Date lastTimestamp = new Date(((Double)table.get((Object)lastRowWithValues, (Object)"Timestamp")).longValue());
        long stepInMs = (long)((Double)table.get((Object)lastRowWithValues, (Object)"Timestamp") - (Double)table.get((Object)(lastRowWithValues - 1), (Object)"Timestamp"));
        int numSamplesPerPeriod = (int)Math.floor(this.m_config.getPeriod() * 1000L / stepInMs);
        numSamplesPerPeriod = Math.max(1, numSamplesPerPeriod);
        int numForecasts = numSamplesPerPeriod * this.m_config.getNumPeriodsToForecast();
        HashMap arguments = Maps.newHashMap();
        arguments.put("columnToForecast", this.m_config.getInputColumn());
        arguments.put("numSamplesPerSeason", numSamplesPerPeriod);
        arguments.put("numForecasts", numForecasts);
        arguments.put("confidenceLevel", this.m_config.getConfidenceLevel());
        arguments.put("firstIndex", firstRowWithValues + 1);
        arguments.put("lastIndex", lastRowWithValues + 1);
        RScriptExecutor executor = new RScriptExecutor();
        RScriptOutput output = executor.exec(PATH_TO_R_SCRIPT, new RScriptInput(table, (Map)arguments));
        ImmutableTable outputTable = output.getTable();
        int numOutputRows = outputTable.rowKeySet().size();
        int numFittedValues = numOutputRows - numForecasts;
        for (i = 0; i < numFittedValues; ++i) {
            int idxTarget = i + (numSampleRows - numFittedValues) + firstRowWithValues + 1;
            table.put((Object)idxTarget, (Object)(this.m_config.getOutputPrefix() + "Fit"), outputTable.get((Object)i, (Object)"fit"));
        }
        for (i = numFittedValues; i < numOutputRows; ++i) {
            int idxForecast = i - numFittedValues + 1;
            int idxTarget = lastRowWithValues + idxForecast;
            table.put((Object)idxTarget, (Object)(this.m_config.getOutputPrefix() + "Fit"), outputTable.get((Object)i, (Object)"fit"));
            table.put((Object)idxTarget, (Object)(this.m_config.getOutputPrefix() + "Lwr"), outputTable.get((Object)i, (Object)"lwr"));
            table.put((Object)idxTarget, (Object)(this.m_config.getOutputPrefix() + "Upr"), outputTable.get((Object)i, (Object)"upr"));
            table.put((Object)idxTarget, (Object)"Timestamp", (Object)new Date(lastTimestamp.getTime() + stepInMs * (long)idxForecast).getTime());
        }
    }
}

