/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.analytics;

import com.google.common.collect.Lists;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.awt.Point;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesDataSource;
import net.sf.jasperreports.data.cache.DoubleArrayValues;
import net.sf.jasperreports.data.cache.ObjectArrayValues;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;

public class DataSourceUtils {
    public static ColumnValuesDataSource toDs(Table<Integer, String, Double> table) {
        String[] columnNames = table.columnKeySet().toArray(new String[0]);
        LinkedList columnValues = Lists.newLinkedList();
        int numRows = table.rowKeySet().size();
        for (String columnName : columnNames) {
            int i;
            Object[] values;
            if ("Timestamp".equalsIgnoreCase(columnName)) {
                values = new Date[numRows];
                for (i = 0; i < numRows; ++i) {
                    values[i] = new Date(((Double)table.get((Object)i, (Object)columnName)).longValue());
                }
                columnValues.add(new ObjectArrayValues(values));
                continue;
            }
            values = new double[numRows];
            for (i = 0; i < numRows; ++i) {
                Double value = (Double)table.get((Object)i, (Object)columnName);
                values[i] = value != null ? (Object)value : (Object)Double.NaN;
            }
            columnValues.add(new DoubleArrayValues((double[])values));
        }
        return new ColumnValuesDataSource(columnNames, numRows, columnValues.toArray(new ColumnValues[0]));
    }

    public static RowSortedTable<Integer, String, Double> fromDs(JRRewindableDataSource ds, String ... fieldNames) throws JRException {
        TreeBasedTable table = TreeBasedTable.create();
        int rowIndex = 0;
        while (ds.next()) {
            for (String fieldName : fieldNames) {
                JRDesignField field = new JRDesignField();
                field.setDescription(fieldName);
                field.setName(fieldName);
                field.setValueClass(Object.class);
                table.put((Object)rowIndex, (Object)fieldName, (Object)DataSourceUtils.getValueAsDouble(ds.getFieldValue((JRField)field)));
            }
            ++rowIndex;
        }
        ds.moveFirst();
        return table;
    }

    private static Double getValueAsDouble(Object o) {
        if (o instanceof Date) {
            return ((Date)o).getTime();
        }
        try {
            return (Double)o;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Invalid value type. Does the datasource originate from an RRD or JRB file?", e);
        }
    }

    public static Point getRowsWithValues(Table<Integer, String, Double> table, String ... columnNames) {
        int firstRowWithValues = -1;
        int lastRowWithValues = -1;
        Iterator i$ = table.rowKeySet().iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            for (String columnName : columnNames) {
                Double value = (Double)table.get((Object)k, (Object)columnName);
                if (value == null || Double.isNaN(value)) continue;
                if (firstRowWithValues < 0) {
                    firstRowWithValues = k;
                }
                lastRowWithValues = k;
            }
        }
        return new Point(firstRowWithValues, lastRowWithValues);
    }
}

