/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.analytics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsCommand.class);
    protected static final String CMD_IN_RRD_QUERY_STRING = "ANALYTICS";
    private final String m_module;
    private final String m_columnNameOrPrefix;
    private final String[] m_arguments;

    public AnalyticsCommand(String module, String columnNameOrPrefix, String[] arguments) {
        this.m_module = module;
        this.m_columnNameOrPrefix = columnNameOrPrefix;
        this.m_arguments = arguments;
    }

    public String getModule() {
        return this.m_module;
    }

    public String getColumnNameOrPrefix() {
        return this.m_columnNameOrPrefix;
    }

    public String[] getArguments() {
        return this.m_arguments;
    }

    public String getStringArgument(int index, String label) {
        if (this.m_arguments.length >= index + 1) {
            return this.m_arguments[index];
        }
        throw new IllegalArgumentException("Required argument '" + label + "' missing.");
    }

    public int getIntArgument(int index, int defaultValue, String label) {
        if (this.m_arguments.length >= index + 1) {
            try {
                return Integer.parseInt(this.m_arguments[index]);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid {}: '{}'. Defaulting to {}.", (Object)this.m_arguments[index], (Object)defaultValue);
            }
        }
        return defaultValue;
    }

    public long getLongArgument(int index, long defaultValue, String label) {
        if (this.m_arguments.length >= index + 1) {
            try {
                return Long.parseLong(this.m_arguments[index]);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid {}: '{}'. Defaulting to {}.", (Object)this.m_arguments[index], (Object)defaultValue);
            }
        }
        return defaultValue;
    }

    public double getDoubleArgument(int index, double defaultValue, String label) {
        if (this.m_arguments.length >= index + 1) {
            try {
                return Double.parseDouble(this.m_arguments[index]);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid {}: '{}'. Defaulting to {}.", (Object)this.m_arguments[index], (Object)defaultValue);
            }
        }
        return defaultValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_IN_RRD_QUERY_STRING);
        sb.append(":");
        sb.append(this.m_module);
        sb.append("=");
        sb.append(this.m_columnNameOrPrefix);
        for (String arg : this.m_arguments) {
            sb.append(":");
            sb.append(arg);
        }
        return sb.toString();
    }
}

