/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.rrdtool;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRProperties;
import org.exolab.castor.xml.Unmarshaller;
import org.opennms.core.utils.StringUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.jasper.rrdtool.RrdtoolDataSource;
import org.opennms.netmgt.jasper.rrdtool.Xport;
import org.springframework.util.FileCopyUtils;

public class RrdtoolXportCmd {
    public JRDataSource executeCommand(String queryString) throws JRException {
        Xport data = this.getXportData(queryString);
        return new RrdtoolDataSource(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xport getXportData(String queryString) throws JRException {
        String rrdBinary = this.getRrdBinary();
        if (rrdBinary == null) {
            throw new JRException("rrd.binary property must be set either in opennms.properties or in iReport");
        }
        String command = rrdBinary + " xport " + queryString.replaceAll("[\r\n]+", " ").replaceAll("\\s+", " ");
        this.log().debug("getXportData: executing command: " + command);
        String[] commandArray = StringUtils.createCommandArray((String)command, (char)'@');
        Xport data = null;
        try {
            Process process = Runtime.getRuntime().exec(commandArray);
            byte[] byteArray = FileCopyUtils.copyToByteArray((InputStream)process.getInputStream());
            String errors = FileCopyUtils.copyToString((Reader)new InputStreamReader(process.getErrorStream()));
            if (errors.length() > 0) {
                this.log().error("getXportData: RRDtool command fail: " + errors);
                return null;
            }
            BufferedReader reader = null;
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
                reader = new BufferedReader(new InputStreamReader(is));
                data = (Xport)Unmarshaller.unmarshal(Xport.class, (Reader)reader);
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            this.log().error("getXportData: can't execute command '" + command + ": ", (Throwable)e);
            throw new JRException("getXportData: can't execute command '" + command + ": ", (Throwable)e);
        }
        return data;
    }

    private String getRrdBinary() {
        if (System.getProperty("rrd.binary") != null) {
            return System.getProperty("rrd.binary");
        }
        if (JRProperties.getProperty((String)"rrd.binary") != null) {
            return JRProperties.getProperty((String)"rrd.binary");
        }
        return null;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

