/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.opennms.netmgt.jasper.helper.ResourcePathFileTraversal;
import org.opennms.netmgt.jasper.resource.ResourceQuery;

public class ResourceDataSource
implements JRDataSource {
    private int m_currentRow = -1;
    private List<String> m_paths;
    private ResourceFilterFields m_filterFields;

    public ResourceDataSource(ResourceQuery query) {
        this.extractPaths(query);
        this.m_filterFields = new ResourceFilterFields(query.getFilters(), query.getStringProperties());
    }

    private void extractPaths(ResourceQuery query) {
        ResourcePathFileTraversal traverser = new ResourcePathFileTraversal(new File(query.constructBasePath()));
        traverser.addDatasourceFilters(query.getFilters());
        this.m_paths = traverser.traverseDirectory();
        Collections.sort(this.m_paths);
        System.err.println("paths: " + this.m_paths);
    }

    public Object getFieldValue(JRField field) throws JRException {
        return this.computeValueForField(field);
    }

    private Object computeValueForField(JRField field) {
        if (field.getName().toLowerCase().equals("path")) {
            String pathField = this.m_paths.get(this.m_currentRow);
            System.err.println("path field:[" + pathField + "]");
            return this.m_paths.get(this.m_currentRow);
        }
        if (this.m_filterFields.containsField(field.getName())) {
            return this.calculateFieldValue(field, this.m_paths.get(this.m_currentRow));
        }
        return null;
    }

    private String calculateFieldValue(JRField field, String absolutePath) {
        return this.m_filterFields.getValueForField(field.getName(), absolutePath);
    }

    public boolean next() throws JRException {
        ++this.m_currentRow;
        return this.m_currentRow < this.m_paths.size();
    }

    private class ResourceFilterFields {
        private String[] m_fields;
        private String[] m_strProps;

        public ResourceFilterFields(String[] fields, String[] strProps) {
            this.m_fields = fields;
            this.m_strProps = strProps;
        }

        public String getValueForField(String fieldName, String curPath) {
            if (this.contains(fieldName, this.m_fields)) {
                return this.getFilenameForField(fieldName, curPath);
            }
            if (this.contains(fieldName, this.m_strProps)) {
                return this.getStringsPropertyValue(fieldName, curPath);
            }
            return null;
        }

        private String getStringsPropertyValue(String fieldName, String curPath) {
            File curDir = new File(curPath);
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File f, String name) {
                    return name.matches("strings.properties");
                }
            };
            File[] strFiles = curDir.listFiles(filter);
            if (curDir.exists() && strFiles.length == 1) {
                File strPropFile = strFiles[0];
                Properties props = new Properties();
                try {
                    FileInputStream fis = new FileInputStream(strPropFile);
                    props.load(fis);
                    return props.getProperty(fieldName);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        private String getFilenameForField(String dsName, String curPath) {
            File curDir = new File(curPath);
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return name.matches("ds.properties");
                }
            };
            if (curDir.exists() && curDir.list(filter).length > 0) {
                return this.getFilenameFromDSfile(new File(curDir.getAbsoluteFile() + "" + File.separator + "ds.properties"), dsName);
            }
            return curDir.getAbsolutePath() + File.separator + dsName + this.getFileExtension();
        }

        private String getFilenameFromDSfile(File file, String dsName) {
            Properties props = new Properties();
            String filename = "";
            try {
                FileInputStream fis = new FileInputStream(file);
                props.load(fis);
                filename = props.getProperty(dsName);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return file.getParent() + File.separator + filename + "" + this.getFileExtension();
        }

        private String getFileExtension() {
            String jniStrategy = System.getProperty("org.opennms.rrd.strategyClass");
            String rrdFileExtension = System.getProperty("org.opennms.rrd.fileExtension");
            if (jniStrategy != null && jniStrategy.contains("JniRrdStrategy")) {
                if (rrdFileExtension != null) {
                    return rrdFileExtension;
                }
                return ".rrd";
            }
            return ".jrb";
        }

        public boolean containsField(String fieldName) {
            return this.contains(fieldName, this.m_fields) || this.contains(fieldName, this.m_strProps);
        }

        private boolean contains(String fieldName, String[] array) {
            if (array != null) {
                for (String fName : array) {
                    if (!fName.equals(fieldName)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

