/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import net.sf.jasperreports.engine.util.JRProperties;
import org.opennms.core.utils.RrdLabelUtils;

public class JRobinDirectoryUtil {
    public boolean isStoreByGroup() {
        return JRProperties.getBooleanProperty((String)"org.opennms.rrd.storeByGroup") || Boolean.getBoolean("org.opennms.rrd.storeByGroup");
    }

    public boolean isStoreByForeignSource() {
        return JRProperties.getBooleanProperty((String)"org.opennms.rrd.storeByForeignSource") || Boolean.getBoolean("org.opennms.rrd.storeByForeignSource");
    }

    public String getNodeLevelResourceDirectory(String rrdDirectory, String nodeId, String foreignSource, String foreignId) {
        StringBuffer directory = new StringBuffer();
        directory.append(rrdDirectory).append(File.separator);
        if (this.isStoreByForeignSource()) {
            directory.append("fs").append(File.separator).append(foreignSource).append(File.separator).append(foreignId);
        } else {
            directory.append(nodeId);
        }
        return directory.toString();
    }

    public String getIfInOctetsDataSource(String rrdDirectory, String nodeId, String iFace) throws IOException {
        if (this.isStoreByForeignSource()) {
            throw new IllegalArgumentException("getIfInOctetsDataSource(String,String,String) can't be used if storeByForeignSource is enabled.");
        }
        return this.getIfInOctetsDataSource(rrdDirectory, nodeId, null, null, iFace);
    }

    public String getIfInOctetsDataSource(String rrdDirectory, String nodeId, String foreignSource, String foreignId, String iFace) throws IOException {
        StringBuffer directory = new StringBuffer();
        directory.append(this.getNodeLevelResourceDirectory(rrdDirectory, nodeId, foreignSource, foreignId)).append(File.separator).append(iFace);
        if (!this.isStoreByGroup()) {
            if (this.checkIfHCExists("ifHCInOctets", directory.toString())) {
                return "ifHCInOctets";
            }
            return "ifInOctets";
        }
        if (this.checkDsPropertyFileFor("ifHCInOctets", directory.toString())) {
            return "ifHCInOctets";
        }
        return "ifInOctets";
    }

    public String getIfOutOctetsDataSource(String rrdDirectory, String nodeId, String iFace) throws IOException {
        if (this.isStoreByForeignSource()) {
            throw new IllegalArgumentException("getIfOutOctetsDataSource(String,String,String) can't be used if storeByForeignSource is enabled.");
        }
        return this.getIfOutOctetsDataSource(rrdDirectory, nodeId, null, null, iFace);
    }

    public String getIfOutOctetsDataSource(String rrdDirectory, String nodeId, String foreignSource, String foreignId, String iFace) throws IOException {
        StringBuffer directory = new StringBuffer();
        directory.append(this.getNodeLevelResourceDirectory(rrdDirectory, nodeId, foreignSource, foreignId)).append(File.separator).append(iFace);
        if (!this.isStoreByGroup()) {
            if (this.checkIfHCExists("ifHCOutOctets", directory.toString())) {
                return "ifHCOutOctets";
            }
            return "ifOutOctets";
        }
        if (this.checkDsPropertyFileFor("ifHCOutOctets", directory.toString())) {
            return "ifHCOutOctets";
        }
        return "ifOutOctets";
    }

    private boolean checkDsPropertyFileFor(String ifOctetsDS, String directory) throws IOException {
        File f = new File(directory.toString() + "" + File.separator + "ds.properties");
        if (f.exists()) {
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(f);
            prop.load(fis);
            fis.close();
            return prop.get(ifOctetsDS) != null;
        }
        return false;
    }

    public String getIfInOctetsJrb(String rrdDirectory, String nodeId, String iFace) throws FileNotFoundException, IOException {
        if (this.isStoreByForeignSource()) {
            throw new IllegalArgumentException("getIfInOctetsJrb(String,String,String) can't be used if storeByForeignSource is enabled.");
        }
        return this.getOctetsFile(rrdDirectory, nodeId, null, null, iFace, "ifHCInOctets", "ifInOctets");
    }

    public String getIfInOctetsJrb(String rrdDirectory, String nodeId, String foreignSource, String foreignId, String iFace) throws FileNotFoundException, IOException {
        return this.getOctetsFile(rrdDirectory, nodeId, foreignSource, foreignId, iFace, "ifHCInOctets", "ifInOctets");
    }

    public String getIfOutOctetsJrb(String rrdDirectory, String nodeId, String iFace) throws FileNotFoundException, IOException {
        if (this.isStoreByForeignSource()) {
            throw new IllegalArgumentException("getIfOutOctetsJrb(String,String,String) can't be used if storeByForeignSource is enabled.");
        }
        return this.getOctetsFile(rrdDirectory, nodeId, null, null, iFace, "ifHCOutOctets", "ifOutOctets");
    }

    public String getIfOutOctetsJrb(String rrdDirectory, String nodeId, String foreignSource, String foreignId, String iFace) throws FileNotFoundException, IOException {
        return this.getOctetsFile(rrdDirectory, nodeId, foreignSource, foreignId, iFace, "ifHCOutOctets", "ifOutOctets");
    }

    private String getOctetsFile(String rrdDirectory, String nodeId, String foreignSource, String foreignId, String iFace, String ifHCFilename, String ifFilename) throws FileNotFoundException, IOException {
        StringBuffer directory = new StringBuffer();
        directory.append(this.getNodeLevelResourceDirectory(rrdDirectory, nodeId, foreignSource, foreignId)).append(File.separator).append(iFace);
        if (this.isStoreByGroup()) {
            this.appendStoreByGroup(directory);
        } else if (this.checkIfHCExists(ifHCFilename, directory.toString())) {
            directory.append(File.separator).append(ifHCFilename).append(this.getExtension());
        } else {
            directory.append(File.separator).append(ifFilename).append(this.getExtension());
        }
        return directory.toString();
    }

    private boolean checkIfHCExists(String ifHCFilename, String dir) {
        File ifOctets = new File(dir + "" + File.separator + ifHCFilename + this.getExtension());
        return ifOctets.exists();
    }

    private String getExtension() {
        if (JRProperties.getProperty((String)"org.opennms.rrd.fileExtension") != null) {
            return JRProperties.getProperty((String)"org.opennms.rrd.fileExtension");
        }
        if (System.getProperty("org.opennms.rrd.fileExtension") != null) {
            return System.getProperty("org.opennms.rrd.fileExtension");
        }
        if (System.getProperty("org.opennms.rrd.strategyClass") != null) {
            return System.getProperty("org.opennms.rrd.strategyClass", "UnknownStrategy").endsWith("JRobinRrdStrategy") ? ".jrb" : ".rrd";
        }
        return ".jrb";
    }

    private void appendStoreByGroup(StringBuffer directory) throws FileNotFoundException, IOException {
        File f = new File(directory.toString() + "" + File.separator + "ds.properties");
        if (f.exists()) {
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(f);
            prop.load(fis);
            fis.close();
            if (prop.get("ifHCInOctets") != null) {
                directory.append(File.separator).append((String)prop.get("ifHCInOctets")).append(this.getExtension());
            } else {
                directory.append(File.separator).append((String)prop.get("ifInOctets")).append(this.getExtension());
            }
        }
    }

    public String getInterfaceDirectory(String snmpifname, String snmpifdescr, String snmpphysaddr) {
        return RrdLabelUtils.computeLabelForRRD((String)snmpifname, (String)snmpifdescr, (String)snmpphysaddr);
    }
}

