/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.resource;

import org.opennms.netmgt.jasper.resource.ResourceQuery;

public class ResourceQueryCommandParser {
    private ResourceQuery m_currentQuery;
    private static String DELIMETER = ",";

    private void setCurrentQuery(ResourceQuery q) {
        this.m_currentQuery = q;
    }

    private ResourceQuery getCurrentQuery() {
        return this.m_currentQuery;
    }

    public ResourceQuery parseQueryCommand(String queryCommand) {
        String[] cmdArray;
        ResourceQuery retVal = new ResourceQuery();
        this.setCurrentQuery(retVal);
        String command = queryCommand.trim();
        for (String cmd : cmdArray = command.split("--")) {
            this.processCommand(cmd.trim());
        }
        return retVal;
    }

    private void processCommand(String command) {
        if (command.toLowerCase().contains("rrddir")) {
            this.processRrdDir(command);
        } else if (command.toLowerCase().contains("nodeid")) {
            this.processNodeId(command);
        } else if (command.toLowerCase().contains("resourcetype")) {
            this.processResourceName(command);
        } else if (command.toLowerCase().contains("dsname")) {
            this.processFilters(command);
        } else if (command.toLowerCase().contains("string")) {
            this.processStringProperties(command);
        }
    }

    private void processStringProperties(String command) {
        String value = command.substring(command.toLowerCase().indexOf("string") + "string".length(), command.length());
        String[] strProperties = value.trim().split(DELIMETER);
        this.getCurrentQuery().setStringProperties(strProperties);
    }

    private void processFilters(String command) {
        String value = command.substring(command.toLowerCase().indexOf("dsname") + "dsname".length(), command.length());
        String[] strFilters = value.trim().split(DELIMETER);
        this.getCurrentQuery().setFilters(strFilters);
    }

    private void processResourceName(String command) {
        String value = command.substring(command.toLowerCase().indexOf("resourcetype") + "resourcetype".length(), command.length());
        this.getCurrentQuery().setResourceName(value.trim());
    }

    private void processNodeId(String command) {
        String value = command.substring(command.toLowerCase().indexOf("nodeid") + "nodeid".length(), command.length());
        this.getCurrentQuery().setNodeId(value.trim());
    }

    private void processRrdDir(String command) {
        String value = command.substring(command.toLowerCase().indexOf("rrddir") + "rrdDir".length(), command.length());
        this.getCurrentQuery().setRrdDir(value.trim());
    }
}

