/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.helper;

import java.util.Date;
import java.util.GregorianCalendar;

public class TimeRange {
    public Date getStartDate(String range) {
        Date date = null;
        if (TIME_RANGE.LAST_YEAR.name().equalsIgnoreCase(range)) {
            date = TIME_RANGE.LAST_YEAR.getStartDate();
        } else if (TIME_RANGE.LAST_MONTH.name().equalsIgnoreCase(range)) {
            date = TIME_RANGE.LAST_MONTH.getStartDate();
        } else if (TIME_RANGE.THIS_YEAR.name().equalsIgnoreCase(range)) {
            date = TIME_RANGE.THIS_YEAR.getStartDate();
        } else if (TIME_RANGE.THIS_MONTH.name().equalsIgnoreCase(range)) {
            date = TIME_RANGE.THIS_MONTH.getStartDate();
        } else if (TIME_RANGE.LAST_SEVEN_DAYS.name().equalsIgnoreCase(range)) {
            date = TIME_RANGE.LAST_SEVEN_DAYS.getStartDate();
        }
        return date;
    }

    public Date getEndDate(String range) {
        Date date = null;
        if (TIME_RANGE.LAST_YEAR.name().equalsIgnoreCase(range)) {
            date = TIME_RANGE.LAST_YEAR.getEndDate();
        } else if (TIME_RANGE.LAST_MONTH.name().equalsIgnoreCase(range)) {
            date = TIME_RANGE.LAST_MONTH.getEndDate();
        } else if (TIME_RANGE.THIS_YEAR.name().equalsIgnoreCase(range)) {
            date = TIME_RANGE.THIS_YEAR.getEndDate();
        } else if (TIME_RANGE.THIS_MONTH.name().equalsIgnoreCase(range)) {
            date = TIME_RANGE.THIS_MONTH.getEndDate();
        } else if (TIME_RANGE.LAST_SEVEN_DAYS.name().equalsIgnoreCase(range)) {
            date = TIME_RANGE.LAST_SEVEN_DAYS.getEndDate();
        }
        return date;
    }

    private static enum TIME_RANGE {
        LAST_SEVEN_DAYS{

            @Override
            public Date getStartDate() {
                return new Date(new GregorianCalendar(new GregorianCalendar().get(1), new GregorianCalendar().get(2), new GregorianCalendar().get(5) - 7).getTimeInMillis());
            }
        }
        ,
        LAST_MONTH{

            @Override
            public Date getStartDate() {
                return new Date(new GregorianCalendar(new GregorianCalendar().get(1), new GregorianCalendar().get(2) - 1, 1).getTimeInMillis());
            }

            @Override
            public Date getEndDate() {
                return new Date(new GregorianCalendar(new GregorianCalendar().get(1), new GregorianCalendar().get(2), 0, 23, 59, 59).getTimeInMillis());
            }
        }
        ,
        LAST_YEAR{

            @Override
            public Date getStartDate() {
                return new Date(new GregorianCalendar(new GregorianCalendar().get(1) - 1, 0, 1).getTimeInMillis());
            }

            @Override
            public Date getEndDate() {
                return new Date(new GregorianCalendar(new GregorianCalendar().get(1) - 1, 12, 0, 23, 59, 59).getTimeInMillis());
            }
        }
        ,
        THIS_MONTH{

            @Override
            public Date getStartDate() {
                return new Date(new GregorianCalendar(new GregorianCalendar().get(1), new GregorianCalendar().get(2), 1).getTimeInMillis());
            }
        }
        ,
        THIS_YEAR{

            @Override
            public Date getStartDate() {
                return new Date(new GregorianCalendar(new GregorianCalendar().get(1), 0, 1).getTimeInMillis());
            }
        };


        public abstract Date getStartDate();

        public Date getEndDate() {
            return new Date(new GregorianCalendar(new GregorianCalendar().get(1), new GregorianCalendar().get(2), new GregorianCalendar().get(5)).getTimeInMillis());
        }
    }
}

