/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ResourcePathFileTraversal {
    private final File m_file;
    private List<String> m_dataSourceFilterList = new ArrayList<String>();

    public ResourcePathFileTraversal(File f) {
        this.m_file = f;
        if (!this.m_file.exists()) {
            System.err.println("Directory does not exist: " + f.getAbsolutePath());
        }
    }

    public List<String> traverseDirectory() {
        ArrayList<String> paths = new ArrayList<String>();
        this.addTopLevelIfNecessary(paths);
        this.traverseDirectory(this.m_file, paths);
        return paths;
    }

    private void addTopLevelIfNecessary(List<String> paths) {
        File[] fList = this.m_file.listFiles();
        if (fList != null) {
            for (File f : fList) {
                if (!f.isFile()) continue;
                this.onDirectory(this.m_file, paths);
                break;
            }
        }
    }

    private void traverseDirectory(File f, List<String> dirPaths) {
        if (f.isDirectory()) {
            File[] children;
            for (File child : children = f.listFiles()) {
                if (!child.isDirectory()) continue;
                this.onDirectory(child, dirPaths);
                this.traverseDirectory(child, dirPaths);
            }
            return;
        }
        this.onFile(f);
    }

    private void onFile(File f) {
        System.err.println(f.getName());
    }

    private void onDirectory(File f, List<String> dirPaths) {
        if (System.getProperty("org.opennms.rrd.storeByGroup") != null && System.getProperty("org.opennms.rrd.storeByGroup").toLowerCase().equals("true")) {
            try {
                if (this.validateDataSource(f)) {
                    dirPaths.add(f.getAbsolutePath());
                }
            }
            catch (IOException iOException) {}
        } else if (this.validateFiles(f)) {
            dirPaths.add(f.getAbsolutePath());
        }
    }

    private boolean validateDataSource(File f) throws IOException {
        FilenameFilter dsFilenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("ds.properties");
            }
        };
        if (f.list(dsFilenameFilter).length > 0) {
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(f.getAbsolutePath() + "/ds.properties");
            prop.load(fis);
            fis.close();
            for (String datasource : this.m_dataSourceFilterList) {
                if (prop.get(datasource) != null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateFiles(File f) {
        List<FilenameFilter> filterList = this.getFilenameFilters();
        for (FilenameFilter filter : filterList) {
            String[] files = f.list(filter);
            if (files.length != 0) continue;
            return false;
        }
        return true;
    }

    private List<FilenameFilter> getFilenameFilters() {
        ArrayList<FilenameFilter> filters = new ArrayList<FilenameFilter>();
        for (final String dsName : this.m_dataSourceFilterList) {
            filters.add(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(dsName);
                }
            });
        }
        return filters;
    }

    public void addDatasourceFilters(String[] dsNames) {
        if (dsNames != null) {
            for (String dsName : dsNames) {
                this.m_dataSourceFilterList.add(dsName);
            }
        }
    }

    public void addDatasourceFilter(String dataSource) {
        this.m_dataSourceFilterList.add(dataSource);
    }
}

