/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui.dashboard;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Table;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.opennms.features.topology.api.support.InfoWindow;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.dashboard.SurveillanceViewDetailTable;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceViewNotificationTable
extends SurveillanceViewDetailTable {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewNotificationTable.class);
    private BeanItemContainer<Notification> m_beanItemContainer = new BeanItemContainer(Notification.class);
    protected ListenableFuture<List<Notification>> m_future;

    public SurveillanceViewNotificationTable(SurveillanceViewService surveillanceViewService, boolean enabled) {
        super("Notifications", surveillanceViewService, enabled);
        this.setContainerDataSource((Container)this.m_beanItemContainer);
        this.addStyleName("surveillance-view");
        this.addGeneratedColumn("nodeLabel", new Table.ColumnGenerator(){

            public Object generateCell(Table table, Object itemId, Object propertyId) {
                final Notification notification = (Notification)itemId;
                Button icon = SurveillanceViewNotificationTable.this.getClickableIcon(FontAwesome.BELL, new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        URI currentLocation = SurveillanceViewNotificationTable.this.getUI().getPage().getLocation();
                        String contextRoot = VaadinServlet.getCurrent().getServletContext().getContextPath();
                        String redirectFragment = contextRoot + "/notification/detail.jsp?quiet=true&notice=" + notification.getId();
                        LOG.debug("notification {} clicked, current location = {}, uri = {}", new Object[]{notification.getId(), currentLocation, redirectFragment});
                        try {
                            SurveillanceViewNotificationTable.this.getUI().addWindow((Window)new InfoWindow(new URL(currentLocation.toURL(), redirectFragment), new InfoWindow.LabelCreator(){

                                public String getLabel() {
                                    return "Notification Info " + notification.getId();
                                }
                            }));
                        }
                        catch (MalformedURLException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
                Button button = new Button(notification.getNodeLabel());
                button.setPrimaryStyleName("link");
                button.setEnabled(SurveillanceViewNotificationTable.this.m_enabled);
                button.addClickListener(new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        URI currentLocation = SurveillanceViewNotificationTable.this.getUI().getPage().getLocation();
                        String contextRoot = VaadinServlet.getCurrent().getServletContext().getContextPath();
                        String redirectFragment = contextRoot + "/element/node.jsp?quiet=true&node=" + notification.getNodeId();
                        LOG.debug("node {} clicked, current location = {}, uri = {}", new Object[]{notification.getNodeId(), currentLocation, redirectFragment});
                        try {
                            SurveillanceViewNotificationTable.this.getUI().addWindow((Window)new InfoWindow(new URL(currentLocation.toURL(), redirectFragment), new InfoWindow.LabelCreator(){

                                public String getLabel() {
                                    return "Node Info " + notification.getNodeId();
                                }
                            }));
                        }
                        catch (MalformedURLException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
                HorizontalLayout horizontalLayout = new HorizontalLayout();
                horizontalLayout.addComponent((Component)icon);
                horizontalLayout.addComponent((Component)button);
                horizontalLayout.setSpacing(true);
                return horizontalLayout;
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){

            public String getStyle(Table source, Object itemId, Object propertyId) {
                Notification notification = (Notification)itemId;
                return notification.getSeverity().toLowerCase();
            }
        });
        this.setColumnHeader("nodeLabel", "Node");
        this.setColumnHeader("serviceType", "Service");
        this.setColumnHeader("textMsg", "Message");
        this.setColumnHeader("pageTime", "Sent Time");
        this.setColumnHeader("answeredBy", "Responder");
        this.setColumnHeader("respondTime", "Respond Time");
        this.setColumnExpandRatio("nodeLabel", 2.0f);
        this.setColumnExpandRatio("serviceType", 1.0f);
        this.setColumnExpandRatio("textMsg", 4.0f);
        this.setColumnExpandRatio("pageTime", 2.0f);
        this.setColumnExpandRatio("answeredBy", 1.0f);
        this.setColumnExpandRatio("respondTime", 2.0f);
        this.setVisibleColumns(new Object[]{"nodeLabel", "serviceType", "textMsg", "pageTime", "answeredBy", "respondTime"});
    }

    @Override
    public void refreshDetails(final Set<OnmsCategory> rowCategories, final Set<OnmsCategory> colCategories) {
        if (this.m_future != null && !this.m_future.isDone()) {
            return;
        }
        this.m_future = this.getSurveillanceViewService().getExecutorService().submit((Callable)new Callable<List<Notification>>(){

            @Override
            public List<Notification> call() throws Exception {
                HashMap<OnmsNotification, String> customSeverity = new HashMap<OnmsNotification, String>();
                List<OnmsNotification> onmsNotifications = SurveillanceViewNotificationTable.this.getSurveillanceViewService().getNotificationsForCategories(rowCategories, colCategories, customSeverity);
                ArrayList<Notification> notifications = new ArrayList<Notification>();
                for (OnmsNotification onmsNotification : onmsNotifications) {
                    notifications.add(new Notification(onmsNotification.getNotifyId(), onmsNotification.getNodeId(), onmsNotification.getNodeLabel(), onmsNotification.getPageTime(), onmsNotification.getRespondTime(), onmsNotification.getAnsweredBy(), onmsNotification.getTextMsg(), onmsNotification.getServiceType() != null ? onmsNotification.getServiceType().getName() : "", (String)customSeverity.get(onmsNotification)));
                }
                return notifications;
            }
        });
        this.m_future.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    final List notifications = (List)SurveillanceViewNotificationTable.this.m_future.get();
                    SurveillanceViewNotificationTable.this.getUI().access(new Runnable(){

                        @Override
                        public void run() {
                            SurveillanceViewNotificationTable.this.m_beanItemContainer.removeAllItems();
                            if (notifications != null && !notifications.isEmpty()) {
                                for (Notification notification : notifications) {
                                    SurveillanceViewNotificationTable.this.m_beanItemContainer.addItem((Object)notification);
                                }
                            }
                            SurveillanceViewNotificationTable.this.sort(new Object[]{"pageTime"}, new boolean[]{false});
                            SurveillanceViewNotificationTable.this.refreshRowCache();
                        }
                    });
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.error("Exception in task", e.getCause());
                }
            }
        }, MoreExecutors.directExecutor());
    }

    public class Notification {
        private int id;
        private int nodeId;
        private String nodeLabel;
        private Date respondTime;
        private Date pageTime;
        private String answeredBy;
        private String textMsg;
        private String serviceType;
        private String severity;

        public Notification(int id, int nodeId, String nodeLabel, Date pageTime, Date respondTime, String answeredBy, String textMsg, String serviceType, String severity) {
            this.id = id;
            this.nodeId = nodeId;
            this.nodeLabel = nodeLabel;
            this.respondTime = respondTime;
            this.textMsg = textMsg;
            this.answeredBy = answeredBy;
            this.severity = severity;
            this.serviceType = serviceType;
            this.pageTime = pageTime;
        }

        public Date getPageTime() {
            return this.pageTime;
        }

        public String getAnsweredBy() {
            return this.answeredBy;
        }

        public int getId() {
            return this.id;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public String getNodeLabel() {
            return this.nodeLabel;
        }

        public Date getRespondTime() {
            return this.respondTime;
        }

        public String getTextMsg() {
            return this.textMsg;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public String getSeverity() {
            return this.severity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Notification that = (Notification)o;
            if (this.id != that.id) {
                return false;
            }
            if (this.nodeId != that.nodeId) {
                return false;
            }
            if (this.answeredBy != null ? !this.answeredBy.equals(that.answeredBy) : that.answeredBy != null) {
                return false;
            }
            if (this.nodeLabel != null ? !this.nodeLabel.equals(that.nodeLabel) : that.nodeLabel != null) {
                return false;
            }
            if (this.pageTime != null ? !this.pageTime.equals(that.pageTime) : that.pageTime != null) {
                return false;
            }
            if (this.respondTime != null ? !this.respondTime.equals(that.respondTime) : that.respondTime != null) {
                return false;
            }
            if (this.serviceType != null ? !this.serviceType.equals(that.serviceType) : that.serviceType != null) {
                return false;
            }
            if (this.severity != null ? !this.severity.equals(that.severity) : that.severity != null) {
                return false;
            }
            return !(this.textMsg != null ? !this.textMsg.equals(that.textMsg) : that.textMsg != null);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + this.nodeId;
            result = 31 * result + (this.nodeLabel != null ? this.nodeLabel.hashCode() : 0);
            result = 31 * result + (this.respondTime != null ? this.respondTime.hashCode() : 0);
            result = 31 * result + (this.pageTime != null ? this.pageTime.hashCode() : 0);
            result = 31 * result + (this.answeredBy != null ? this.answeredBy.hashCode() : 0);
            result = 31 * result + (this.textMsg != null ? this.textMsg.hashCode() : 0);
            result = 31 * result + (this.serviceType != null ? this.serviceType.hashCode() : 0);
            result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
            return result;
        }
    }
}

