/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui;

import com.vaadin.data.Property;
import com.vaadin.event.UIEvents;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.VerticalLayout;
import java.util.List;
import org.opennms.features.vaadin.surveillanceviews.config.SurveillanceViewProvider;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.SurveillanceViewTable;
import org.opennms.features.vaadin.surveillanceviews.ui.dashboard.SurveillanceViewAlarmTable;
import org.opennms.features.vaadin.surveillanceviews.ui.dashboard.SurveillanceViewGraphComponent;
import org.opennms.features.vaadin.surveillanceviews.ui.dashboard.SurveillanceViewNodeRtcTable;
import org.opennms.features.vaadin.surveillanceviews.ui.dashboard.SurveillanceViewNotificationTable;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceView
extends CssLayout
implements UIEvents.PollListener {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceView.class);
    private SurveillanceViewService m_surveillanceViewService;
    private SurveillanceViewTable m_surveillanceViewTable;
    private View m_view;
    private SurveillanceViewTableHeader m_surveillanceViewTableHeader;
    private VerticalLayout upperLayout;
    private VerticalLayout lowerLayout;
    private boolean m_dashboard = false;
    private boolean m_enabled = true;
    private int m_countdown;
    private boolean m_refreshEnabled = false;

    public SurveillanceView(View selectedView, SurveillanceViewService surveillanceViewService, boolean dashboard, boolean enabled) {
        this.m_surveillanceViewService = surveillanceViewService;
        this.m_view = selectedView;
        this.m_surveillanceViewTableHeader = new SurveillanceViewTableHeader();
        this.m_dashboard = dashboard;
        this.m_enabled = enabled;
        this.setSizeFull();
        this.setView(selectedView);
        this.addAttachListener(new ClientConnector.AttachListener(){

            public void attach(ClientConnector.AttachEvent attachEvent) {
                SurveillanceView.this.getUI().addPollListener((UIEvents.PollListener)SurveillanceView.this);
            }
        });
        this.addDetachListener(new ClientConnector.DetachListener(){

            public void detach(ClientConnector.DetachEvent detachEvent) {
                SurveillanceView.this.getUI().removePollListener((UIEvents.PollListener)SurveillanceView.this);
            }
        });
    }

    public void poll(UIEvents.PollEvent pollEvent) {
        if (this.m_refreshEnabled) {
            --this.m_countdown;
        }
        if (this.m_countdown < 0) {
            this.m_countdown = this.m_view.getRefreshSeconds();
            this.m_surveillanceViewTable.refresh();
        }
    }

    protected String getCss(Component c) {
        return "padding-left: 0px;";
    }

    public void setView(View view) {
        this.m_view = view;
        this.m_refreshEnabled = this.m_view.getRefreshSeconds() > 0;
        this.m_countdown = this.m_view.getRefreshSeconds();
        this.m_surveillanceViewTableHeader.setCaptionText("Surveillance view: " + this.m_view.getName());
        this.m_surveillanceViewTableHeader.select(this.m_view.getName());
        this.m_surveillanceViewTableHeader.getNativeSelect().setEnabled(this.m_enabled);
        this.removeAllComponents();
        this.upperLayout = new VerticalLayout();
        this.upperLayout.setId("surveillance-window");
        this.upperLayout.setSpacing(false);
        this.m_surveillanceViewTable = new SurveillanceViewTable(this.m_view, this.m_surveillanceViewService, this.m_dashboard, this.m_enabled);
        this.upperLayout.addComponent((Component)new Label("<div id=\"surveillanceview\"/>", ContentMode.HTML));
        this.upperLayout.addComponent((Component)this.m_surveillanceViewTableHeader);
        this.upperLayout.addComponent((Component)this.m_surveillanceViewTable);
        if (!this.m_dashboard) {
            this.addComponent((Component)this.upperLayout);
        } else {
            CssLayout leftCssLayout = new CssLayout(){

                protected String getCss(Component c) {
                    return "padding-bottom: 6px;";
                }
            };
            leftCssLayout.setPrimaryStyleName("col-md-11");
            leftCssLayout.setId("dashboard-content");
            CssLayout rightCssLayout = new CssLayout();
            rightCssLayout.setPrimaryStyleName("col-md-1");
            this.lowerLayout = new VerticalLayout();
            this.lowerLayout.setSpacing(true);
            SurveillanceViewAlarmTable surveillanceViewAlarmTable = new SurveillanceViewAlarmTable(this.m_surveillanceViewService, this.m_enabled);
            SurveillanceViewNotificationTable surveillanceViewNotificationTable = new SurveillanceViewNotificationTable(this.m_surveillanceViewService, this.m_enabled);
            SurveillanceViewNodeRtcTable surveillanceViewNodeRtcTable = new SurveillanceViewNodeRtcTable(this.m_surveillanceViewService, this.m_enabled);
            SurveillanceViewGraphComponent surveillanceViewGraphComponent = new SurveillanceViewGraphComponent(this.m_surveillanceViewService, this.m_enabled);
            surveillanceViewAlarmTable.setId("alarms");
            this.lowerLayout.addComponent((Component)surveillanceViewAlarmTable);
            surveillanceViewNotificationTable.setId("notifications");
            this.lowerLayout.addComponent((Component)surveillanceViewNotificationTable);
            surveillanceViewNodeRtcTable.setId("outages");
            this.lowerLayout.addComponent((Component)surveillanceViewNodeRtcTable);
            surveillanceViewGraphComponent.setId("resourcegraphs");
            this.lowerLayout.addComponent((Component)surveillanceViewGraphComponent);
            this.m_surveillanceViewTable.addDetailsTable(surveillanceViewAlarmTable);
            this.m_surveillanceViewTable.addDetailsTable(surveillanceViewNotificationTable);
            this.m_surveillanceViewTable.addDetailsTable(surveillanceViewNodeRtcTable);
            this.m_surveillanceViewTable.addDetailsTable(surveillanceViewGraphComponent);
            this.addComponent((Component)this.lowerLayout);
            leftCssLayout.addComponent((Component)this.upperLayout);
            leftCssLayout.addComponent((Component)this.lowerLayout);
            CssLayout resultsSidebar = new CssLayout();
            resultsSidebar.setPrimaryStyleName("resource-graphs-sidebar hidden-print hidden-xs hidden-sm sidebar-fixed");
            resultsSidebar.setId("results-sidebar");
            resultsSidebar.addComponent((Component)new Label("<ul class=\"nav nav-stacked\">\n                <li>\n                    <a href=\"#surveillanceview\" data-target=\"#surveillanceview\">Surveillance View</a>\n                </li>\n                <li>\n                    <a href=\"#alarms\" data-target=\"#alarms\">Alarms</a>\n                </li>\n                <li>\n                    <a href=\"#notifications\" data-target=\"#notifications\">Notifications</a>\n                </li>\n                <li>\n                    <a href=\"#outages\" data-target=\"#outages\">Outages</a>\n                </li>\n                <li>\n                    <a href=\"#resourcegraphs\" data-target=\"#resourcegraphs\">Resource Graphs</a>\n                </li>\n            </ul><script type=\"text/javascript\">\n            $('body').scrollspy({ target: '#results-sidebar' });\n</script>\n", ContentMode.HTML));
            rightCssLayout.addComponent((Component)resultsSidebar);
            this.addComponent((Component)leftCssLayout);
            this.addComponent((Component)rightCssLayout);
        }
    }

    public void setView(String name) {
        this.setView(SurveillanceViewProvider.getInstance().getView(name));
    }

    private class SurveillanceViewTableHeader
    extends HorizontalLayout {
        private Label m_label;
        private NativeSelect m_nativeSelect;

        private SurveillanceViewTableHeader() {
            this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
            this.setSpacing(false);
            this.setPrimaryStyleName("v-caption-surveillance-view");
            this.m_label = new Label();
            this.m_nativeSelect = new NativeSelect();
            this.m_nativeSelect.setNullSelectionAllowed(false);
            List views = SurveillanceViewProvider.getInstance().getSurveillanceViewConfiguration().getViews();
            for (View view : views) {
                this.m_nativeSelect.addItem((Object)view.getName());
            }
            this.m_nativeSelect.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                    String name = (String)valueChangeEvent.getProperty().getValue();
                    if (!name.equals(SurveillanceView.this.m_view.getName())) {
                        SurveillanceView.this.setView(name);
                    }
                }
            });
            this.addComponent((Component)this.m_label);
            this.addComponent((Component)this.m_nativeSelect);
            this.setComponentAlignment((Component)this.m_nativeSelect, Alignment.MIDDLE_RIGHT);
        }

        public void setCaptionText(String text) {
            this.m_label.setCaption(text);
        }

        public void select(String name) {
            this.m_nativeSelect.select((Object)name);
        }

        public NativeSelect getNativeSelect() {
            return this.m_nativeSelect;
        }
    }
}

