/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui;

import com.vaadin.event.ItemClickEvent;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.dashboard.SurveillanceViewDetail;
import org.opennms.netmgt.config.surveillanceViews.ColumnDef;
import org.opennms.netmgt.config.surveillanceViews.RowDef;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.SurveillanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceViewTable
extends Table {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewTable.class);
    private SurveillanceViewService m_surveillanceViewService;
    private Object m_selectedItemId;
    private Object m_selectedPropertyId;
    private List<SurveillanceViewDetail> m_detailTables = new ArrayList<SurveillanceViewDetail>();
    private Set<OnmsCategory> m_selectedRowCategories = null;
    private Set<OnmsCategory> m_selectedColumnCategories = null;
    private Set<OnmsCategory> m_allRowCategories = new HashSet<OnmsCategory>();
    private Set<OnmsCategory> m_allColumnCategories = new HashSet<OnmsCategory>();
    private SurveillanceStatus[][] m_cells;
    private Map<String, OnmsCategory> m_onmsCategoryMap = new HashMap<String, OnmsCategory>();
    private View m_view;
    private boolean m_enabled;
    private boolean m_dashboard;

    public SurveillanceViewTable(final View view, SurveillanceViewService surveillanceViewService, boolean dashboard, boolean enabled) {
        super(null);
        this.m_surveillanceViewService = surveillanceViewService;
        this.m_enabled = enabled;
        this.m_dashboard = dashboard;
        this.m_view = view;
        this.refresh();
        List<OnmsCategory> onmsCategories = this.m_surveillanceViewService.getOnmsCategories();
        for (OnmsCategory onmsCategory : onmsCategories) {
            this.m_onmsCategoryMap.put(onmsCategory.getName(), onmsCategory);
        }
        this.setSizeUndefined();
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.setSelectable(true);
        this.setMultiSelect(true);
        this.setImmediate(true);
        this.setSelectable(false);
        this.addStyleName("surveillance-view");
        this.addGeneratedColumn("", new Table.ColumnGenerator(){

            public Object generateCell(Table table, Object itemId, Object columnId) {
                Label label = new Label((String)itemId);
                label.setSizeFull();
                label.addStyleName("white");
                return label;
            }
        });
        this.setColumnHeader("", view.getName());
        this.setColumnExpandRatio("", 1.0f);
        for (ColumnDef columnDef : view.getColumns()) {
            this.m_allColumnCategories.addAll(this.getOnmsCategoriesForNames(columnDef.getCategoryNames()));
            this.addGeneratedColumn(columnDef.getLabel(), new Table.ColumnGenerator(){

                public Object generateCell(Table source, Object itemId, Object columnId) {
                    Optional rowDef = view.getRowDef((String)itemId);
                    Optional columnDef = view.getColumnDef((String)columnId);
                    int rowIndex = view.getRows().indexOf(rowDef.orElse(null));
                    int colIndex = view.getColumns().indexOf(columnDef.orElse(null));
                    SurveillanceStatus surveillanceStatus = SurveillanceViewTable.this.m_cells[rowIndex][colIndex];
                    Label label = new Label(surveillanceStatus.getDownEntityCount() + " of " + surveillanceStatus.getTotalEntityCount());
                    label.setSizeFull();
                    label.addStyleName(surveillanceStatus.getStatus().toLowerCase());
                    return label;
                }
            });
            this.setColumnExpandRatio(columnDef.getLabel(), 1.0f);
        }
        for (RowDef rowDef : view.getRows()) {
            this.m_allRowCategories.addAll(this.getOnmsCategoriesForNames(rowDef.getCategoryNames()));
            this.addItem(rowDef.getLabel());
            this.setItemCaption(rowDef.getLabel(), rowDef.getLabel());
        }
        this.m_selectedRowCategories = this.m_allRowCategories;
        this.m_selectedColumnCategories = this.m_allColumnCategories;
        this.setPageLength(this.getItemIds().size());
        if (this.m_dashboard) {
            this.setCellStyleGenerator(new Table.CellStyleGenerator(){

                public String getStyle(Table table, Object itemId, Object propertyId) {
                    if ("".equals(propertyId)) {
                        return null;
                    }
                    if (SurveillanceViewTable.this.m_selectedItemId != null && SurveillanceViewTable.this.m_selectedPropertyId != null && SurveillanceViewTable.this.m_selectedItemId.equals(itemId) && SurveillanceViewTable.this.m_selectedPropertyId.equals(propertyId)) {
                        return null;
                    }
                    if (SurveillanceViewTable.this.m_selectedPropertyId == null && SurveillanceViewTable.this.m_selectedItemId == null) {
                        return null;
                    }
                    if (SurveillanceViewTable.this.m_selectedItemId == null && SurveillanceViewTable.this.m_selectedPropertyId != null && SurveillanceViewTable.this.m_selectedPropertyId.equals(propertyId)) {
                        return null;
                    }
                    if (SurveillanceViewTable.this.m_selectedPropertyId == null && SurveillanceViewTable.this.m_selectedItemId != null && SurveillanceViewTable.this.m_selectedItemId.equals(itemId)) {
                        return null;
                    }
                    return "marked";
                }
            });
            this.addItemClickListener(new ItemClickEvent.ItemClickListener(){

                public void itemClick(ItemClickEvent itemClickEvent) {
                    String selectedColumn = (String)itemClickEvent.getPropertyId();
                    Optional columnDef = view.getColumnDef((String)itemClickEvent.getPropertyId());
                    Optional rowDef = view.getRowDef((String)itemClickEvent.getItemId());
                    if (!"".equals(selectedColumn)) {
                        SurveillanceViewTable.this.m_selectedItemId = itemClickEvent.getItemId();
                        SurveillanceViewTable.this.m_selectedPropertyId = itemClickEvent.getPropertyId();
                        Notification.show((String)(SurveillanceViewTable.this.m_selectedItemId + "/" + SurveillanceViewTable.this.m_selectedPropertyId + " selected"));
                        if (columnDef.isPresent()) {
                            SurveillanceViewTable.this.m_selectedRowCategories = SurveillanceViewTable.this.getOnmsCategoriesForNames(((RowDef)rowDef.get()).getCategoryNames());
                        }
                        if (rowDef.isPresent()) {
                            SurveillanceViewTable.this.m_selectedColumnCategories = SurveillanceViewTable.this.getOnmsCategoriesForNames(((ColumnDef)columnDef.get()).getCategoryNames());
                        }
                    } else {
                        SurveillanceViewTable.this.m_selectedItemId = itemClickEvent.getItemId();
                        SurveillanceViewTable.this.m_selectedPropertyId = null;
                        Notification.show((String)(SurveillanceViewTable.this.m_selectedItemId + " selected"));
                        if (rowDef.isPresent()) {
                            SurveillanceViewTable.this.m_selectedRowCategories = SurveillanceViewTable.this.getOnmsCategoriesForNames(((RowDef)rowDef.get()).getCategoryNames());
                        }
                        SurveillanceViewTable.this.m_selectedColumnCategories = SurveillanceViewTable.this.m_allColumnCategories;
                    }
                    SurveillanceViewTable.this.updateDetailsTable();
                    SurveillanceViewTable.this.markAsDirtyRecursive();
                }
            });
            this.addHeaderClickListener(new Table.HeaderClickListener(){

                public void headerClick(Table.HeaderClickEvent headerClickEvent) {
                    if ("".equals(headerClickEvent.getPropertyId())) {
                        SurveillanceViewTable.this.m_selectedRowCategories = SurveillanceViewTable.this.m_allRowCategories;
                        SurveillanceViewTable.this.m_selectedColumnCategories = SurveillanceViewTable.this.m_allColumnCategories;
                        SurveillanceViewTable.this.m_selectedItemId = null;
                        SurveillanceViewTable.this.m_selectedPropertyId = null;
                        Notification.show((String)"All entries selected");
                    } else {
                        SurveillanceViewTable.this.m_selectedItemId = null;
                        SurveillanceViewTable.this.m_selectedPropertyId = headerClickEvent.getPropertyId();
                        SurveillanceViewTable.this.m_selectedRowCategories = SurveillanceViewTable.this.m_allRowCategories;
                        Optional columnDef = view.getColumnDef((String)headerClickEvent.getPropertyId());
                        if (columnDef.isPresent()) {
                            SurveillanceViewTable.this.m_selectedColumnCategories = SurveillanceViewTable.this.getOnmsCategoriesForNames(((ColumnDef)columnDef.get()).getCategoryNames());
                        }
                        Notification.show((String)(SurveillanceViewTable.this.m_selectedPropertyId + " selected"));
                    }
                    SurveillanceViewTable.this.updateDetailsTable();
                    SurveillanceViewTable.this.markAsDirtyRecursive();
                }
            });
        }
    }

    public synchronized void refresh() {
        this.m_cells = this.m_surveillanceViewService.calculateCellStatus(this.m_view);
        this.refreshRowCache();
        this.updateDetailsTable();
        this.markAsDirtyRecursive();
    }

    private Set<OnmsCategory> getOnmsCategoriesForNames(Collection<String> collection) {
        HashSet<OnmsCategory> onmsCategories = new HashSet<OnmsCategory>();
        for (String name : collection) {
            onmsCategories.add(this.m_onmsCategoryMap.get(name));
        }
        return onmsCategories;
    }

    private void updateDetailsTable() {
        for (SurveillanceViewDetail surveillanceViewDetail : this.m_detailTables) {
            surveillanceViewDetail.refreshDetails(this.m_selectedRowCategories, this.m_selectedColumnCategories);
        }
    }

    public void addDetailsTable(SurveillanceViewDetail surveillanceViewDetail) {
        this.m_detailTables.add(surveillanceViewDetail);
        surveillanceViewDetail.refreshDetails(this.m_selectedRowCategories, this.m_selectedColumnCategories);
    }
}

