/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.DefaultItemSorter;
import com.vaadin.data.util.ItemSorter;
import com.vaadin.data.validator.AbstractStringValidator;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.vaadin.surveillanceviews.config.SurveillanceViewProvider;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.SurveillanceViewConfigurationCategoryWindow;
import org.opennms.features.vaadin.surveillanceviews.ui.SurveillanceViewsConfigUI;
import org.opennms.netmgt.config.surveillanceViews.ColumnDef;
import org.opennms.netmgt.config.surveillanceViews.Def;
import org.opennms.netmgt.config.surveillanceViews.RowDef;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceViewConfigurationWindow
extends Window {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewConfigurationWindow.class);

    public SurveillanceViewConfigurationWindow(final SurveillanceViewService surveillanceViewService, final View view, final SaveActionListener saveActionListener) {
        super("Surveillance view configuration");
        this.setModal(true);
        this.setClosable(false);
        this.setResizable(false);
        this.setWidth(80.0f, Sizeable.Unit.PERCENTAGE);
        this.setHeight(75.0f, Sizeable.Unit.PERCENTAGE);
        final TextField titleField = new TextField();
        titleField.setValue(view.getName());
        titleField.setImmediate(true);
        titleField.setCaption("Title");
        titleField.setDescription("Title of this surveillance view");
        titleField.setWidth(25.0f, Sizeable.Unit.PERCENTAGE);
        titleField.addValidator((Validator)new AbstractStringValidator("Please use an unique name for the surveillance view"){

            protected boolean isValidValue(String string) {
                if ("".equals(string.trim())) {
                    return false;
                }
                return !SurveillanceViewProvider.getInstance().containsView(string) || view.getName().equals(string);
            }
        });
        final TextField refreshSecondsField = new TextField();
        refreshSecondsField.setValue(String.valueOf(view.getRefreshSeconds()));
        refreshSecondsField.setImmediate(true);
        refreshSecondsField.setCaption("Refresh seconds");
        refreshSecondsField.setDescription("Refresh duration in seconds");
        refreshSecondsField.addValidator((Validator)new AbstractStringValidator("Only numbers allowed here"){

            protected boolean isValidValue(String s) {
                int number;
                try {
                    number = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return number >= 0;
            }
        });
        final Table columnsTable = new Table();
        columnsTable.setSortEnabled(false);
        columnsTable.setWidth(25.0f, Sizeable.Unit.PERCENTAGE);
        final BeanItemContainer columns = new BeanItemContainer(ColumnDef.class, (Collection)view.getColumns());
        final HashMap<ColumnDef, Integer> columnOrder = new HashMap<ColumnDef, Integer>();
        int c = 0;
        for (ColumnDef columnDef : view.getColumns()) {
            columnOrder.put(columnDef, c++);
        }
        columnsTable.setContainerDataSource((Container)columns);
        columnsTable.setVisibleColumns(new Object[]{"label"});
        columnsTable.setColumnHeader((Object)"label", "Columns");
        columnsTable.setColumnExpandRatio((Object)"label", 1.0f);
        columnsTable.setSelectable(true);
        columnsTable.setMultiSelect(false);
        columns.setItemSorter((ItemSorter)new DefaultItemSorter(){

            public int compare(Object o1, Object o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (((Integer)columnOrder.get(o1)).intValue() == ((Integer)columnOrder.get(o2)).intValue()) {
                    return 0;
                }
                if ((Integer)columnOrder.get(o1) > (Integer)columnOrder.get(o2)) {
                    return 1;
                }
                return -1;
            }
        });
        final Button columnsAddButton = new Button("Add");
        columnsAddButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                SurveillanceViewConfigurationWindow.this.getUI().addWindow((Window)new SurveillanceViewConfigurationCategoryWindow(surveillanceViewService, columnsTable.getItemIds(), (Def)new ColumnDef(), new SurveillanceViewConfigurationCategoryWindow.SaveActionListener(){

                    @Override
                    public void save(Def def) {
                        columns.addItem((Object)((ColumnDef)def));
                        columnOrder.put((ColumnDef)def, columnOrder.size());
                        columns.sort(new Object[]{"label"}, new boolean[]{true});
                        columnsTable.refreshRowCache();
                    }
                }));
            }
        });
        columnsAddButton.setEnabled(true);
        columnsAddButton.setStyleName("small");
        columnsAddButton.setDescription("Add column");
        columnsAddButton.setEnabled(true);
        final Button columnsEditButton = new Button("Edit");
        columnsEditButton.setEnabled(true);
        columnsEditButton.setStyleName("small");
        columnsEditButton.setDescription("Edit column");
        columnsEditButton.setEnabled(false);
        columnsEditButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                SurveillanceViewConfigurationWindow.this.getUI().addWindow((Window)new SurveillanceViewConfigurationCategoryWindow(surveillanceViewService, columnsTable.getItemIds(), (Def)((ColumnDef)columnsTable.getValue()), new SurveillanceViewConfigurationCategoryWindow.SaveActionListener(){

                    @Override
                    public void save(Def def) {
                        ColumnDef columnToBeReplaced = (ColumnDef)columnsTable.getValue();
                        int index = (Integer)columnOrder.get(columnToBeReplaced);
                        columns.removeItem((Object)columnToBeReplaced);
                        columnOrder.remove(columnToBeReplaced);
                        columns.addItem((Object)((ColumnDef)def));
                        columnOrder.put((ColumnDef)def, index);
                        columns.sort(new Object[]{"label"}, new boolean[]{true});
                        columnsTable.refreshRowCache();
                    }
                }));
            }
        });
        final Button columnsRemoveButton = new Button("Remove");
        columnsRemoveButton.setEnabled(true);
        columnsRemoveButton.setStyleName("small");
        columnsRemoveButton.setDescription("Remove column");
        columnsRemoveButton.setEnabled(false);
        columnsRemoveButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                ColumnDef columnDef = (ColumnDef)columnsTable.getValue();
                if (columnDef != null) {
                    columnsTable.unselect((Object)columnDef);
                    columns.removeItem((Object)columnDef);
                }
                columnsTable.refreshRowCache();
            }
        });
        final Button columnUpButton = new Button();
        columnUpButton.setStyleName("small");
        columnUpButton.setIcon((Resource)new ThemeResource("../runo/icons/16/arrow-up.png"));
        columnUpButton.setDescription("Move this a column entry one position up");
        columnUpButton.setEnabled(false);
        columnUpButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                ColumnDef columnDef = (ColumnDef)columnsTable.getValue();
                if (columnDef != null) {
                    int columnDefIndex = (Integer)columnOrder.get(columnDef);
                    ColumnDef columnDefToSwap = null;
                    for (Map.Entry entry : columnOrder.entrySet()) {
                        if ((Integer)entry.getValue() != columnDefIndex - 1) continue;
                        columnDefToSwap = (ColumnDef)entry.getKey();
                        break;
                    }
                    if (columnDefToSwap != null) {
                        columnsTable.unselect((Object)columnDef);
                        columnOrder.remove(columnDef);
                        columnOrder.remove(columnDefToSwap);
                        columnOrder.put(columnDef, columnDefIndex - 1);
                        columnOrder.put(columnDefToSwap, columnDefIndex);
                        columns.sort(new Object[]{"label"}, new boolean[]{true});
                        columnsTable.refreshRowCache();
                        columnsTable.select((Object)columnDef);
                    }
                }
            }
        });
        final Button columnDownButton = new Button();
        columnDownButton.setStyleName("small");
        columnDownButton.setIcon((Resource)new ThemeResource("../runo/icons/16/arrow-down.png"));
        columnDownButton.setDescription("Move this a column entry one position down");
        columnDownButton.setEnabled(false);
        columnDownButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                ColumnDef columnDef = (ColumnDef)columnsTable.getValue();
                if (columnDef != null) {
                    int columnDefIndex = (Integer)columnOrder.get(columnDef);
                    ColumnDef columnDefToSwap = null;
                    for (Map.Entry entry : columnOrder.entrySet()) {
                        if ((Integer)entry.getValue() != columnDefIndex + 1) continue;
                        columnDefToSwap = (ColumnDef)entry.getKey();
                        break;
                    }
                    if (columnDefToSwap != null) {
                        columnsTable.unselect((Object)columnDef);
                        columnOrder.remove(columnDef);
                        columnOrder.remove(columnDefToSwap);
                        columnOrder.put(columnDef, columnDefIndex + 1);
                        columnOrder.put(columnDefToSwap, columnDefIndex);
                        columns.sort(new Object[]{"label"}, new boolean[]{true});
                        columnsTable.refreshRowCache();
                        columnsTable.select((Object)columnDef);
                    }
                }
            }
        });
        columnsTable.setSizeFull();
        columnUpButton.setSizeFull();
        columnDownButton.setSizeFull();
        columnsAddButton.setSizeFull();
        columnsEditButton.setSizeFull();
        columnsRemoveButton.setSizeFull();
        columnsTable.setImmediate(true);
        columnsTable.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                boolean somethingSelected = columnsTable.getValue() != null;
                columnsRemoveButton.setEnabled(somethingSelected);
                columnsEditButton.setEnabled(somethingSelected);
                columnsAddButton.setEnabled(true);
                columnUpButton.setEnabled(somethingSelected && (Integer)columnOrder.get(columnsTable.getValue()) > 0);
                columnDownButton.setEnabled(somethingSelected && (Integer)columnOrder.get(columnsTable.getValue()) < columnOrder.size() - 1);
            }
        });
        final Table rowsTable = new Table();
        rowsTable.setSortEnabled(false);
        rowsTable.setWidth(25.0f, Sizeable.Unit.PERCENTAGE);
        final BeanItemContainer rows = new BeanItemContainer(RowDef.class, (Collection)view.getRows());
        final HashMap<RowDef, Integer> rowOrder = new HashMap<RowDef, Integer>();
        int r = 0;
        for (RowDef rowDef : view.getRows()) {
            rowOrder.put(rowDef, r++);
        }
        rowsTable.setContainerDataSource((Container)rows);
        rowsTable.setVisibleColumns(new Object[]{"label"});
        rowsTable.setColumnHeader((Object)"label", "Rows");
        rowsTable.setColumnExpandRatio((Object)"label", 1.0f);
        rowsTable.setSelectable(true);
        rowsTable.setMultiSelect(false);
        rows.setItemSorter((ItemSorter)new DefaultItemSorter(){

            public int compare(Object o1, Object o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (((Integer)rowOrder.get(o1)).intValue() == ((Integer)rowOrder.get(o2)).intValue()) {
                    return 0;
                }
                if ((Integer)rowOrder.get(o1) > (Integer)rowOrder.get(o2)) {
                    return 1;
                }
                return -1;
            }
        });
        final Button rowsAddButton = new Button("Add");
        rowsAddButton.setEnabled(true);
        rowsAddButton.setStyleName("small");
        rowsAddButton.setDescription("Add row");
        rowsAddButton.setEnabled(true);
        rowsAddButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                SurveillanceViewConfigurationWindow.this.getUI().addWindow((Window)new SurveillanceViewConfigurationCategoryWindow(surveillanceViewService, rowsTable.getItemIds(), (Def)new RowDef(), new SurveillanceViewConfigurationCategoryWindow.SaveActionListener(){

                    @Override
                    public void save(Def def) {
                        rows.addItem((Object)((RowDef)def));
                        rowOrder.put((RowDef)def, rowOrder.size());
                        rows.sort(new Object[]{"label"}, new boolean[]{true});
                        rowsTable.refreshRowCache();
                    }
                }));
            }
        });
        final Button rowsEditButton = new Button("Edit");
        rowsEditButton.setEnabled(true);
        rowsEditButton.setStyleName("small");
        rowsEditButton.setDescription("Edit row");
        rowsEditButton.setEnabled(false);
        rowsEditButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                SurveillanceViewConfigurationWindow.this.getUI().addWindow((Window)new SurveillanceViewConfigurationCategoryWindow(surveillanceViewService, rowsTable.getItemIds(), (Def)((RowDef)rowsTable.getValue()), new SurveillanceViewConfigurationCategoryWindow.SaveActionListener(){

                    @Override
                    public void save(Def def) {
                        RowDef rowToBeReplaced = (RowDef)rowsTable.getValue();
                        int index = (Integer)rowOrder.get(rowToBeReplaced);
                        rows.removeItem((Object)rowToBeReplaced);
                        rowOrder.remove(rowToBeReplaced);
                        rows.addItem((Object)((RowDef)def));
                        rowOrder.put((RowDef)def, index);
                        rows.sort(new Object[]{"label"}, new boolean[]{true});
                        rowsTable.refreshRowCache();
                    }
                }));
            }
        });
        final Button rowsRemoveButton = new Button("Remove");
        rowsRemoveButton.setEnabled(true);
        rowsRemoveButton.setStyleName("small");
        rowsRemoveButton.setDescription("Remove row");
        rowsRemoveButton.setEnabled(false);
        rowsRemoveButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                RowDef rowDef = (RowDef)rowsTable.getValue();
                if (rowDef != null) {
                    rowsTable.unselect((Object)rowDef);
                    rows.removeItem((Object)rowDef);
                }
                rowsTable.refreshRowCache();
            }
        });
        final Button rowUpButton = new Button();
        rowUpButton.setStyleName("small");
        rowUpButton.setIcon((Resource)new ThemeResource("../runo/icons/16/arrow-up.png"));
        rowUpButton.setDescription("Move this a row entry one position up");
        rowUpButton.setEnabled(false);
        rowUpButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                RowDef rowDef = (RowDef)rowsTable.getValue();
                if (rowDef != null) {
                    int rowDefIndex = (Integer)rowOrder.get(rowDef);
                    RowDef rowDefToSwap = null;
                    for (Map.Entry entry : rowOrder.entrySet()) {
                        if ((Integer)entry.getValue() != rowDefIndex - 1) continue;
                        rowDefToSwap = (RowDef)entry.getKey();
                        break;
                    }
                    if (rowDefToSwap != null) {
                        rowsTable.unselect((Object)rowDef);
                        rowOrder.remove(rowDef);
                        rowOrder.remove(rowDefToSwap);
                        rowOrder.put(rowDef, rowDefIndex - 1);
                        rowOrder.put(rowDefToSwap, rowDefIndex);
                        rows.sort(new Object[]{"label"}, new boolean[]{true});
                        rowsTable.refreshRowCache();
                        rowsTable.select((Object)rowDef);
                    }
                }
            }
        });
        final Button rowDownButton = new Button();
        rowDownButton.setStyleName("small");
        rowDownButton.setIcon((Resource)new ThemeResource("../runo/icons/16/arrow-down.png"));
        rowDownButton.setDescription("Move this a row entry one position down");
        rowDownButton.setEnabled(false);
        rowDownButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                RowDef rowDef = (RowDef)rowsTable.getValue();
                if (rowDef != null) {
                    int rowDefIndex = (Integer)rowOrder.get(rowDef);
                    RowDef rowDefToSwap = null;
                    for (Map.Entry entry : rowOrder.entrySet()) {
                        if ((Integer)entry.getValue() != rowDefIndex + 1) continue;
                        rowDefToSwap = (RowDef)entry.getKey();
                        break;
                    }
                    if (rowDefToSwap != null) {
                        rowsTable.unselect((Object)rowDef);
                        rowOrder.remove(rowDef);
                        rowOrder.remove(rowDefToSwap);
                        rowOrder.put(rowDef, rowDefIndex + 1);
                        rowOrder.put(rowDefToSwap, rowDefIndex);
                        rows.sort(new Object[]{"label"}, new boolean[]{true});
                        rowsTable.refreshRowCache();
                        rowsTable.select((Object)rowDef);
                    }
                }
            }
        });
        rowsTable.setSizeFull();
        rowUpButton.setSizeFull();
        rowDownButton.setSizeFull();
        rowsAddButton.setSizeFull();
        rowsEditButton.setSizeFull();
        rowsRemoveButton.setSizeFull();
        rowsTable.setImmediate(true);
        rowsTable.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                boolean somethingSelected = rowsTable.getValue() != null;
                rowsRemoveButton.setEnabled(somethingSelected);
                rowsEditButton.setEnabled(somethingSelected);
                rowsAddButton.setEnabled(true);
                rowUpButton.setEnabled(somethingSelected && (Integer)rowOrder.get(rowsTable.getValue()) > 0);
                rowDownButton.setEnabled(somethingSelected && (Integer)rowOrder.get(rowsTable.getValue()) < rowOrder.size() - 1);
            }
        });
        FormLayout baseFormLayout = new FormLayout();
        baseFormLayout.addComponent((Component)titleField);
        baseFormLayout.addComponent((Component)refreshSecondsField);
        FormLayout columnTableFormLayout = new FormLayout();
        columnTableFormLayout.addComponent((Component)columnsAddButton);
        columnTableFormLayout.addComponent((Component)columnsEditButton);
        columnTableFormLayout.addComponent((Component)columnsRemoveButton);
        columnTableFormLayout.addComponent((Component)columnUpButton);
        columnTableFormLayout.addComponent((Component)columnDownButton);
        FormLayout rowTableFormLayout = new FormLayout();
        rowTableFormLayout.addComponent((Component)rowsAddButton);
        rowTableFormLayout.addComponent((Component)rowsEditButton);
        rowTableFormLayout.addComponent((Component)rowsRemoveButton);
        rowTableFormLayout.addComponent((Component)rowUpButton);
        rowTableFormLayout.addComponent((Component)rowDownButton);
        baseFormLayout.setMargin(true);
        columnTableFormLayout.setMargin(true);
        rowTableFormLayout.setMargin(true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.setSizeFull();
        gridLayout.setColumns(4);
        gridLayout.setRows(1);
        gridLayout.setMargin(true);
        gridLayout.addComponent((Component)rowsTable);
        gridLayout.addComponent((Component)rowTableFormLayout);
        gridLayout.addComponent((Component)columnsTable);
        gridLayout.addComponent((Component)columnTableFormLayout);
        gridLayout.setColumnExpandRatio(1, 0.5f);
        gridLayout.setColumnExpandRatio(2, 1.0f);
        gridLayout.setColumnExpandRatio(3, 0.5f);
        gridLayout.setColumnExpandRatio(4, 1.0f);
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponent((Component)baseFormLayout);
        verticalLayout.addComponent((Component)gridLayout);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setMargin(true);
        horizontalLayout.setSpacing(true);
        horizontalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        Button cancel = new Button("Cancel");
        cancel.setDescription("Cancel editing properties");
        cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                SurveillanceViewConfigurationWindow.this.close();
            }
        });
        cancel.setClickShortcut(27, null);
        horizontalLayout.addComponent((Component)cancel);
        horizontalLayout.setExpandRatio((Component)cancel, 1.0f);
        horizontalLayout.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
        Button ok = new Button("Save");
        ok.setDescription("Save properties and close");
        ok.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                if (!titleField.isValid()) {
                    ((SurveillanceViewsConfigUI)SurveillanceViewConfigurationWindow.this.getUI()).notifyMessage("Error", "Please use an unique title", Notification.Type.ERROR_MESSAGE);
                    return;
                }
                if (!refreshSecondsField.isValid()) {
                    ((SurveillanceViewsConfigUI)SurveillanceViewConfigurationWindow.this.getUI()).notifyMessage("Error", "Please enter a valid number in the \"Refresh seconds\" field", Notification.Type.ERROR_MESSAGE);
                    return;
                }
                if (columns.getItemIds().isEmpty() || rows.getItemIds().isEmpty()) {
                    ((SurveillanceViewsConfigUI)SurveillanceViewConfigurationWindow.this.getUI()).notifyMessage("Error", "You must define at least one row category and one column category", Notification.Type.ERROR_MESSAGE);
                    return;
                }
                View finalView = new View();
                for (ColumnDef columnDef : columns.getItemIds()) {
                    finalView.getColumns().add(columnDef);
                }
                for (RowDef rowDef : rows.getItemIds()) {
                    finalView.getRows().add(rowDef);
                }
                finalView.setName((String)titleField.getValue());
                finalView.setRefreshSeconds(Integer.valueOf(Integer.parseInt((String)refreshSecondsField.getValue())));
                saveActionListener.save(finalView);
                SurveillanceViewConfigurationWindow.this.close();
            }
        });
        ok.setClickShortcut(13, null);
        horizontalLayout.addComponent((Component)ok);
        verticalLayout.addComponent((Component)horizontalLayout);
        this.setContent((Component)verticalLayout);
    }

    public static interface SaveActionListener {
        public void save(View var1);
    }
}

