/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.service;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.Order;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.criteria.restrictions.SqlRestriction;
import org.opennms.features.vaadin.surveillanceviews.config.SurveillanceViewProvider;
import org.opennms.features.vaadin.surveillanceviews.model.Category;
import org.opennms.features.vaadin.surveillanceviews.model.View;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.GraphDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.SurveillanceStatus;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class DefaultSurveillanceViewService
implements SurveillanceViewService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSurveillanceViewService.class);
    private NodeDao m_nodeDao;
    private ResourceDao m_resourceDao;
    private GraphDao m_graphDao;
    private NotificationDao m_notificationDao;
    private CategoryDao m_categoryDao;
    private AlarmDao m_alarmDao;
    private GroupDao m_groupDao;
    private OutageDao m_outageDao;
    private MonitoredServiceDao m_monitoredServiceDao;
    private TransactionOperations m_transactionOperations;
    ListeningExecutorService m_listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public void setNotificationDao(NotificationDao notificationDao) {
        this.m_notificationDao = notificationDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public void setGroupDao(GroupDao groupDao) {
        this.m_groupDao = groupDao;
    }

    public void setOutageDao(OutageDao outageDao) {
        this.m_outageDao = outageDao;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.m_transactionOperations = transactionOperations;
    }

    @Override
    public List<OnmsCategory> getOnmsCategories() {
        return (List)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<List<OnmsCategory>>(){

            public List<OnmsCategory> doInTransaction(TransactionStatus transactionStatus) {
                return DefaultSurveillanceViewService.this.m_categoryDao.findAll();
            }
        });
    }

    @Override
    public Set<OnmsCategory> getOnmsCategoriesFromViewCategories(final Collection<Category> viewCats) {
        return (Set)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<Set<OnmsCategory>>(){

            public Set<OnmsCategory> doInTransaction(TransactionStatus transactionStatus) {
                HashSet<OnmsCategory> categories = new HashSet<OnmsCategory>();
                for (Category viewCat : viewCats) {
                    OnmsCategory category = DefaultSurveillanceViewService.this.m_categoryDao.findByName(viewCat.getName());
                    if (category == null) {
                        throw new ObjectRetrievalFailureException(OnmsCategory.class, (Object)viewCat.getName(), "Unable to locate OnmsCategory named: " + viewCat.getName() + " as specified in the surveillance view configuration file", null);
                    }
                    categories.add(category);
                }
                return categories;
            }
        });
    }

    @Override
    public SurveillanceStatus[][] calculateCellStatus(final View view) {
        return (SurveillanceStatus[][])this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<SurveillanceStatus[][]>(){

            public SurveillanceStatus[][] doInTransaction(TransactionStatus transactionStatus) {
                SurveillanceStatus[][] cellStatus = new SurveillanceStatus[view.getRows().size()][view.getColumns().size()];
                for (int rowIndex = 0; rowIndex < view.getRows().size(); ++rowIndex) {
                    for (int colIndex = 0; colIndex < view.getColumns().size(); ++colIndex) {
                        SurveillanceStatus status;
                        Set<OnmsCategory> rowCategories = DefaultSurveillanceViewService.this.getOnmsCategoriesFromViewCategories(view.getRows().get(rowIndex).getCategories());
                        Set<OnmsCategory> columnCategories = DefaultSurveillanceViewService.this.getOnmsCategoriesFromViewCategories(view.getColumns().get(colIndex).getCategories());
                        cellStatus[rowIndex][colIndex] = status = DefaultSurveillanceViewService.this.m_nodeDao.findSurveillanceStatusByCategoryLists(rowCategories, columnCategories);
                    }
                }
                return cellStatus;
            }
        });
    }

    private static String createQuery(String nodeIdProperty, Set<OnmsCategory> rowCategories, Set<OnmsCategory> colCategories) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(nodeIdProperty + " in (select distinct cn.nodeId from category_node cn join categories c on cn.categoryId = c.categoryId where c.categoryName in (");
        Object[] questionMarks = new String[rowCategories.size()];
        Arrays.fill(questionMarks, "?");
        stringBuffer.append(String.join((CharSequence)",", (CharSequence[])questionMarks));
        stringBuffer.append("))");
        stringBuffer.append("and " + nodeIdProperty + " in (select distinct cn.nodeId from category_node cn join categories c on cn.categoryId = c.categoryId where c.categoryName in (");
        questionMarks = new String[colCategories.size()];
        Arrays.fill(questionMarks, "?");
        stringBuffer.append(String.join((CharSequence)",", (CharSequence[])questionMarks));
        stringBuffer.append("))");
        return stringBuffer.toString();
    }

    @Override
    public List<OnmsNode> getNodesForCategories(final Set<OnmsCategory> rowCategories, final Set<OnmsCategory> colCategories) {
        return (List)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<List<OnmsNode>>(){

            public List<OnmsNode> doInTransaction(TransactionStatus transactionStatus) {
                CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class);
                ArrayList parameters = new ArrayList(rowCategories.stream().map(OnmsCategory::getName).collect(Collectors.toList()));
                parameters.addAll(colCategories.stream().map(OnmsCategory::getName).collect(Collectors.toList()));
                Object[] types = new SqlRestriction.Type[parameters.size()];
                Arrays.fill(types, SqlRestriction.Type.STRING);
                criteriaBuilder.sql(DefaultSurveillanceViewService.createQuery("{alias}.nodeId", rowCategories, colCategories), (Object[])parameters.toArray(new String[parameters.size()]), (SqlRestriction.Type[])types);
                return DefaultSurveillanceViewService.this.m_nodeDao.findMatching(criteriaBuilder.toCriteria());
            }
        });
    }

    @Override
    public List<OnmsAlarm> getAlarmsForCategories(final Set<OnmsCategory> rowCategories, final Set<OnmsCategory> colCategories) {
        return (List)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<List<OnmsAlarm>>(){

            public List<OnmsAlarm> doInTransaction(TransactionStatus transactionStatus) {
                CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsAlarm.class);
                criteriaBuilder.alias("node", "node");
                criteriaBuilder.ne("node.type", (Object)"D");
                criteriaBuilder.limit(Integer.valueOf(100));
                criteriaBuilder.distinct();
                ArrayList parameters = new ArrayList(rowCategories.stream().map(OnmsCategory::getName).collect(Collectors.toList()));
                parameters.addAll(colCategories.stream().map(OnmsCategory::getName).collect(Collectors.toList()));
                Object[] types = new SqlRestriction.Type[parameters.size()];
                Arrays.fill(types, SqlRestriction.Type.STRING);
                criteriaBuilder.sql(DefaultSurveillanceViewService.createQuery("{alias}.nodeId", rowCategories, colCategories), (Object[])parameters.toArray(new String[parameters.size()]), (SqlRestriction.Type[])types);
                return DefaultSurveillanceViewService.this.m_alarmDao.findMatching(criteriaBuilder.toCriteria());
            }
        });
    }

    @Override
    public List<OnmsNotification> getNotificationsForCategories(final Set<OnmsCategory> rowCategories, final Set<OnmsCategory> colCategories, final Map<OnmsNotification, String> customSeverity) {
        return (List)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<List<OnmsNotification>>(){

            public List<OnmsNotification> doInTransaction(TransactionStatus transactionStatus) {
                Date fifteenMinutesAgo = new Date(System.currentTimeMillis() - 900000L);
                Date oneWeekAgo = new Date(System.currentTimeMillis() - 604800000L);
                customSeverity.clear();
                ArrayList<OnmsNotification> notifications = new ArrayList<OnmsNotification>();
                notifications.addAll(DefaultSurveillanceViewService.this.getNotificationsWithCriterias(rowCategories, colCategories, customSeverity, "Critical", new Restriction[]{Restrictions.isNull((String)"respondTime"), Restrictions.le((String)"pageTime", (Object)fifteenMinutesAgo)}));
                notifications.addAll(DefaultSurveillanceViewService.this.getNotificationsWithCriterias(rowCategories, colCategories, customSeverity, "Minor", new Restriction[]{Restrictions.isNull((String)"respondTime"), Restrictions.gt((String)"pageTime", (Object)fifteenMinutesAgo)}));
                notifications.addAll(DefaultSurveillanceViewService.this.getNotificationsWithCriterias(rowCategories, colCategories, customSeverity, "Normal", new Restriction[]{Restrictions.isNotNull((String)"respondTime"), Restrictions.gt((String)"pageTime", (Object)oneWeekAgo)}));
                return notifications;
            }
        });
    }

    @Override
    public List<SurveillanceViewService.NodeRtc> getNodeRtcsForCategories(final Set<OnmsCategory> rowCategories, final Set<OnmsCategory> colCategories) {
        return (List)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<List<SurveillanceViewService.NodeRtc>>(){

            public List<SurveillanceViewService.NodeRtc> doInTransaction(TransactionStatus transactionStatus) {
                CriteriaBuilder outageCriteriaBuilder = new CriteriaBuilder(OnmsOutage.class);
                outageCriteriaBuilder.alias("monitoredService", "monitoredService", Alias.JoinType.INNER_JOIN);
                outageCriteriaBuilder.alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.INNER_JOIN);
                outageCriteriaBuilder.alias("monitoredService.ipInterface.node", "node", Alias.JoinType.INNER_JOIN);
                outageCriteriaBuilder.eq("monitoredService.status", (Object)"A");
                outageCriteriaBuilder.ne("ipInterface.isManaged", (Object)"D");
                outageCriteriaBuilder.ne("node.type", (Object)"D");
                CriteriaBuilder serviceCriteriaBuilder = new CriteriaBuilder(OnmsMonitoredService.class);
                serviceCriteriaBuilder.alias("ipInterface", "ipInterface", Alias.JoinType.INNER_JOIN);
                serviceCriteriaBuilder.alias("ipInterface.node", "node", Alias.JoinType.INNER_JOIN);
                serviceCriteriaBuilder.alias("serviceType", "serviceType", Alias.JoinType.INNER_JOIN);
                serviceCriteriaBuilder.alias("currentOutages", "currentOutages", Alias.JoinType.LEFT_JOIN);
                serviceCriteriaBuilder.eq("status", (Object)"A");
                serviceCriteriaBuilder.ne("ipInterface.isManaged", (Object)"D");
                serviceCriteriaBuilder.ne("node.type", (Object)"D");
                ArrayList parameters = new ArrayList(rowCategories.stream().map(OnmsCategory::getName).collect(Collectors.toList()));
                parameters.addAll(colCategories.stream().map(OnmsCategory::getName).collect(Collectors.toList()));
                Object[] types = new SqlRestriction.Type[parameters.size()];
                Arrays.fill(types, SqlRestriction.Type.STRING);
                serviceCriteriaBuilder.sql(DefaultSurveillanceViewService.createQuery("node2_.nodeId", rowCategories, colCategories), (Object[])parameters.toArray(new String[parameters.size()]), (SqlRestriction.Type[])types);
                return DefaultSurveillanceViewService.this.getNodeListForCriteria(serviceCriteriaBuilder.toCriteria(), outageCriteriaBuilder.toCriteria());
            }
        });
    }

    @Override
    public Map<OnmsResourceType, List<OnmsResource>> getResourceTypeMapForNodeId(final int nodeId) {
        return (Map)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<Map<OnmsResourceType, List<OnmsResource>>>(){

            public Map<OnmsResourceType, List<OnmsResource>> doInTransaction(TransactionStatus transactionStatus) {
                OnmsNode node = (OnmsNode)DefaultSurveillanceViewService.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                OnmsResource resource = DefaultSurveillanceViewService.this.m_resourceDao.getResourceForNode(node);
                LinkedHashMap<OnmsResourceType, List<OnmsResource>> resourceTypeMap = new LinkedHashMap<OnmsResourceType, List<OnmsResource>>();
                for (OnmsResource childResource : resource.getChildResources()) {
                    if (!resourceTypeMap.containsKey(childResource.getResourceType())) {
                        resourceTypeMap.put(childResource.getResourceType(), new LinkedList());
                    }
                    ((List)resourceTypeMap.get(childResource.getResourceType())).add(DefaultSurveillanceViewService.checkLabelForQuotes(childResource));
                }
                return resourceTypeMap;
            }
        });
    }

    @Override
    public Map<OnmsResourceType, List<OnmsResource>> getResourceTypeMapForNodeId(String nodeId) {
        return this.getResourceTypeMapForNodeId(Integer.parseInt(nodeId));
    }

    @Override
    public Map<String, String> getGraphResultsForResourceId(final ResourceId resourceId) {
        return (Map)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<Map<String, String>>(){

            public Map<String, String> doInTransaction(TransactionStatus transactionStatus) {
                OnmsResource resource = DefaultSurveillanceViewService.this.m_resourceDao.getResourceById(resourceId);
                PrefabGraph[] queries = DefaultSurveillanceViewService.this.m_graphDao.getPrefabGraphsForResource(resource);
                TreeMap<String, String> graphResults = new TreeMap<String, String>();
                for (PrefabGraph query : queries) {
                    graphResults.put(query.getName(), query.getName());
                }
                return graphResults;
            }
        });
    }

    @Override
    public View selectDefaultViewForUsername(String username) {
        LOG.debug("Looking for surveillance view that matches user '{}'", (Object)username);
        View userView = SurveillanceViewProvider.getInstance().getView(username);
        if (userView != null) {
            LOG.debug("Found surveillance view '{}' matching user name '{}'", (Object)userView.getName(), (Object)username);
            return userView;
        }
        List groups = this.m_groupDao.findGroupsForUser(username);
        for (Group group : groups) {
            View groupView = SurveillanceViewProvider.getInstance().getView(group.getName());
            if (groupView == null) continue;
            LOG.debug("Found surveillance view '{}' matching group '{}' name for user '{}'", new Object[]{groupView.getName(), group.getName(), username});
            return groupView;
        }
        View defaultView = SurveillanceViewProvider.getInstance().getDefaultView();
        if (defaultView == null) {
            String message = "There is no default surveillance view and we could not find a surveillance view for the user's username ('" + username + "') or any of their groups";
            LOG.warn(message);
            throw new ObjectRetrievalFailureException(View.class, (Object)message);
        }
        LOG.debug("Did not find a surveillance view matching the user's user name or one of their group names.  Using the default view for user '{}'", (Object)username);
        return defaultView;
    }

    @Override
    public ListeningExecutorService getExecutorService() {
        return this.m_listeningExecutorService;
    }

    @Override
    public OnmsNode getNodeForId(int id) {
        return (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(id));
    }

    private static Double calculateAvailability(long serviceCount, long downMillisCount) {
        long upMillis = serviceCount * 86400000L - downMillisCount;
        return (double)upMillis / (double)(serviceCount * 86400000L);
    }

    private static Map<OnmsMonitoredService, Long> calculateServiceDownTime(Date periodEnd, Date periodStart, List<OnmsOutage> outages) {
        HashMap<OnmsMonitoredService, Long> map = new HashMap<OnmsMonitoredService, Long>();
        for (OnmsOutage outage : outages) {
            if (map.get(outage.getMonitoredService()) == null) {
                map.put(outage.getMonitoredService(), 0L);
            }
            Date begin = outage.getIfLostService().before(periodStart) ? periodStart : outage.getIfLostService();
            Date end = outage.getIfRegainedService() == null || !outage.getIfRegainedService().before(periodEnd) ? periodEnd : outage.getIfRegainedService();
            Long count = (Long)map.get(outage.getMonitoredService());
            count = count + (end.getTime() - begin.getTime());
            map.put(outage.getMonitoredService(), count);
        }
        return map;
    }

    private List<SurveillanceViewService.NodeRtc> getNodeListForCriteria(Criteria serviceCriteria, Criteria outageCriteria) {
        ArrayList<Order> ordersService = new ArrayList<Order>();
        ordersService.add(Order.asc((String)"node.label"));
        ordersService.add(Order.asc((String)"node.id"));
        ordersService.add(Order.asc((String)"ipInterface.ipAddress"));
        ordersService.add(Order.asc((String)"serviceType.name"));
        serviceCriteria.setOrders(ordersService);
        Date periodEnd = new Date(System.currentTimeMillis());
        Date periodStart = new Date(periodEnd.getTime() - 86400000L);
        outageCriteria.addRestriction((Restriction)Restrictions.any((Restriction[])new Restriction[]{Restrictions.isNull((String)"ifRegainedService"), Restrictions.ge((String)"ifLostService", (Object)periodStart), Restrictions.ge((String)"ifRegainedService", (Object)periodStart)}));
        ArrayList<Order> ordersOutage = new ArrayList<Order>();
        ordersOutage.add(Order.asc((String)"monitoredService"));
        ordersOutage.add(Order.asc((String)"ifLostService"));
        outageCriteria.setOrders(ordersOutage);
        List services = this.m_monitoredServiceDao.findMatching(serviceCriteria);
        List outages = this.m_outageDao.findMatching(outageCriteria);
        Map<OnmsMonitoredService, Long> serviceDownTime = DefaultSurveillanceViewService.calculateServiceDownTime(periodEnd, periodStart, outages);
        ArrayList<SurveillanceViewService.NodeRtc> model = new ArrayList<SurveillanceViewService.NodeRtc>();
        OnmsNode lastNode = null;
        int serviceCount = 0;
        int serviceDownCount = 0;
        long downMillisCount = 0L;
        for (OnmsMonitoredService service : services) {
            Long downMillis;
            if (!service.getIpInterface().getNode().equals(lastNode) && lastNode != null) {
                Double availability = DefaultSurveillanceViewService.calculateAvailability(serviceCount, downMillisCount);
                model.add(new SurveillanceViewService.NodeRtc(lastNode, serviceCount, serviceDownCount, availability));
                serviceCount = 0;
                serviceDownCount = 0;
                downMillisCount = 0L;
            }
            ++serviceCount;
            if (service.isDown()) {
                ++serviceDownCount;
            }
            if ((downMillis = serviceDownTime.get(service)) != null) {
                downMillisCount += downMillis.longValue();
            }
            lastNode = service.getIpInterface().getNode();
        }
        if (lastNode != null) {
            Double availability = DefaultSurveillanceViewService.calculateAvailability(serviceCount, downMillisCount);
            model.add(new SurveillanceViewService.NodeRtc(lastNode, serviceCount, serviceDownCount, availability));
        }
        return model;
    }

    private List<OnmsNotification> getNotificationsWithCriterias(Set<OnmsCategory> rowCategories, Set<OnmsCategory> colCategories, Map<OnmsNotification, String> customSeverity, String severity, Restriction ... criterias) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNotification.class);
        criteriaBuilder.alias("node", "node");
        ArrayList parameters = new ArrayList(rowCategories.stream().map(OnmsCategory::getName).collect(Collectors.toList()));
        parameters.addAll(colCategories.stream().map(OnmsCategory::getName).collect(Collectors.toList()));
        Object[] types = new SqlRestriction.Type[parameters.size()];
        Arrays.fill(types, SqlRestriction.Type.STRING);
        criteriaBuilder.sql(DefaultSurveillanceViewService.createQuery("{alias}.nodeId", rowCategories, colCategories), (Object[])parameters.toArray(new String[parameters.size()]), (SqlRestriction.Type[])types);
        criteriaBuilder.ne("node.type", (Object)"D");
        criteriaBuilder.orderBy("pageTime", false);
        Criteria myCriteria = criteriaBuilder.toCriteria();
        for (Restriction criteria : criterias) {
            myCriteria.addRestriction(criteria);
        }
        List notifications = this.m_notificationDao.findMatching(myCriteria);
        for (OnmsNotification onmsNotification : notifications) {
            customSeverity.put(onmsNotification, severity);
        }
        return notifications;
    }

    private static OnmsResource checkLabelForQuotes(OnmsResource childResource) {
        String lbl = Util.convertToJsSafeString((String)childResource.getLabel());
        OnmsResource resource = new OnmsResource(childResource.getName(), lbl, childResource.getResourceType(), childResource.getAttributes(), childResource.getPath());
        resource.setParent(childResource.getParent());
        resource.setEntity(childResource.getEntity());
        resource.setLink(childResource.getLink());
        return resource;
    }
}

