/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui;

import com.vaadin.annotations.JavaScript;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.vaadin.surveillanceviews.config.SurveillanceViewProvider;
import org.opennms.features.vaadin.surveillanceviews.model.View;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.SurveillanceView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@Theme(value="opennms")
@Title(value="OpenNMS Surveillance Views")
@JavaScript(value={"../../../../lib/jquery/dist/jquery.js", "../../../../lib/bootstrap/dist/js/bootstrap.js"})
public class SurveillanceViewsUI
extends UI {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewsUI.class);
    private SurveillanceViewService m_surveillanceViewService;

    protected void init(VaadinRequest request) {
        SurveillanceViewProvider.getInstance().load();
        VerticalLayout rootLayout = new VerticalLayout();
        rootLayout.setSpacing(true);
        String viewName = request.getParameter("viewName");
        boolean dashboard = request.getParameter("dashboard") != null && "true".equals(request.getParameter("dashboard"));
        String username = request.getRemoteUser();
        View view = viewName == null ? this.m_surveillanceViewService.selectDefaultViewForUsername(username) : SurveillanceViewProvider.getInstance().getView(viewName);
        this.setPollInterval(1000);
        boolean isDashboardRole = true;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && !context.toString().contains("ROLE_DASHBOARD")) {
            isDashboardRole = false;
        }
        LOG.debug("User {} is in dashboard role? {}", (Object)username, (Object)isDashboardRole);
        rootLayout.addComponent((Component)new SurveillanceView(view, this.m_surveillanceViewService, dashboard, !isDashboardRole));
        this.setContent((Component)rootLayout);
        Page.getCurrent().getJavaScript().execute("function receiveMessage(event){\nif(event.origin !== window.location.origin){ return; }\n\nevent.source.postMessage( (document.getElementById('surveillance-window').offsetHeight + 17) + 'px', window.location.origin )\n}\nwindow.addEventListener(\"message\", receiveMessage, false);");
    }

    public void setSurveillanceViewService(SurveillanceViewService surveillanceViewService) {
        this.m_surveillanceViewService = surveillanceViewService;
    }
}

