/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.service;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.vaadin.surveillanceviews.model.Category;
import org.opennms.features.vaadin.surveillanceviews.model.View;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.SurveillanceStatus;

public interface SurveillanceViewService {
    public List<OnmsCategory> getOnmsCategories();

    public SurveillanceStatus[][] calculateCellStatus(View var1);

    public Set<OnmsCategory> getOnmsCategoriesFromViewCategories(Collection<Category> var1);

    public List<OnmsAlarm> getAlarmsForCategories(Set<OnmsCategory> var1, Set<OnmsCategory> var2);

    public List<OnmsNotification> getNotificationsForCategories(Set<OnmsCategory> var1, Set<OnmsCategory> var2, Map<OnmsNotification, String> var3);

    public List<OnmsNode> getNodesForCategories(Set<OnmsCategory> var1, Set<OnmsCategory> var2);

    public List<NodeRtc> getNodeRtcsForCategories(Set<OnmsCategory> var1, Set<OnmsCategory> var2);

    public Map<OnmsResourceType, List<OnmsResource>> getResourceTypeMapForNodeId(String var1);

    public Map<String, String> getGraphResultsForResourceId(String var1);

    public Map<OnmsResourceType, List<OnmsResource>> getResourceTypeMapForNodeId(int var1);

    public View selectDefaultViewForUsername(String var1);

    public ListeningExecutorService getExecutorService();

    public OnmsNode getNodeForId(int var1);

    public static class NodeRtc {
        private static final DecimalFormat AVAILABILITY_FORMAT = new DecimalFormat("0.000%");
        private OnmsNode m_node;
        private int m_serviceCount;
        private int m_downServiceCount;
        private double m_availability;

        public NodeRtc(OnmsNode node, int serviceCount, int downServiceCount, double availability) {
            this.m_node = node;
            this.m_serviceCount = serviceCount;
            this.m_downServiceCount = downServiceCount;
            this.m_availability = availability;
        }

        public double getAvailability() {
            return this.m_availability;
        }

        public String getAvailabilityAsString() {
            return AVAILABILITY_FORMAT.format(this.m_availability);
        }

        public int getDownServiceCount() {
            return this.m_downServiceCount;
        }

        public OnmsNode getNode() {
            return this.m_node;
        }

        public int getServiceCount() {
            return this.m_serviceCount;
        }

        public String toString() {
            return this.m_node.getLabel() + ": " + this.m_downServiceCount + " of " + this.m_serviceCount + ": " + this.getAvailabilityAsString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeRtc nodeRtc = (NodeRtc)o;
            if (Double.compare(nodeRtc.m_availability, this.m_availability) != 0) {
                return false;
            }
            if (this.m_downServiceCount != nodeRtc.m_downServiceCount) {
                return false;
            }
            if (this.m_serviceCount != nodeRtc.m_serviceCount) {
                return false;
            }
            return !(this.m_node != null ? !this.m_node.equals(nodeRtc.m_node) : nodeRtc.m_node != null);
        }

        public int hashCode() {
            int result = this.m_node != null ? this.m_node.hashCode() : 0;
            result = 31 * result + this.m_serviceCount;
            result = 31 * result + this.m_downServiceCount;
            long temp = Double.doubleToLongBits(this.m_availability);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        static {
            AVAILABILITY_FORMAT.setMultiplier(100);
        }
    }
}

